/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.service.http;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.talend.sdk.component.api.service.http.Configurer;

public class HttpRequest {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private static final Configurer.ConfigurerConfiguration EMPTY_CONFIGURER_OPTIONS = new Configurer.ConfigurerConfiguration(){

        public Object[] configuration() {
            return EMPTY_ARRAY;
        }

        public <T> T get(String name, Class<T> type) {
            return null;
        }
    };
    private final String url;
    private final String methodType;
    private final Collection<String> queryParams;
    private final Map<String, String> headers;
    private final Configurer configurer;
    private final Map<String, Function<Object[], Object>> configurerOptions;
    private final BiFunction<String, Object[], Optional<byte[]>> payloadProvider;
    private final Object[] params;
    private volatile Optional<byte[]> bodyCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<byte[]> getBody() {
        if (this.bodyCache != null) {
            return this.bodyCache;
        }
        HttpRequest httpRequest = this;
        synchronized (httpRequest) {
            if (this.bodyCache != null) {
                return this.bodyCache;
            }
            this.bodyCache = this.doGetBody();
            return this.bodyCache;
        }
    }

    private Optional<byte[]> doGetBody() {
        if (this.payloadProvider == null) {
            return Optional.empty();
        }
        return this.payloadProvider.apply(this.headers.get("content-type"), this.params);
    }

    public Configurer.ConfigurerConfiguration getConfigurationOptions() {
        final Map<String, Object> options = this.configurerOptions.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Function)e.getValue()).apply(this.params)));
        return this.configurerOptions.isEmpty() ? EMPTY_CONFIGURER_OPTIONS : new Configurer.ConfigurerConfiguration(){

            public Object[] configuration() {
                return options.values().toArray(new Object[0]);
            }

            public <T> T get(String name, Class<T> type) {
                return type.cast(options.get(name));
            }
        };
    }

    public String getUrl() {
        return this.url;
    }

    public String getMethodType() {
        return this.methodType;
    }

    public Collection<String> getQueryParams() {
        return this.queryParams;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public Configurer getConfigurer() {
        return this.configurer;
    }

    public Map<String, Function<Object[], Object>> getConfigurerOptions() {
        return this.configurerOptions;
    }

    public BiFunction<String, Object[], Optional<byte[]>> getPayloadProvider() {
        return this.payloadProvider;
    }

    public Object[] getParams() {
        return this.params;
    }

    public Optional<byte[]> getBodyCache() {
        return this.bodyCache;
    }

    public void setBodyCache(Optional<byte[]> bodyCache) {
        this.bodyCache = bodyCache;
    }

    public String toString() {
        return "HttpRequest(url=" + this.getUrl() + ", methodType=" + this.getMethodType() + ", queryParams=" + this.getQueryParams() + ", headers=" + this.getHeaders() + ", configurer=" + this.getConfigurer() + ", configurerOptions=" + this.getConfigurerOptions() + ", payloadProvider=" + this.getPayloadProvider() + ", params=" + Arrays.deepToString(this.getParams()) + ", bodyCache=" + this.getBodyCache() + ")";
    }

    public HttpRequest(String url, String methodType, Collection<String> queryParams, Map<String, String> headers, Configurer configurer, Map<String, Function<Object[], Object>> configurerOptions, BiFunction<String, Object[], Optional<byte[]>> payloadProvider, Object[] params, Optional<byte[]> bodyCache) {
        this.url = url;
        this.methodType = methodType;
        this.queryParams = queryParams;
        this.headers = headers;
        this.configurer = configurer;
        this.configurerOptions = configurerOptions;
        this.payloadProvider = payloadProvider;
        this.params = params;
        this.bodyCache = bodyCache;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpRequest)) {
            return false;
        }
        HttpRequest other = (HttpRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$methodType = this.getMethodType();
        String other$methodType = other.getMethodType();
        if (this$methodType == null ? other$methodType != null : !this$methodType.equals(other$methodType)) {
            return false;
        }
        Collection<String> this$queryParams = this.getQueryParams();
        Collection<String> other$queryParams = other.getQueryParams();
        if (this$queryParams == null ? other$queryParams != null : !((Object)this$queryParams).equals(other$queryParams)) {
            return false;
        }
        Map<String, String> this$headers = this.getHeaders();
        Map<String, String> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        Configurer this$configurer = this.getConfigurer();
        Configurer other$configurer = other.getConfigurer();
        if (this$configurer == null ? other$configurer != null : !this$configurer.equals(other$configurer)) {
            return false;
        }
        Map<String, Function<Object[], Object>> this$configurerOptions = this.getConfigurerOptions();
        Map<String, Function<Object[], Object>> other$configurerOptions = other.getConfigurerOptions();
        if (this$configurerOptions == null ? other$configurerOptions != null : !((Object)this$configurerOptions).equals(other$configurerOptions)) {
            return false;
        }
        BiFunction<String, Object[], Optional<byte[]>> this$payloadProvider = this.getPayloadProvider();
        BiFunction<String, Object[], Optional<byte[]>> other$payloadProvider = other.getPayloadProvider();
        if (this$payloadProvider == null ? other$payloadProvider != null : !this$payloadProvider.equals(other$payloadProvider)) {
            return false;
        }
        return Arrays.deepEquals(this.getParams(), other.getParams());
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $methodType = this.getMethodType();
        result = result * 59 + ($methodType == null ? 43 : $methodType.hashCode());
        Collection<String> $queryParams = this.getQueryParams();
        result = result * 59 + ($queryParams == null ? 43 : ((Object)$queryParams).hashCode());
        Map<String, String> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        Configurer $configurer = this.getConfigurer();
        result = result * 59 + ($configurer == null ? 43 : $configurer.hashCode());
        Map<String, Function<Object[], Object>> $configurerOptions = this.getConfigurerOptions();
        result = result * 59 + ($configurerOptions == null ? 43 : ((Object)$configurerOptions).hashCode());
        BiFunction<String, Object[], Optional<byte[]>> $payloadProvider = this.getPayloadProvider();
        result = result * 59 + ($payloadProvider == null ? 43 : $payloadProvider.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getParams());
        return result;
    }
}

