/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.configuration;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.talend.sdk.component.api.configuration.Option;
import org.talend.sdk.component.runtime.manager.ParameterMeta;

public class ConfigurationMapper {
    public Map<String, String> map(List<ParameterMeta> nestedParameters, Object instance) {
        return this.map(nestedParameters, instance, new HashMap<Integer, Integer>());
    }

    private Map<String, String> map(List<ParameterMeta> nestedParameters, Object instance, Map<Integer, Integer> indexes) {
        if (nestedParameters == null) {
            return Collections.emptyMap();
        }
        return nestedParameters.stream().map(param -> {
            Object value = ConfigurationMapper.getValue(instance, param.getName());
            if (value == null) {
                return Collections.emptyMap();
            }
            switch (param.getType()) {
                case OBJECT: {
                    return this.map(param.getNestedParameters(), value, indexes);
                }
                case ARRAY: {
                    List<Object> values = Collection.class.isInstance(value) ? (List<Object>)Collection.class.cast(value) : Arrays.asList((Object[])Object[].class.cast(value));
                    int arrayIndex = indexes.keySet().size();
                    AtomicInteger valuesIndex = new AtomicInteger(0);
                    Map<String, String> config = values.stream().map(item -> {
                        indexes.put(arrayIndex, valuesIndex.getAndIncrement());
                        Map<String, String> res = param.getNestedParameters().stream().filter(ConfigurationMapper::isPrimitive).map(p -> new AbstractMap.SimpleImmutableEntry<String, Object>(ConfigurationMapper.evaluateIndexes(p.getPath(), indexes), ConfigurationMapper.getValue(item, p.getName()))).filter(p -> p.getValue() != null).collect(Collectors.toMap(AbstractMap.SimpleImmutableEntry::getKey, p -> String.valueOf(p.getValue())));
                        res.putAll(this.map(param.getNestedParameters().stream().filter(p -> !ConfigurationMapper.isPrimitive(p)).collect(Collectors.toList()), item, indexes));
                        return res;
                    }).flatMap(m -> m.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                    indexes.clear();
                    return config;
                }
            }
            return Collections.singletonMap(ConfigurationMapper.evaluateIndexes(param.getPath(), indexes), value.toString());
        }).flatMap(m -> m.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static boolean isPrimitive(ParameterMeta next) {
        return Stream.of(ParameterMeta.Type.STRING, ParameterMeta.Type.BOOLEAN, ParameterMeta.Type.ENUM, ParameterMeta.Type.NUMBER).anyMatch(v -> v == next.getType());
    }

    private static Object getValue(Object instance, String name) {
        if (name.endsWith("[${index}]")) {
            return instance;
        }
        AccessibleObject declaredField = null;
        for (Class<?> current = instance.getClass(); current != null && current != Object.class; current = current.getSuperclass()) {
            Optional<Field> field = Stream.of(current.getDeclaredFields()).filter(it -> Optional.ofNullable(it.getAnnotation(Option.class)).map(Option::value).filter(val -> !val.isEmpty()).orElseGet(it::getName).equals(name)).findFirst();
            if (!field.isPresent()) {
                continue;
            }
            declaredField = field.get();
            break;
        }
        if (declaredField == null) {
            throw new IllegalArgumentException("No field '" + name + "' in " + instance);
        }
        if (!declaredField.isAccessible()) {
            ((Field)declaredField).setAccessible(true);
        }
        try {
            return ((Field)declaredField).get(instance);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    private static String evaluateIndexes(String path, Map<Integer, Integer> indexes) {
        if (indexes == null || indexes.isEmpty()) {
            return path;
        }
        String placeholder = "${index}";
        String p = path;
        StringBuilder evaluatedPath = new StringBuilder();
        for (Map.Entry<Integer, Integer> index : indexes.entrySet()) {
            int i = p.indexOf("${index}");
            evaluatedPath.append(p, 0, i).append(index.getValue()).append("]");
            p = p.substring(i + "${index}".length() + 1);
        }
        return evaluatedPath.append(p).toString();
    }
}

