/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.service;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.talend.sdk.component.api.service.Service;
import org.talend.sdk.component.api.service.configuration.Configuration;
import org.talend.sdk.component.api.service.injector.Injector;
import org.talend.sdk.component.runtime.manager.reflect.ReflectionService;
import org.talend.sdk.component.runtime.serialization.SerializableService;

public class InjectorImpl
implements Serializable,
Injector {
    private final String plugin;
    private final ReflectionService reflectionService;
    private final Map<Class<?>, Object> services;

    public <T> T inject(T instance) {
        if (instance == null) {
            return null;
        }
        this.doInject(instance.getClass(), instance);
        return instance;
    }

    private <T> void doInject(Class<?> type, T instance) {
        if (type == Object.class || type == null) {
            return;
        }
        Field[] fields = type.getDeclaredFields();
        Stream.of(fields).filter(field -> !Modifier.isStatic(field.getModifiers())).filter(field -> field.isAnnotationPresent(Service.class)).peek(f -> {
            if (!f.isAccessible()) {
                f.setAccessible(true);
            }
        }).forEach(field -> {
            Object value = this.services.get(field.getType());
            if (value != null) {
                try {
                    field.set(instance, value);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        });
        Stream.of(fields).filter(field -> !Modifier.isStatic(field.getModifiers())).filter(field -> field.isAnnotationPresent(Configuration.class)).peek(field -> {
            if (Supplier.class != field.getType() || !ParameterizedType.class.isInstance(field.getGenericType())) {
                throw new IllegalArgumentException("Field " + field + " is not a Supplier<X>,\nit will not be injected otherwise it wouldn't be up to date,\ndid you mean Supplier<" + field.getType() + "> ?");
            }
        }).peek(f -> {
            if (!f.isAccessible()) {
                f.setAccessible(true);
            }
        }).forEach(field -> {
            try {
                Class configClass = (Class)Class.class.cast(((ParameterizedType)ParameterizedType.class.cast(field.getGenericType())).getActualTypeArguments()[0]);
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Supplier<Object> supplier = () -> {
                    try {
                        return this.reflectionService.createConfigFactory(this.services, loader, this.reflectionService.createContextualSupplier(loader), field.getName(), field.getAnnotation(Configuration.class), field.getAnnotations(), configClass).apply(Collections.emptyMap());
                    }
                    catch (NoSuchMethodException e) {
                        throw new IllegalStateException(e);
                    }
                };
                field.set(instance, supplier);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(e);
            }
        });
        if (type.getSuperclass() != type) {
            this.doInject(type.getSuperclass(), instance);
        }
    }

    Object writeReplace() throws ObjectStreamException {
        return new SerializableService(this.plugin, Injector.class.getName());
    }

    public InjectorImpl(String plugin, ReflectionService reflectionService, Map<Class<?>, Object> services) {
        this.plugin = plugin;
        this.reflectionService = reflectionService;
        this.services = services;
    }
}

