/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.service.http;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.bind.Jsonb;
import org.talend.sdk.component.api.service.http.Codec;
import org.talend.sdk.component.api.service.http.Configurer;
import org.talend.sdk.component.api.service.http.ConfigurerOption;
import org.talend.sdk.component.api.service.http.ContentType;
import org.talend.sdk.component.api.service.http.Decoder;
import org.talend.sdk.component.api.service.http.Encoder;
import org.talend.sdk.component.api.service.http.Header;
import org.talend.sdk.component.api.service.http.Headers;
import org.talend.sdk.component.api.service.http.HttpMethod;
import org.talend.sdk.component.api.service.http.Path;
import org.talend.sdk.component.api.service.http.Query;
import org.talend.sdk.component.api.service.http.QueryFormat;
import org.talend.sdk.component.api.service.http.QueryParams;
import org.talend.sdk.component.api.service.http.Request;
import org.talend.sdk.component.api.service.http.Response;
import org.talend.sdk.component.api.service.http.Url;
import org.talend.sdk.component.api.service.http.UseConfigurer;
import org.talend.sdk.component.runtime.base.lang.exception.InvocationExceptionWrapper;
import org.talend.sdk.component.runtime.manager.reflect.Constructors;
import org.talend.sdk.component.runtime.manager.reflect.ReflectionService;
import org.talend.sdk.component.runtime.manager.service.MediaTypeComparator;
import org.talend.sdk.component.runtime.manager.service.http.ExecutionContext;
import org.talend.sdk.component.runtime.manager.service.http.HttpRequestCreator;
import org.talend.sdk.component.runtime.manager.service.http.JAXB;
import org.talend.sdk.component.runtime.manager.service.http.JAXBManager;
import org.talend.sdk.component.runtime.manager.service.http.codec.CodecMatcher;
import org.talend.sdk.component.runtime.manager.service.http.codec.JAXBEncoder;
import org.talend.sdk.component.runtime.manager.service.http.codec.JsonpDecoder;
import org.talend.sdk.component.runtime.manager.service.http.codec.JsonpEncoder;

public class RequestParser {
    private static final String PATH_RESERVED_CHARACTERS = "=@/:!$&'(),;~";
    private static final String QUERY_RESERVED_CHARACTERS = "?/,";
    private final ReflectionService reflections;
    private final Map<Class<?>, Object> services;
    private final Encoder jsonpEncoder;
    private final Decoder jsonpDecoder;
    private final JAXBManager jaxb = JAXB.ACTIVE ? new JAXBManager() : null;
    private volatile CodecMatcher<Encoder> codecMatcher = new CodecMatcher();

    public RequestParser(ReflectionService reflections, Jsonb jsonb, Map<Class<?>, Object> services) {
        this.reflections = reflections;
        this.services = services;
        this.jsonpEncoder = new JsonpEncoder(jsonb);
        this.jsonpDecoder = new JsonpDecoder(jsonb);
    }

    public ExecutionContext parse(Method method) {
        if (!method.isAnnotationPresent(Request.class)) {
            throw new IllegalStateException("Method '" + method.getName() + "' need to be annotated with @Request");
        }
        Request request = method.getAnnotation(Request.class);
        Configurer configurerInstance = this.findConfigurerInstance(method);
        if (this.jaxb != null) {
            this.jaxb.initJaxbContext(method);
        }
        Codec codec = Optional.ofNullable(method.getAnnotation(Codec.class)).orElseGet(() -> method.getDeclaringClass().getAnnotation(Codec.class));
        Map<String, Encoder> encoders = this.createEncoder(codec);
        Map<String, Decoder> decoders = this.createDecoder(codec);
        PathProvider pathProvider = new PathProvider();
        QueryParamsProvider queryParamsProvider = new QueryParamsProvider();
        HeadersProvider headersProvider = new HeadersProvider();
        HashMap<String, Function<Object[], Object>> configurerOptionsProvider = new HashMap<String, Function<Object[], Object>>();
        Integer httpMethod = null;
        Function<Object[], String> urlProvider = null;
        BiFunction<String, Object[], Optional<byte[]>> payloadProvider = null;
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            int index = i;
            if (parameters[i].isAnnotationPresent(HttpMethod.class)) {
                if (httpMethod != null) {
                    throw new IllegalStateException(method + "has two HttpMethod parameters");
                }
                httpMethod = index;
                continue;
            }
            if (parameters[i].isAnnotationPresent(Path.class)) {
                Path path = parameters[i].getAnnotation(Path.class);
                pathProvider.pathParams.put(i, new Encodable(path.value(), path.encode()));
                continue;
            }
            if (parameters[i].isAnnotationPresent(Url.class)) {
                if (urlProvider != null) {
                    throw new IllegalStateException(method + "has two Url parameters");
                }
                urlProvider = params -> {
                    String url = String.valueOf(params[index]);
                    if (url != null && url.endsWith("/")) {
                        url = url.substring(0, url.length() - 1);
                    }
                    return url;
                };
                continue;
            }
            if (parameters[i].isAnnotationPresent(QueryParams.class)) {
                QueryParams params2 = parameters[i].getAnnotation(QueryParams.class);
                queryParamsProvider.queries.put(i, new QueryEncodable("", params2.encode(), params2.format()));
                continue;
            }
            if (parameters[i].isAnnotationPresent(Query.class)) {
                Query query = parameters[i].getAnnotation(Query.class);
                queryParamsProvider.queries.put(i, new QueryEncodable(query.value(), query.encode(), query.format()));
                continue;
            }
            if (parameters[i].isAnnotationPresent(Headers.class)) {
                headersProvider.headers.put(i, "");
                continue;
            }
            if (parameters[i].isAnnotationPresent(Header.class)) {
                headersProvider.headers.put(i, parameters[i].getAnnotation(Header.class).value());
                continue;
            }
            if (parameters[i].isAnnotationPresent(ConfigurerOption.class)) {
                configurerOptionsProvider.putIfAbsent(parameters[i].getAnnotation(ConfigurerOption.class).value(), params -> params[index]);
                continue;
            }
            if (payloadProvider != null) {
                throw new IllegalArgumentException(method + " has two payload parameters");
            }
            payloadProvider = this.buildPayloadProvider(encoders, i);
        }
        boolean isResponse = method.getReturnType() == Response.class;
        Class<?> responseType = isResponse ? ((ParameterizedType)ParameterizedType.class.cast(method.getGenericReturnType())).getActualTypeArguments()[0] : method.getReturnType();
        Integer httpMethodIndex = httpMethod;
        Function<Object[], String> httpMethodProvider = params -> httpMethodIndex == null ? request.method() : Optional.ofNullable(params[httpMethodIndex]).map(String::valueOf).orElse(request.method());
        String pathTemplate = request.path();
        if (pathTemplate.startsWith("/")) {
            pathTemplate = pathTemplate.substring(1, pathTemplate.length());
        }
        if (pathTemplate.endsWith("/")) {
            pathTemplate = pathTemplate.substring(0, pathTemplate.length() - 1);
        }
        return new ExecutionContext(new HttpRequestCreator(httpMethodProvider, urlProvider, pathTemplate, pathProvider, queryParamsProvider, headersProvider, payloadProvider, configurerInstance, configurerOptionsProvider), responseType, isResponse, decoders);
    }

    private BiFunction<String, Object[], Optional<byte[]>> buildPayloadProvider(Map<String, Encoder> encoders, int index) {
        return (contentType, params) -> {
            Object payload = params[index];
            if (payload == null) {
                return Optional.empty();
            }
            if (byte[].class.isInstance(payload)) {
                return Optional.of(byte[].class.cast(payload));
            }
            if (encoders.size() == 1) {
                return Optional.of(((Encoder)encoders.values().iterator().next()).encode(payload));
            }
            return Optional.of(this.codecMatcher.select(encoders, (String)contentType).encode(payload));
        };
    }

    private Configurer findConfigurerInstance(Method m) {
        UseConfigurer configurer = Optional.ofNullable(m.getAnnotation(UseConfigurer.class)).orElseGet(() -> m.getDeclaringClass().getAnnotation(UseConfigurer.class));
        try {
            return configurer == null ? null : (Configurer)configurer.value().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            throw InvocationExceptionWrapper.toRuntimeException((InvocationTargetException)e);
        }
    }

    static Class<?> toClassType(Type type) {
        ParameterizedType pt;
        Class cType = null;
        if (Class.class.isInstance(type)) {
            cType = (Class)Class.class.cast(type);
        } else if (ParameterizedType.class.isInstance(type) && (pt = (ParameterizedType)ParameterizedType.class.cast(type)).getRawType() == Response.class && pt.getActualTypeArguments().length == 1 && Class.class.isInstance(pt.getActualTypeArguments()[0])) {
            cType = (Class)Class.class.cast(pt.getActualTypeArguments()[0]);
        }
        return cType;
    }

    private static String queryEncode(String value) {
        return RequestParser.componentEncode(QUERY_RESERVED_CHARACTERS, value);
    }

    private static String componentEncode(String reservedChars, String value) {
        StringBuilder buffer = new StringBuilder();
        StringBuilder bufferToEncode = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char currentChar = value.charAt(i);
            if (reservedChars.indexOf(currentChar) != -1) {
                if (bufferToEncode.length() > 0) {
                    buffer.append(RequestParser.urlEncode(bufferToEncode.toString()));
                    bufferToEncode.setLength(0);
                }
                buffer.append(currentChar);
                continue;
            }
            bufferToEncode.append(currentChar);
        }
        if (bufferToEncode.length() > 0) {
            buffer.append(RequestParser.urlEncode(bufferToEncode.toString()));
        }
        return buffer.toString();
    }

    private static String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    private Map<String, Encoder> createEncoder(Codec codec) {
        HashMap<String, Encoder> encoders = new HashMap<String, Encoder>();
        if (codec != null && codec.encoder().length != 0) {
            encoders.putAll(Arrays.stream(codec.encoder()).filter(Objects::nonNull).collect(Collectors.toMap(encoder -> encoder.getAnnotation(ContentType.class) != null ? encoder.getAnnotation(ContentType.class).value() : "*/*", encoder -> {
                try {
                    Constructor<?> constructor = Constructors.findConstructor(encoder);
                    Function<Map<String, String>, Object[]> paramFactory = this.reflections.parameterFactory(constructor, this.services, null);
                    return (Encoder)Encoder.class.cast(constructor.newInstance(paramFactory.apply(Collections.emptyMap())));
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new IllegalArgumentException(e);
                }
                catch (InvocationTargetException e) {
                    throw InvocationExceptionWrapper.toRuntimeException((InvocationTargetException)e);
                }
            }, (k, v) -> {
                throw new IllegalArgumentException("Ambiguous key for: '" + k + "'");
            })));
        }
        if (this.jaxb != null && !this.jaxb.isEmpty()) {
            JAXBEncoder jaxbEncoder = this.jaxb.newEncoder();
            encoders.putIfAbsent("*/xml", jaxbEncoder);
            encoders.putIfAbsent("*/*+xml", jaxbEncoder);
        }
        encoders.putIfAbsent("*/json", this.jsonpEncoder);
        encoders.putIfAbsent("*/*+json", this.jsonpEncoder);
        encoders.putIfAbsent("*/*", value -> value == null ? new byte[]{} : String.valueOf(value).getBytes(StandardCharsets.UTF_8));
        return this.sortMap(encoders);
    }

    private Map<String, Decoder> createDecoder(Codec codec) {
        HashMap<String, Decoder> decoders = new HashMap<String, Decoder>();
        if (codec != null && codec.decoder().length != 0) {
            decoders.putAll(Arrays.stream(codec.decoder()).filter(Objects::nonNull).collect(Collectors.toMap(decoder -> decoder.getAnnotation(ContentType.class) != null ? decoder.getAnnotation(ContentType.class).value() : "*/*", decoder -> {
                try {
                    Constructor<?> constructor = Constructors.findConstructor(decoder);
                    Function<Map<String, String>, Object[]> paramFactory = this.reflections.parameterFactory(constructor, this.services, null);
                    return (Decoder)Decoder.class.cast(constructor.newInstance(paramFactory.apply(Collections.emptyMap())));
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new IllegalArgumentException(e);
                }
                catch (InvocationTargetException e) {
                    throw InvocationExceptionWrapper.toRuntimeException((InvocationTargetException)e);
                }
            }, (k, v) -> {
                throw new IllegalArgumentException("Ambiguous key for: '" + k + "'");
            })));
        }
        if (this.jaxb != null && !this.jaxb.isEmpty()) {
            Decoder jaxbDecoder = this.jaxb.newDecoder();
            decoders.putIfAbsent("*/xml", jaxbDecoder);
            decoders.putIfAbsent("*/*+xml", jaxbDecoder);
        }
        decoders.putIfAbsent("*/json", this.jsonpDecoder);
        decoders.putIfAbsent("*/*+json", this.jsonpDecoder);
        decoders.putIfAbsent("*/*", (value, expectedType) -> new String(value));
        return this.sortMap(decoders);
    }

    private <T> Map<String, T> sortMap(Map<String, T> entries) {
        ArrayList<String> keys = new ArrayList<String>(entries.keySet());
        keys.sort(new MediaTypeComparator(new ArrayList<String>(keys)));
        return keys.stream().collect(Collectors.toMap(k -> k.toLowerCase(Locale.ROOT), entries::get, (a, b) -> {
            throw new IllegalArgumentException(a + "/" + b);
        }, LinkedHashMap::new));
    }

    private static class PathProvider
    implements BiFunction<String, Object[], String> {
        private final Map<Integer, Encodable> pathParams = new LinkedHashMap<Integer, Encodable>();

        private String replacePlaceholder(String original, String placeholder, String value, boolean encode) {
            int start;
            String out = original;
            do {
                if ((start = out.indexOf(placeholder)) < 0) continue;
                String replacement = value;
                if (encode) {
                    replacement = PathProvider.pathEncode(replacement);
                }
                out = out.substring(0, start) + replacement + out.substring(start + placeholder.length());
            } while (start >= 0);
            return out;
        }

        private static String pathEncode(String value) {
            String result = RequestParser.componentEncode(RequestParser.PATH_RESERVED_CHARACTERS, value);
            if (result.indexOf(43) != -1) {
                result = result.replace("+", "%20");
            }
            if (result.contains("%2B")) {
                result = result.replace("%2B", "+");
            }
            return result;
        }

        @Override
        public String apply(String pathTemplate, Object[] args) {
            String path = pathTemplate;
            if (path == null || path.isEmpty()) {
                return path;
            }
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            for (Map.Entry<Integer, Encodable> param : this.pathParams.entrySet()) {
                path = this.replacePlaceholder(path, '{' + param.getValue().name + '}', String.valueOf(args[param.getKey()]), param.getValue().encode);
            }
            return path;
        }
    }

    private static class HeadersProvider
    implements Function<Object[], Map<String, String>> {
        private final Map<Integer, String> headers = new LinkedHashMap<Integer, String>();

        private HeadersProvider() {
        }

        @Override
        public Map<String, String> apply(Object[] args) {
            return this.headers.entrySet().stream().flatMap(entry -> {
                if (((String)entry.getValue()).isEmpty()) {
                    return args[(Integer)entry.getKey()] == null ? Stream.empty() : ((Map)args[(Integer)entry.getKey()]).entrySet().stream();
                }
                return Optional.ofNullable(args[(Integer)entry.getKey()]).map(v -> Stream.of(new AbstractMap.SimpleEntry(entry.getValue(), String.valueOf(v)))).orElse(null);
            }).filter(Objects::nonNull).filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> {
                throw new IllegalArgumentException("conflictings keys: " + a + '/' + b);
            }, LinkedHashMap::new));
        }
    }

    private static class QueryParamsProvider
    implements Function<Object[], Collection<String>> {
        private final Map<Integer, QueryEncodable> queries = new LinkedHashMap<Integer, QueryEncodable>();

        private QueryParamsProvider() {
        }

        @Override
        public Collection<String> apply(Object[] args) {
            return this.queries.entrySet().stream().flatMap(entry -> {
                if (((QueryEncodable)entry.getValue()).getName().isEmpty()) {
                    Map queryParams;
                    Map map = queryParams = args[(Integer)entry.getKey()] == null ? Collections.emptyMap() : (Map)Map.class.cast(args[(Integer)entry.getKey()]);
                    if (((QueryEncodable)entry.getValue()).isEncode()) {
                        return queryParams.entrySet().stream().filter(q -> q.getValue() != null).flatMap(it -> this.mapValues((QueryEncodable)entry.getValue(), (String)it.getKey(), it.getValue()));
                    }
                    return queryParams.entrySet().stream();
                }
                return Optional.ofNullable(args[(Integer)entry.getKey()]).map(v -> this.mapValues((QueryEncodable)entry.getValue(), ((QueryEncodable)entry.getValue()).getName(), v)).orElse(null);
            }).filter(Objects::nonNull).map(kv -> (String)kv.getKey() + "=" + kv.getValue()).collect(Collectors.toList());
        }

        private Stream<AbstractMap.SimpleEntry<String, String>> mapValues(QueryEncodable config, String key, Object v) {
            if (Collection.class.isInstance(v)) {
                Stream<String> collection = ((Collection)v).stream().filter(Objects::nonNull).map(String::valueOf).map(q -> config.isEncode() ? RequestParser.queryEncode(q) : q);
                switch (config.format) {
                    case MULTI: {
                        return collection.map(q -> new AbstractMap.SimpleEntry<String, String>(key, (String)q));
                    }
                    case CSV: {
                        return Stream.of(new AbstractMap.SimpleEntry<String, String>(key, String.join((CharSequence)",", collection.collect(Collectors.toList()))));
                    }
                }
                throw new IllegalArgumentException("Unsupported formatting: " + config);
            }
            String value = String.valueOf(v);
            if (config.isEncode()) {
                value = RequestParser.queryEncode(value);
            }
            return Stream.of(new AbstractMap.SimpleEntry<String, String>(key, value));
        }
    }

    private static class QueryEncodable
    extends Encodable {
        private final QueryFormat format;

        private QueryEncodable(String name, boolean encode, QueryFormat format) {
            super(name, encode);
            this.format = format;
        }

        public QueryFormat getFormat() {
            return this.format;
        }

        @Override
        public String toString() {
            return "RequestParser.QueryEncodable(format=" + this.getFormat() + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof QueryEncodable)) {
                return false;
            }
            QueryEncodable other = (QueryEncodable)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            QueryFormat this$format = this.getFormat();
            QueryFormat other$format = other.getFormat();
            return !(this$format == null ? other$format != null : !this$format.equals(other$format));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof QueryEncodable;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            QueryFormat $format = this.getFormat();
            result = result * 59 + ($format == null ? 43 : $format.hashCode());
            return result;
        }
    }

    private static class Encodable {
        private final String name;
        private final boolean encode;

        public Encodable(String name, boolean encode) {
            this.name = name;
            this.encode = encode;
        }

        public String getName() {
            return this.name;
        }

        public boolean isEncode() {
            return this.encode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Encodable)) {
                return false;
            }
            Encodable other = (Encodable)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            return this.isEncode() == other.isEncode();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Encodable;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            result = result * 59 + (this.isEncode() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "RequestParser.Encodable(name=" + this.getName() + ", encode=" + this.isEncode() + ")";
        }
    }
}

