/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.reflect.parameterenricher;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.talend.sdk.component.api.configuration.condition.ActiveIf;
import org.talend.sdk.component.api.configuration.condition.ActiveIfs;
import org.talend.sdk.component.api.configuration.condition.meta.Condition;
import org.talend.sdk.component.runtime.manager.reflect.parameterenricher.BaseParameterEnricher;

public class ConditionParameterEnricher
extends BaseParameterEnricher {
    private static final String META_PREFIX = "tcomp::condition::";

    public Map<String, String> onParameterAnnotation(String parameterName, Type parameterType, Annotation annotation) {
        Condition condition = annotation.annotationType().getAnnotation(Condition.class);
        if (condition != null) {
            String type = condition.value();
            if (ActiveIfs.class.isInstance(annotation)) {
                ActiveIfs activeIfs = (ActiveIfs)ActiveIfs.class.cast(annotation);
                Map metas = Stream.of(activeIfs.value()).map(ai -> this.onParameterAnnotation(parameterName, parameterType, (Annotation)ai)).collect(HashMap::new, (map, entry) -> {
                    String suffix = "::" + map.size() / 4;
                    map.putAll(entry.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey() + suffix, Map.Entry::getValue)));
                }, HashMap::putAll);
                metas.putAll(this.toMeta(annotation, type, m -> !"value".equals(m.getName())));
                return metas;
            }
            return this.toMeta(annotation, type, m -> true);
        }
        return Collections.emptyMap();
    }

    private Map<String, String> toMeta(Annotation annotation, String type, Predicate<Method> filter) {
        return Stream.of(annotation.annotationType().getMethods()).filter(m -> !m.getName().endsWith("evaluationStrategyOptions")).filter(m -> m.getDeclaringClass() == annotation.annotationType()).filter(filter).collect(Collectors.toMap(m -> META_PREFIX + type + "::" + m.getName(), m -> {
            try {
                ActiveIf.EvaluationStrategyOption[] options;
                Object invoke = m.invoke((Object)annotation, new Object[0]);
                if (String[].class.isInstance(invoke)) {
                    return Stream.of((Object[])String[].class.cast(invoke)).collect(Collectors.joining(","));
                }
                if (ActiveIf.class == m.getDeclaringClass() && "evaluationStrategy".equals(m.getName()) && (options = ((ActiveIf)ActiveIf.class.cast(annotation)).evaluationStrategyOptions()).length > 0) {
                    return String.valueOf(invoke) + Stream.of(options).map(o -> o.name() + '=' + o.value()).collect(Collectors.joining(",", "(", ")"));
                }
                return String.valueOf(invoke);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }));
    }
}

