/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.service.http;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.talend.sdk.component.api.service.http.Configurer;
import org.talend.sdk.component.api.service.http.Decoder;
import org.talend.sdk.component.api.service.http.HttpException;
import org.talend.sdk.component.api.service.http.Response;
import org.talend.sdk.component.runtime.manager.service.http.HttpRequest;
import org.talend.sdk.component.runtime.manager.service.http.HttpRequestCreator;
import org.talend.sdk.component.runtime.manager.service.http.codec.CodecMatcher;

public class ExecutionContext
implements BiFunction<String, Object[], Object> {
    private final HttpRequestCreator requestCreator;
    private final Type responseType;
    private final boolean isResponse;
    private final Map<String, Decoder> decoders;

    @Override
    public Object apply(String base, Object[] params) {
        HttpURLConnection urlConnection = null;
        HttpRequest request = this.requestCreator.apply(base, params);
        String queryParams = request.getQueryParams().entrySet().stream().map(kv -> (String)kv.getKey() + "=" + (String)kv.getValue()).collect(Collectors.joining("&"));
        URL url = new URL(request.getUrl() + (queryParams.isEmpty() ? "" : "?" + queryParams));
        urlConnection = (HttpURLConnection)HttpURLConnection.class.cast(url.openConnection());
        urlConnection.setRequestMethod(request.getMethodType());
        request.getHeaders().forEach(urlConnection::setRequestProperty);
        Optional<byte[]> requestBody = request.getBody();
        DefaultConnection connection = new DefaultConnection(urlConnection, requestBody.orElse(null), true);
        if (request.getConfigurer() != null) {
            request.getConfigurer().configure((Configurer.Connection)connection, request.getConfigurationOptions());
        }
        connection.postConfigure();
        if (requestBody.isPresent()) {
            urlConnection.setDoOutput(true);
            try (BufferedOutputStream outputStream = new BufferedOutputStream(urlConnection.getOutputStream());){
                outputStream.write(requestBody.orElse(null));
                outputStream.flush();
            }
        }
        int responseCode = urlConnection.getResponseCode();
        CodecMatcher<Decoder> decoderMatcher = new CodecMatcher<Decoder>();
        String contentType = urlConnection.getHeaderField("content-type");
        try {
            InputStream inputStream = urlConnection.getInputStream();
            if (this.getResponseType() == InputStream.class) {
                if (this.isResponse()) {
                    return new InputStreamResponse(responseCode, PassthroughDecoder.INSTANCE, this.headers(urlConnection), null, inputStream);
                }
                return inputStream;
            }
            byte[] response = ExecutionContext.slurp(inputStream, urlConnection.getContentLength());
            if (!this.isResponse()) {
                return byte[].class == this.getResponseType() ? response : (byte[])decoderMatcher.select(this.getDecoders(), contentType).decode(response, this.getResponseType());
            }
            return new ResponseImpl(responseCode, byte[].class == this.getResponseType() ? PassthroughDecoder.INSTANCE : decoderMatcher.select(this.getDecoders(), contentType), this.headers(urlConnection), null, response, this.getResponseType());
        }
        catch (IOException e) {
            try {
                byte[] error = Optional.ofNullable(urlConnection.getErrorStream()).map(s -> ExecutionContext.slurp(s, -1)).orElseGet(() -> Optional.ofNullable(e.getMessage()).map(s -> s.getBytes(StandardCharsets.UTF_8)).orElse(null));
                ResponseImpl errorResponse = new ResponseImpl(responseCode, byte[].class == this.getResponseType() ? PassthroughDecoder.INSTANCE : decoderMatcher.select(this.getDecoders(), contentType), this.headers(urlConnection), error, null, this.getResponseType());
                if (this.isResponse()) {
                    return errorResponse;
                }
                throw new HttpException(errorResponse);
            }
            catch (IOException e2) {
                if (urlConnection != null) {
                    urlConnection.disconnect();
                }
                throw new IllegalStateException(e2);
            }
        }
    }

    private static byte[] slurp(InputStream responseStream, int len) {
        byte[] buffer = new byte[8192];
        ByteArrayOutputStream responseBuffer = new ByteArrayOutputStream(len > 0 ? len : buffer.length);
        try (InputStream inputStream = responseStream;){
            int count;
            while ((count = inputStream.read(buffer)) >= 0) {
                responseBuffer.write(buffer, 0, count);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return responseBuffer.toByteArray();
    }

    private Map<String, List<String>> headers(HttpURLConnection urlConnection) {
        return urlConnection.getHeaderFields().keySet().stream().filter(Objects::nonNull).collect(Collectors.toMap(e -> e, urlConnection.getHeaderFields()::get, (k, v) -> {
            throw new IllegalArgumentException("Ambiguous key for: '" + k + "'");
        }, () -> new TreeMap(String.CASE_INSENSITIVE_ORDER)));
    }

    public HttpRequestCreator getRequestCreator() {
        return this.requestCreator;
    }

    public Type getResponseType() {
        return this.responseType;
    }

    public boolean isResponse() {
        return this.isResponse;
    }

    public Map<String, Decoder> getDecoders() {
        return this.decoders;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExecutionContext)) {
            return false;
        }
        ExecutionContext other = (ExecutionContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        HttpRequestCreator this$requestCreator = this.getRequestCreator();
        HttpRequestCreator other$requestCreator = other.getRequestCreator();
        if (this$requestCreator == null ? other$requestCreator != null : !this$requestCreator.equals(other$requestCreator)) {
            return false;
        }
        Type this$responseType = this.getResponseType();
        Type other$responseType = other.getResponseType();
        if (this$responseType == null ? other$responseType != null : !this$responseType.equals(other$responseType)) {
            return false;
        }
        if (this.isResponse() != other.isResponse()) {
            return false;
        }
        Map<String, Decoder> this$decoders = this.getDecoders();
        Map<String, Decoder> other$decoders = other.getDecoders();
        return !(this$decoders == null ? other$decoders != null : !((Object)this$decoders).equals(other$decoders));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExecutionContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HttpRequestCreator $requestCreator = this.getRequestCreator();
        result = result * 59 + ($requestCreator == null ? 43 : $requestCreator.hashCode());
        Type $responseType = this.getResponseType();
        result = result * 59 + ($responseType == null ? 43 : $responseType.hashCode());
        result = result * 59 + (this.isResponse() ? 79 : 97);
        Map<String, Decoder> $decoders = this.getDecoders();
        result = result * 59 + ($decoders == null ? 43 : ((Object)$decoders).hashCode());
        return result;
    }

    public String toString() {
        return "ExecutionContext(requestCreator=" + this.getRequestCreator() + ", responseType=" + this.getResponseType() + ", isResponse=" + this.isResponse() + ", decoders=" + this.getDecoders() + ")";
    }

    public ExecutionContext(HttpRequestCreator requestCreator, Type responseType, boolean isResponse, Map<String, Decoder> decoders) {
        this.requestCreator = requestCreator;
        this.responseType = responseType;
        this.isResponse = isResponse;
        this.decoders = decoders;
    }

    private static class ResponseImpl<T>
    extends BaseResponse<T> {
        private final byte[] responseBody;
        private final Type responseType;
        private volatile T bodyCache;

        private ResponseImpl(int status, Decoder decoder, Map<String, List<String>> headers, byte[] error, byte[] responseBody, Type responseType) {
            super(status, decoder, headers, error);
            this.responseBody = responseBody;
            this.responseType = responseType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T body() {
            if (this.responseBody == null || byte[].class == this.responseType) {
                return (T)this.responseBody;
            }
            if (this.bodyCache == null) {
                ResponseImpl responseImpl = this;
                synchronized (responseImpl) {
                    if (this.bodyCache == null) {
                        this.bodyCache = this.decoder.decode(this.responseBody, this.responseType);
                    }
                }
            }
            return this.bodyCache;
        }
    }

    private static class InputStreamResponse<T>
    extends BaseResponse<InputStream> {
        private final InputStream inputStream;

        private InputStreamResponse(int status, Decoder decoder, Map<String, List<String>> headers, byte[] error, InputStream inputStream) {
            super(status, decoder, headers, error);
            this.inputStream = inputStream;
        }

        public InputStream body() {
            return this.inputStream;
        }
    }

    private static abstract class BaseResponse<T>
    implements Response<T> {
        private final int status;
        protected final Decoder decoder;
        private Map<String, List<String>> headers;
        private byte[] error;

        public int status() {
            return this.status;
        }

        public Map<String, List<String>> headers() {
            return this.headers;
        }

        public <E> E error(Class<E> type) {
            if (this.error == null) {
                return null;
            }
            if (String.class == type) {
                return type.cast(new String(this.error));
            }
            return type.cast(this.decoder.decode(this.error, type));
        }

        public BaseResponse(int status, Decoder decoder, Map<String, List<String>> headers, byte[] error) {
            this.status = status;
            this.decoder = decoder;
            this.headers = headers;
            this.error = error;
        }
    }

    private static class PassthroughDecoder
    implements Decoder {
        private static final Decoder INSTANCE = new PassthroughDecoder();

        private PassthroughDecoder() {
        }

        public Object decode(byte[] value, Type expectedType) {
            return value;
        }
    }

    private static class DefaultConnection
    implements Configurer.Connection {
        private final HttpURLConnection urlConnection;
        private final byte[] payload;
        private boolean followRedirects;

        public String getMethod() {
            return this.urlConnection.getRequestMethod();
        }

        public String getUrl() {
            return this.urlConnection.getURL().toExternalForm();
        }

        public Map<String, List<String>> getHeaders() {
            return this.urlConnection.getHeaderFields();
        }

        public byte[] getPayload() {
            return this.payload;
        }

        public Configurer.Connection withHeader(String name, String value) {
            this.urlConnection.addRequestProperty(name, value);
            return this;
        }

        public Configurer.Connection withReadTimeout(int timeout) {
            this.urlConnection.setReadTimeout(timeout);
            return this;
        }

        public Configurer.Connection withConnectionTimeout(int timeout) {
            this.urlConnection.setConnectTimeout(timeout);
            return this;
        }

        public Configurer.Connection withoutFollowRedirects() {
            this.followRedirects = false;
            return this;
        }

        private void postConfigure() {
            this.urlConnection.setInstanceFollowRedirects(this.followRedirects);
        }

        public DefaultConnection(HttpURLConnection urlConnection, byte[] payload, boolean followRedirects) {
            this.urlConnection = urlConnection;
            this.payload = payload;
            this.followRedirects = followRedirects;
        }
    }
}

