/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.service;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.json.JsonBuilderFactory;
import javax.json.JsonReaderFactory;
import javax.json.JsonWriterFactory;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbConfig;
import javax.json.bind.spi.JsonbProvider;
import javax.json.spi.JsonProvider;
import javax.json.stream.JsonGeneratorFactory;
import javax.json.stream.JsonParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.api.record.RecordPointerFactory;
import org.talend.sdk.component.api.service.cache.LocalCache;
import org.talend.sdk.component.api.service.configuration.LocalConfiguration;
import org.talend.sdk.component.api.service.dependency.Resolver;
import org.talend.sdk.component.api.service.factory.ObjectFactory;
import org.talend.sdk.component.api.service.http.HttpClientFactory;
import org.talend.sdk.component.api.service.injector.Injector;
import org.talend.sdk.component.api.service.record.RecordBuilderFactory;
import org.talend.sdk.component.api.service.record.RecordService;
import org.talend.sdk.component.runtime.manager.asm.ProxyGenerator;
import org.talend.sdk.component.runtime.manager.json.PreComputedJsonpProvider;
import org.talend.sdk.component.runtime.manager.proxy.JavaProxyEnricherFactory;
import org.talend.sdk.component.runtime.manager.reflect.ReflectionService;
import org.talend.sdk.component.runtime.manager.service.ContainerInfo;
import org.talend.sdk.component.runtime.manager.service.InjectorImpl;
import org.talend.sdk.component.runtime.manager.service.LocalCacheService;
import org.talend.sdk.component.runtime.manager.service.LocalConfigurationService;
import org.talend.sdk.component.runtime.manager.service.ObjectFactoryImpl;
import org.talend.sdk.component.runtime.manager.service.RecordPointerFactoryImpl;
import org.talend.sdk.component.runtime.manager.service.RecordServiceImpl;
import org.talend.sdk.component.runtime.manager.service.ResolverImpl;
import org.talend.sdk.component.runtime.manager.service.configuration.PropertiesConfiguration;
import org.talend.sdk.component.runtime.manager.service.http.HttpClientFactoryImpl;
import org.talend.sdk.component.runtime.manager.xbean.registry.EnrichedPropertyEditorRegistry;

public class DefaultServiceProvider {
    private static final Logger log = LoggerFactory.getLogger(DefaultServiceProvider.class);
    private final ReflectionService reflections;
    private final JsonProvider jsonpProvider;
    private final JsonGeneratorFactory jsonpGeneratorFactory;
    private final JsonReaderFactory jsonpReaderFactory;
    private final JsonBuilderFactory jsonpBuilderFactory;
    private final JsonParserFactory jsonpParserFactory;
    private final JsonWriterFactory jsonpWriterFactory;
    private final JsonbConfig jsonbConfig;
    private final JsonbProvider jsonbProvider;
    private final ProxyGenerator proxyGenerator;
    private final JavaProxyEnricherFactory javaProxyEnricherFactory;
    private final Collection<LocalConfiguration> localConfigurations;
    private final Function<String, RecordBuilderFactory> recordBuilderFactoryProvider;
    private final EnrichedPropertyEditorRegistry propertyEditorRegistry;

    public <T> T lookup(String id, ClassLoader loader, Supplier<List<InputStream>> localConfigLookup, Function<String, Path> resolver, Class<T> api, AtomicReference<Map<Class<?>, Object>> services) {
        return api.cast(this.doLookup(id, loader, localConfigLookup, resolver, api, services));
    }

    private Object doLookup(String id, ClassLoader loader, Supplier<List<InputStream>> localConfigLookup, Function<String, Path> resolver, Class<?> api, AtomicReference<Map<Class<?>, Object>> services) {
        if (JsonProvider.class == api) {
            return new PreComputedJsonpProvider(id, this.jsonpProvider, this.jsonpParserFactory, this.jsonpWriterFactory, this.jsonpBuilderFactory, this.jsonpGeneratorFactory, this.jsonpReaderFactory);
        }
        if (JsonBuilderFactory.class == api) {
            return this.javaProxyEnricherFactory.asSerializable(loader, id, JsonBuilderFactory.class.getName(), this.jsonpBuilderFactory);
        }
        if (JsonParserFactory.class == api) {
            return this.javaProxyEnricherFactory.asSerializable(loader, id, JsonParserFactory.class.getName(), this.jsonpParserFactory);
        }
        if (JsonReaderFactory.class == api) {
            return this.javaProxyEnricherFactory.asSerializable(loader, id, JsonReaderFactory.class.getName(), this.jsonpReaderFactory);
        }
        if (JsonWriterFactory.class == api) {
            return this.javaProxyEnricherFactory.asSerializable(loader, id, JsonWriterFactory.class.getName(), this.jsonpWriterFactory);
        }
        if (JsonGeneratorFactory.class == api) {
            return this.javaProxyEnricherFactory.asSerializable(loader, id, JsonGeneratorFactory.class.getName(), this.jsonpGeneratorFactory);
        }
        if (Jsonb.class == api) {
            return Jsonb.class.cast(this.javaProxyEnricherFactory.asSerializable(loader, id, Jsonb.class.getName(), this.jsonbProvider.create().withProvider(this.jsonpProvider).withConfig(this.jsonbConfig).build()));
        }
        if (LocalConfiguration.class == api) {
            Stream<InputStream> localConfigs;
            Properties aggregatedLocalConfigs;
            ArrayList<LocalConfiguration> containerConfigurations = new ArrayList<LocalConfiguration>(this.localConfigurations);
            if (!Boolean.getBoolean("talend.component.configuration." + id + ".ignoreLocalConfiguration") && !(aggregatedLocalConfigs = this.aggregateConfigurations(localConfigs = localConfigLookup.get().stream())).isEmpty()) {
                containerConfigurations.add(new PropertiesConfiguration(aggregatedLocalConfigs));
            }
            return new LocalConfigurationService(containerConfigurations, id);
        }
        if (RecordBuilderFactory.class == api) {
            return this.recordBuilderFactoryProvider.apply(id);
        }
        if (ProxyGenerator.class == api) {
            return this.proxyGenerator;
        }
        if (LocalCache.class == api) {
            return new LocalCacheService(id);
        }
        if (Injector.class == api) {
            return new InjectorImpl(id, this.reflections, services.get());
        }
        if (HttpClientFactory.class == api) {
            return new HttpClientFactoryImpl(id, this.reflections, (Jsonb)Jsonb.class.cast(services.get().get(Jsonb.class)), services.get());
        }
        if (Resolver.class == api) {
            return new ResolverImpl(id, resolver);
        }
        if (ObjectFactory.class == api) {
            return new ObjectFactoryImpl(id, this.propertyEditorRegistry);
        }
        if (RecordPointerFactory.class == api) {
            return new RecordPointerFactoryImpl(id);
        }
        if (ContainerInfo.class == api) {
            return new ContainerInfo(id);
        }
        if (RecordService.class == api) {
            return new RecordServiceImpl(id, (RecordBuilderFactory)RecordBuilderFactory.class.cast(services.get().get(RecordBuilderFactory.class)));
        }
        return null;
    }

    private Properties aggregateConfigurations(Stream<InputStream> localConfigs) {
        AtomicReference re = new AtomicReference();
        Properties result = localConfigs.map(stream -> {
            Properties properties = new Properties();
            try {
                if (stream != null) {
                    properties.load((InputStream)stream);
                }
                Properties properties2 = properties;
                return properties2;
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
                RuntimeException runtimeException = (RuntimeException)re.get();
                if (runtimeException == null) {
                    runtimeException = new IllegalStateException("Can't read all local configurations");
                    re.set(runtimeException);
                }
                runtimeException.addSuppressed(e);
                Properties properties3 = properties;
                return properties3;
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }).sorted(Comparator.comparing(it -> Integer.parseInt(it.getProperty("_ordinal", "0")))).reduce(new Properties(), (p1, p2) -> {
            p1.putAll((Map<?, ?>)p2);
            return p1;
        });
        RuntimeException error = (RuntimeException)re.get();
        if (error != null) {
            throw error;
        }
        return result;
    }

    public DefaultServiceProvider(ReflectionService reflections, JsonProvider jsonpProvider, JsonGeneratorFactory jsonpGeneratorFactory, JsonReaderFactory jsonpReaderFactory, JsonBuilderFactory jsonpBuilderFactory, JsonParserFactory jsonpParserFactory, JsonWriterFactory jsonpWriterFactory, JsonbConfig jsonbConfig, JsonbProvider jsonbProvider, ProxyGenerator proxyGenerator, JavaProxyEnricherFactory javaProxyEnricherFactory, Collection<LocalConfiguration> localConfigurations, Function<String, RecordBuilderFactory> recordBuilderFactoryProvider, EnrichedPropertyEditorRegistry propertyEditorRegistry) {
        this.reflections = reflections;
        this.jsonpProvider = jsonpProvider;
        this.jsonpGeneratorFactory = jsonpGeneratorFactory;
        this.jsonpReaderFactory = jsonpReaderFactory;
        this.jsonpBuilderFactory = jsonpBuilderFactory;
        this.jsonpParserFactory = jsonpParserFactory;
        this.jsonpWriterFactory = jsonpWriterFactory;
        this.jsonbConfig = jsonbConfig;
        this.jsonbProvider = jsonbProvider;
        this.proxyGenerator = proxyGenerator;
        this.javaProxyEnricherFactory = javaProxyEnricherFactory;
        this.localConfigurations = localConfigurations;
        this.recordBuilderFactoryProvider = recordBuilderFactoryProvider;
        this.propertyEditorRegistry = propertyEditorRegistry;
    }
}

