/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.asm;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.ProtectionDomain;
import java.util.Objects;
import org.talend.sdk.component.classloader.ConfigurableClassLoader;

public class Unsafes {
    private static final Object UNSAFE;
    private static final Method UNSAFE_DEFINE_CLASS;

    public static <T> Class<T> defineAndLoadClass(ClassLoader classLoader, String proxyName, byte[] proxyBytes) {
        if (ConfigurableClassLoader.class.isInstance(classLoader)) {
            return ((ConfigurableClassLoader)ConfigurableClassLoader.class.cast(classLoader)).registerBytecode(proxyName.replace('/', '.'), proxyBytes);
        }
        Class<?> clazz = classLoader.getClass();
        AccessibleObject defineClassMethod = null;
        do {
            try {
                defineClassMethod = clazz.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            clazz = clazz.getSuperclass();
        } while (defineClassMethod == null && clazz != Object.class);
        if (defineClassMethod != null && !defineClassMethod.isAccessible()) {
            try {
                ((Method)defineClassMethod).setAccessible(true);
            }
            catch (RuntimeException re) {
                defineClassMethod = null;
            }
        }
        try {
            Class definedClass;
            if (defineClassMethod != null) {
                definedClass = (Class)((Method)defineClassMethod).invoke(classLoader, proxyName, proxyBytes, 0, proxyBytes.length);
            } else {
                Objects.requireNonNull(UNSAFE_DEFINE_CLASS, "No Unsafe.defineClass available");
                definedClass = (Class)UNSAFE_DEFINE_CLASS.invoke(UNSAFE, proxyName, proxyBytes, 0, proxyBytes.length, classLoader, null);
            }
            return Class.forName(definedClass.getName(), true, classLoader);
        }
        catch (InvocationTargetException le) {
            if (LinkageError.class.isInstance(le.getCause())) {
                try {
                    return Class.forName(proxyName.replace('/', '.'), true, classLoader);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            throw new IllegalStateException(le.getCause());
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    static {
        Class unsafeClass;
        try {
            unsafeClass = AccessController.doPrivileged(() -> {
                try {
                    return Thread.currentThread().getContextClassLoader().loadClass("sun.misc.Unsafe");
                }
                catch (Exception e) {
                    try {
                        return ClassLoader.getSystemClassLoader().loadClass("sun.misc.Unsafe");
                    }
                    catch (ClassNotFoundException e1) {
                        throw new IllegalStateException("Cannot get sun.misc.Unsafe", e);
                    }
                }
            });
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot get sun.misc.Unsafe class", e);
        }
        UNSAFE = AccessController.doPrivileged(() -> {
            try {
                Field field = unsafeClass.getDeclaredField("theUnsafe");
                field.setAccessible(true);
                return field.get(null);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        });
        UNSAFE_DEFINE_CLASS = UNSAFE != null ? AccessController.doPrivileged(() -> {
            try {
                return unsafeClass.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ClassLoader.class, ProtectionDomain.class);
            }
            catch (Exception e) {
                return null;
            }
        }) : null;
    }
}

