/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.service;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.talend.sdk.component.api.service.configuration.LocalConfiguration;
import org.talend.sdk.component.runtime.serialization.SerializableService;

public class LocalConfigurationService
implements LocalConfiguration,
Serializable {
    private final Collection<LocalConfiguration> rawDelegates;
    private final String plugin;

    public String get(String key) {
        return this.rawDelegates.stream().map(d -> Optional.ofNullable(d.get(this.plugin + "." + key)).orElseGet(() -> d.get(this.plugin + "_" + key.replace('.', '_')))).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public Set<String> keys() {
        return this.rawDelegates.stream().flatMap(d -> d.keys().stream()).filter(k -> k.startsWith(this.plugin + '.')).map(k -> k.substring(this.plugin.length() + 1)).collect(Collectors.toSet());
    }

    Object writeReplace() throws ObjectStreamException {
        return new SerializableService(this.plugin, LocalConfiguration.class.getName());
    }

    public LocalConfigurationService(Collection<LocalConfiguration> rawDelegates, String plugin) {
        this.rawDelegates = rawDelegates;
        this.plugin = plugin;
    }
}

