/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.service;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.stream.Stream;
import org.talend.sdk.component.api.service.Service;
import org.talend.sdk.component.api.service.injector.Injector;
import org.talend.sdk.component.runtime.serialization.SerializableService;

public class InjectorImpl
implements Serializable,
Injector {
    private final String plugin;
    private final Map<Class<?>, Object> services;

    public <T> T inject(T instance) {
        if (instance == null) {
            return null;
        }
        this.doInject(instance.getClass(), instance);
        return instance;
    }

    private <T> void doInject(Class<?> type, T instance) {
        if (type == Object.class || type == null) {
            return;
        }
        Stream.of(type.getDeclaredFields()).filter(field -> !Modifier.isStatic(field.getModifiers())).filter(field -> field.isAnnotationPresent(Service.class)).peek(f -> {
            if (!f.isAccessible()) {
                f.setAccessible(true);
            }
        }).forEach(field -> {
            Object value = this.services.get(field.getType());
            if (value != null) {
                try {
                    field.set(instance, value);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        });
        if (type.getSuperclass() != type) {
            this.doInject(type.getSuperclass(), instance);
        }
    }

    Object writeReplace() throws ObjectStreamException {
        return new SerializableService(this.plugin, Injector.class.getName());
    }

    public InjectorImpl(String plugin, Map<Class<?>, Object> services) {
        this.plugin = plugin;
        this.services = services;
    }
}

