/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.reflect.parameterenricher;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.talend.sdk.component.api.configuration.condition.ActiveIfs;
import org.talend.sdk.component.api.configuration.condition.meta.Condition;
import org.talend.sdk.component.spi.parameter.ParameterExtensionEnricher;

public class ConditionParameterEnricher
implements ParameterExtensionEnricher {
    private static final String META_PREFIX = "tcomp::condition::";

    public Map<String, String> onParameterAnnotation(String parameterName, Type parameterType, Annotation annotation) {
        Condition condition = annotation.annotationType().getAnnotation(Condition.class);
        if (condition != null) {
            String type = condition.value();
            if (ActiveIfs.class.isInstance(annotation)) {
                return Stream.of(((ActiveIfs)ActiveIfs.class.cast(annotation)).value()).map(ai -> this.onParameterAnnotation(parameterName, parameterType, (Annotation)ai)).collect(HashMap::new, (map, entry) -> {
                    String suffix = "::" + map.size() / 4;
                    map.putAll(entry.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey() + suffix, Map.Entry::getValue)));
                }, HashMap::putAll);
            }
            return Stream.of(annotation.annotationType().getMethods()).filter(m -> m.getDeclaringClass() == annotation.annotationType()).collect(Collectors.toMap(m -> META_PREFIX + type + "::" + m.getName(), m -> {
                try {
                    Object invoke = m.invoke((Object)annotation, new Object[0]);
                    if (String[].class.isInstance(invoke)) {
                        return Stream.of((Object[])String[].class.cast(invoke)).collect(Collectors.joining(","));
                    }
                    return String.valueOf(invoke);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new IllegalStateException(e);
                }
            }));
        }
        return Collections.emptyMap();
    }
}

