/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.reflect.parameterenricher;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.talend.sdk.component.api.configuration.action.meta.ActionRef;
import org.talend.sdk.component.api.service.ActionType;
import org.talend.sdk.component.spi.parameter.ParameterExtensionEnricher;

public class ActionParameterEnricher
implements ParameterExtensionEnricher {
    public static final String META_PREFIX = "tcomp::action::";

    public Map<String, String> onParameterAnnotation(String parameterName, Type parameterType, final Annotation annotation) {
        final ActionRef ref = annotation.annotationType().getAnnotation(ActionRef.class);
        if (ref == null) {
            return Collections.emptyMap();
        }
        final String type = ref.value().getAnnotation(ActionType.class).value();
        return new HashMap<String, String>(){
            {
                this.put(ActionParameterEnricher.META_PREFIX + type, ActionParameterEnricher.this.getValueString(ref.ref(), annotation));
                Optional.ofNullable(ActionParameterEnricher.this.getParametersString(annotation)).ifPresent(v -> this.put(ActionParameterEnricher.META_PREFIX + type + "::parameters", v));
            }
        };
    }

    private String getValueString(String method, Annotation annotation) {
        try {
            return String.valueOf(annotation.annotationType().getMethod(method, new Class[0]).invoke((Object)annotation, new Object[0]));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("No value for " + annotation);
        }
    }

    private String getParametersString(Annotation annotation) {
        try {
            return Stream.of((Object[])String[].class.cast(annotation.annotationType().getMethod("parameters", new Class[0]).invoke((Object)annotation, new Object[0]))).collect(Collectors.joining(","));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return null;
        }
    }
}

