/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.reflect;

import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.api.component.MigrationHandler;
import org.talend.sdk.component.api.component.Version;
import org.talend.sdk.component.runtime.base.lang.exception.InvocationExceptionWrapper;
import org.talend.sdk.component.runtime.manager.ComponentManager;
import org.talend.sdk.component.runtime.manager.ParameterMeta;
import org.talend.sdk.component.runtime.manager.reflect.ReflectionService;

public class MigrationHandlerFactory {
    private static final Logger log = LoggerFactory.getLogger(MigrationHandlerFactory.class);
    private static final MigrationHandler NO_MIGRATION = (incomingVersion, incomingData) -> incomingData;
    private final ReflectionService reflections;

    public MigrationHandler findMigrationHandler(List<ParameterMeta> parameterMetas, Class<?> type, ComponentManager.AllServices services) {
        MigrationHandler implicitMigrationHandler = Optional.ofNullable(parameterMetas).map(Collection::stream).orElseGet(Stream::empty).filter(p -> p.getMetadata().keySet().stream().anyMatch(k -> k.startsWith("tcomp::configurationtype::"))).filter(p -> Class.class.isInstance(p.getJavaType())).map(p -> {
            MigrationHandler handler = this.findMigrationHandler(Collections.emptyList(), (Class)Class.class.cast(p.getJavaType()), services);
            if (handler == NO_MIGRATION) {
                return null;
            }
            String prefix = p.getPath();
            return map -> {
                Map<String, String> result;
                String version = (String)map.get(String.format("%s.__version", prefix));
                if (version != null) {
                    Map migrated = Optional.ofNullable(handler.migrate(Integer.parseInt(version.trim()), map.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(prefix + '.')).collect(Collectors.toMap(e -> ((String)e.getKey()).substring(prefix.length() + 1), Map.Entry::getValue)))).orElseGet(Collections::emptyMap);
                    result = migrated.entrySet().stream().collect(Collectors.toMap(e -> prefix + '.' + (String)e.getKey(), Map.Entry::getValue));
                } else {
                    log.debug("No version for {} so skipping any potential migration", (Object)p.getJavaType().toString());
                    result = map;
                }
                return result;
            };
        }).filter(Objects::nonNull).reduce(NO_MIGRATION, (current, partial) -> (incomingVersion, incomingData) -> current.migrate(incomingVersion, (Map)partial.apply(incomingData)), (migrationHandler, migrationHandler2) -> (incomingVersion, incomingData) -> migrationHandler2.migrate(incomingVersion, migrationHandler.migrate(incomingVersion, incomingData)));
        return Optional.ofNullable(type.getAnnotation(Version.class)).map(Version::migrationHandler).filter(t -> t != MigrationHandler.class).flatMap(t -> Stream.of(t.getConstructors()).sorted((o1, o2) -> o2.getParameterCount() - o1.getParameterCount()).findFirst()).map(t -> services.getServices().computeIfAbsent(t.getDeclaringClass(), k -> {
            try {
                return t.newInstance(this.reflections.parameterFactory((Executable)t, services.getServices(), null).apply(Collections.emptyMap()));
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalArgumentException(e);
            }
            catch (InvocationTargetException e) {
                throw InvocationExceptionWrapper.toRuntimeException((InvocationTargetException)e);
            }
        })).map(MigrationHandler.class::cast).map(h -> {
            if (implicitMigrationHandler == NO_MIGRATION) {
                return h;
            }
            return (incomingVersion, incomingData) -> h.migrate(incomingVersion, implicitMigrationHandler.migrate(incomingVersion, incomingData));
        }).orElse(implicitMigrationHandler);
    }

    public MigrationHandlerFactory(ReflectionService reflections) {
        this.reflections = reflections;
    }
}

