/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.instrument.ClassFileTransformer;
import java.lang.management.ManagementFactory;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.json.JsonBuilderFactory;
import javax.json.JsonReaderFactory;
import javax.json.JsonWriterFactory;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbConfig;
import javax.json.bind.spi.JsonbProvider;
import javax.json.spi.JsonProvider;
import javax.json.stream.JsonGeneratorFactory;
import javax.json.stream.JsonParserFactory;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.apache.xbean.finder.AnnotationFinder;
import org.apache.xbean.finder.ClassFinder;
import org.apache.xbean.finder.archive.Archive;
import org.apache.xbean.finder.archive.ClasspathArchive;
import org.apache.xbean.finder.archive.FileArchive;
import org.apache.xbean.finder.archive.FilteredArchive;
import org.apache.xbean.finder.filter.ExcludeIncludeFilter;
import org.apache.xbean.finder.filter.Filter;
import org.apache.xbean.finder.filter.Filters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.api.component.Components;
import org.talend.sdk.component.api.component.Icon;
import org.talend.sdk.component.api.component.Version;
import org.talend.sdk.component.api.input.Emitter;
import org.talend.sdk.component.api.input.PartitionMapper;
import org.talend.sdk.component.api.internationalization.Internationalized;
import org.talend.sdk.component.api.processor.AfterGroup;
import org.talend.sdk.component.api.processor.Processor;
import org.talend.sdk.component.api.service.ActionType;
import org.talend.sdk.component.api.service.Service;
import org.talend.sdk.component.api.service.cache.LocalCache;
import org.talend.sdk.component.api.service.configuration.LocalConfiguration;
import org.talend.sdk.component.api.service.dependency.Resolver;
import org.talend.sdk.component.api.service.factory.ObjectFactory;
import org.talend.sdk.component.api.service.http.HttpClient;
import org.talend.sdk.component.api.service.http.HttpClientFactory;
import org.talend.sdk.component.api.service.http.Request;
import org.talend.sdk.component.api.service.injector.Injector;
import org.talend.sdk.component.classloader.ConfigurableClassLoader;
import org.talend.sdk.component.container.Container;
import org.talend.sdk.component.container.ContainerListener;
import org.talend.sdk.component.container.ContainerManager;
import org.talend.sdk.component.dependencies.maven.MvnDependencyListLocalRepositoryResolver;
import org.talend.sdk.component.jmx.JmxManager;
import org.talend.sdk.component.runtime.base.Delegated;
import org.talend.sdk.component.runtime.base.lang.exception.InvocationExceptionWrapper;
import org.talend.sdk.component.runtime.input.LocalPartitionMapper;
import org.talend.sdk.component.runtime.input.Mapper;
import org.talend.sdk.component.runtime.input.PartitionMapperImpl;
import org.talend.sdk.component.runtime.internationalization.InternationalizationServiceFactory;
import org.talend.sdk.component.runtime.manager.ComponentFamilyMeta;
import org.talend.sdk.component.runtime.manager.ComponentInstanceImpl;
import org.talend.sdk.component.runtime.manager.ContainerComponentRegistry;
import org.talend.sdk.component.runtime.manager.ParameterMeta;
import org.talend.sdk.component.runtime.manager.ServiceMeta;
import org.talend.sdk.component.runtime.manager.asm.ProxyGenerator;
import org.talend.sdk.component.runtime.manager.builtinparams.MaxBatchSizeParamBuilder;
import org.talend.sdk.component.runtime.manager.extension.ComponentContextImpl;
import org.talend.sdk.component.runtime.manager.extension.ComponentContexts;
import org.talend.sdk.component.runtime.manager.interceptor.InterceptorHandlerFacade;
import org.talend.sdk.component.runtime.manager.json.PreComputedJsonpProvider;
import org.talend.sdk.component.runtime.manager.proxy.JavaProxyEnricherFactory;
import org.talend.sdk.component.runtime.manager.reflect.Constructors;
import org.talend.sdk.component.runtime.manager.reflect.MigrationHandlerFactory;
import org.talend.sdk.component.runtime.manager.reflect.ParameterModelService;
import org.talend.sdk.component.runtime.manager.reflect.ReflectionService;
import org.talend.sdk.component.runtime.manager.service.InjectorImpl;
import org.talend.sdk.component.runtime.manager.service.LocalCacheService;
import org.talend.sdk.component.runtime.manager.service.LocalConfigurationService;
import org.talend.sdk.component.runtime.manager.service.ObjectFactoryImpl;
import org.talend.sdk.component.runtime.manager.service.ResolverImpl;
import org.talend.sdk.component.runtime.manager.service.http.HttpClientFactoryImpl;
import org.talend.sdk.component.runtime.manager.spi.ContainerListenerExtension;
import org.talend.sdk.component.runtime.manager.xbean.FilterFactory;
import org.talend.sdk.component.runtime.manager.xbean.KnownClassesFilter;
import org.talend.sdk.component.runtime.manager.xbean.KnownJarsFilter;
import org.talend.sdk.component.runtime.manager.xbean.NestedJarArchive;
import org.talend.sdk.component.runtime.output.ProcessorImpl;
import org.talend.sdk.component.runtime.serialization.LightContainer;
import org.talend.sdk.component.runtime.visitor.ModelListener;
import org.talend.sdk.component.runtime.visitor.ModelVisitor;
import org.talend.sdk.component.spi.component.ComponentExtension;
import org.w3c.dom.Document;

public class ComponentManager
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(ComponentManager.class);
    protected static final AtomicReference<ComponentManager> CONTEXTUAL_INSTANCE = new AtomicReference();
    private static final Components DEFAULT_COMPONENT = new Components(){

        public Class<? extends Annotation> annotationType() {
            return Components.class;
        }

        public String family() {
            return "";
        }

        public String[] categories() {
            return new String[]{"Misc"};
        }
    };
    protected final ContainerManager container;
    private final Filter classesFilter = Filters.prefixes((String[])((String[])Stream.concat(Stream.of("org.talend.sdk.component.api.", "org.talend.sdk.component.spi.", "javax.annotation.", "javax.json.", "org.talend.sdk.component.classloader.", "org.talend.sdk.component.runtime.", "org.slf4j.", "org.apache.johnzon."), ComponentManager.additionalContainerClasses()).toArray(String[]::new)));
    private final Filter beamClassesFilter = FilterFactory.and(this.classesFilter, Filters.prefixes((String[])new String[]{"org.apache.beam.runners.", "org.apache.beam.sdk.", "org.talend.sdk.component.runtime.beam.", "org.codehaus.jackson.", "com.fasterxml.jackson.annotation.", "com.fasterxml.jackson.core.", "com.fasterxml.jackson.databind.", "com.thoughtwors.paranamer.", "org.apache.commons.compress.", "org.tukaani.xz.", "org.objenesis.", "org.joda.time.", "org.xerial.snappy.", "avro.shaded.", "org.apache.avro."}));
    private final Filter excludeClassesFilter = Filters.prefixes((String[])new String[]{"org.apache.beam.sdk.io.", "org.apache.beam.sdk.extensions."});
    private final ParameterModelService parameterModelService = new ParameterModelService();
    private final InternationalizationServiceFactory internationalizationServiceFactory = new InternationalizationServiceFactory();
    private final JsonProvider jsonpProvider;
    private final JsonGeneratorFactory jsonpGeneratorFactory;
    private final JsonReaderFactory jsonpReaderFactory;
    private final JsonBuilderFactory jsonpBuilderFactory;
    private final JsonParserFactory jsonpParserFactory;
    private final JsonWriterFactory jsonpWriterFactory;
    private final JsonbProvider jsonbProvider;
    private final ProxyGenerator proxyGenerator = new ProxyGenerator();
    private final JavaProxyEnricherFactory javaProxyEnricherFactory = new JavaProxyEnricherFactory();
    private final ReflectionService reflections = new ReflectionService(this.parameterModelService);
    private final MigrationHandlerFactory migrationHandlerFactory = new MigrationHandlerFactory(this.reflections);
    private final Collection<ComponentExtension> extensions;
    private final Collection<ClassFileTransformer> transformers;
    private final Level logInfoLevelMapping;

    public ComponentManager(File m2, String dependenciesResource, String jmxNamePattern) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        this.jsonpProvider = JsonProvider.provider();
        this.jsonbProvider = JsonbProvider.provider();
        this.jsonpGeneratorFactory = (JsonGeneratorFactory)JsonGeneratorFactory.class.cast(this.javaProxyEnricherFactory.asSerializable(tccl, null, JsonGeneratorFactory.class.getName(), this.jsonpProvider.createGeneratorFactory(Collections.emptyMap())));
        this.jsonpReaderFactory = (JsonReaderFactory)JsonReaderFactory.class.cast(this.javaProxyEnricherFactory.asSerializable(tccl, null, JsonReaderFactory.class.getName(), this.jsonpProvider.createReaderFactory(Collections.emptyMap())));
        this.jsonpBuilderFactory = (JsonBuilderFactory)JsonBuilderFactory.class.cast(this.javaProxyEnricherFactory.asSerializable(tccl, null, JsonBuilderFactory.class.getName(), this.jsonpProvider.createBuilderFactory(Collections.emptyMap())));
        this.jsonpParserFactory = (JsonParserFactory)JsonParserFactory.class.cast(this.javaProxyEnricherFactory.asSerializable(tccl, null, JsonParserFactory.class.getName(), this.jsonpProvider.createParserFactory(Collections.emptyMap())));
        this.jsonpWriterFactory = (JsonWriterFactory)JsonWriterFactory.class.cast(this.javaProxyEnricherFactory.asSerializable(tccl, null, JsonWriterFactory.class.getName(), this.jsonpProvider.createWriterFactory(Collections.emptyMap())));
        this.logInfoLevelMapping = this.findLogInfoLevel();
        ContainerManager.ClassLoaderConfiguration defaultClassLoaderConfiguration = ContainerManager.ClassLoaderConfiguration.builder().parent(tccl).parentClassesFilter(name -> this.isContainerClass(this.beamClassesFilter, (String)name)).classesFilter(name -> !this.isContainerClass(this.classesFilter, (String)name)).supportsResourceDependencies(true).create();
        ContainerManager.ClassLoaderConfiguration beamClassLoaderConfiguration = ContainerManager.ClassLoaderConfiguration.builder().parent(tccl).parentClassesFilter(name -> this.isContainerClass(this.beamClassesFilter, (String)name)).classesFilter(name -> !this.isContainerClass(this.beamClassesFilter, (String)name)).supportsResourceDependencies(true).create();
        this.container = new ContainerManager(ContainerManager.DependenciesResolutionConfiguration.builder().resolver((org.talend.sdk.component.dependencies.Resolver)new MvnDependencyListLocalRepositoryResolver(dependenciesResource)).rootRepositoryLocation(m2).create(), defaultClassLoaderConfiguration, container -> {
            if (container.getDependencies() != null && Stream.of(container.getDependencies()).anyMatch(a -> a.getGroup().startsWith("org.apache.beam") || a.getArtifact().startsWith("beam-sdks-java-"))) {
                container.set(ContainerManager.ClassLoaderConfiguration.class, (Object)beamClassLoaderConfiguration);
            }
        }, this.logInfoLevelMapping);
        this.container.registerListener((ContainerListener)new Updater());
        Optional.ofNullable(jmxNamePattern).map(String::trim).filter(n -> !n.isEmpty()).ifPresent(p -> this.container.registerListener((ContainerListener)new JmxManager(this.container, p, ManagementFactory.getPlatformMBeanServer())));
        ComponentManager.toStream(ComponentManager.loadServiceProviders(ContainerListenerExtension.class, tccl)).peek(e -> e.setComponentManager(this)).forEach(arg_0 -> ((ContainerManager)this.container).registerListener(arg_0));
        this.extensions = ComponentManager.toStream(ComponentManager.loadServiceProviders(ComponentExtension.class, tccl)).filter(ComponentExtension::isActive).sorted(Comparator.comparing(ComponentExtension::priority)).collect(Collectors.toList());
        this.transformers = this.extensions.stream().flatMap(e -> e.getTransformers().stream()).collect(Collectors.toList());
    }

    private Level findLogInfoLevel() {
        if (Boolean.getBoolean("talend.component.manager.log.info")) {
            return Level.INFO;
        }
        try {
            ComponentManager.class.getClassLoader().loadClass("routines.TalendString");
            return Level.FINE;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return Level.INFO;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ComponentManager instance() {
        ComponentManager manager = CONTEXTUAL_INSTANCE.get();
        if (manager == null) {
            AtomicReference<ComponentManager> atomicReference = CONTEXTUAL_INSTANCE;
            synchronized (atomicReference) {
                if (CONTEXTUAL_INSTANCE.get() == null) {
                    final Thread shutdownHook = new Thread(ComponentManager.class.getName() + "-" + ComponentManager.class.hashCode()){

                        @Override
                        public void run() {
                            Optional.ofNullable(CONTEXTUAL_INSTANCE.get()).ifPresent(ComponentManager::close);
                        }
                    };
                    manager = new ComponentManager(ComponentManager.findM2(), "TALEND-INF/dependencies.txt", "org.talend.sdk.component:type=component,value=%s"){
                        private final AtomicBoolean closed;
                        {
                            String[] jars;
                            String componentClasspath;
                            super(m2, dependenciesResource, jmxNamePattern);
                            this.closed = new AtomicBoolean(false);
                            this.info("Creating the contextual ComponentManager instance " + ComponentManager.getIdentifiers());
                            if (!Boolean.getBoolean("component.manager.callers.skip")) {
                                this.addCallerAsPlugin();
                            }
                            if (!Boolean.getBoolean("component.manager.classpath.skip") && !(componentClasspath = ComponentManager.findClasspath().replace(File.pathSeparatorChar, ';')).isEmpty() && (jars = componentClasspath.split(";")).length > 1) {
                                Stream.of(jars).map(FileArchive::decode).map(File::new).filter(File::exists).filter(f -> !f.isDirectory() && f.getName().endsWith(".jar")).filter(f -> KnownJarsFilter.INSTANCE.test(f.getName())).filter(f -> !this.hasPlugin(this.container.buildAutoIdFromName(f.getName()))).forEach(jar -> this.addPlugin(jar.getAbsolutePath()));
                            }
                            this.container.getDefinedNestedPlugin().stream().filter(p -> !this.hasPlugin((String)p)).forEach(this::addPlugin);
                            this.info("Components: " + this.availablePlugins());
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void close() {
                            if (!this.closed.compareAndSet(false, true)) {
                                return;
                            }
                            try {
                                AtomicReference atomicReference = CONTEXTUAL_INSTANCE;
                                synchronized (atomicReference) {
                                    if (CONTEXTUAL_INSTANCE.compareAndSet(this, null)) {
                                        try {
                                            Runtime.getRuntime().removeShutdownHook(shutdownHook);
                                        }
                                        catch (IllegalStateException illegalStateException) {
                                            // empty catch block
                                        }
                                    }
                                }
                            }
                            finally {
                                CONTEXTUAL_INSTANCE.set(null);
                                super.close();
                                this.info("Released the contextual ComponentManager instance " + ComponentManager.getIdentifiers());
                            }
                        }

                        Object readResolve() throws ObjectStreamException {
                            return new SerializationReplacer();
                        }
                    };
                    Runtime.getRuntime().addShutdownHook(shutdownHook);
                    manager.info("Created the contextual ComponentManager instance " + ComponentManager.getIdentifiers());
                    if (!CONTEXTUAL_INSTANCE.compareAndSet(null, manager)) {
                        manager = CONTEXTUAL_INSTANCE.get();
                    }
                }
            }
        }
        return manager;
    }

    protected void info(String msg) {
        switch (this.logInfoLevelMapping.intValue()) {
            case 500: {
                log.debug(msg);
                break;
            }
            default: {
                log.info(msg);
            }
        }
    }

    private static String findClasspath() {
        return Optional.ofNullable(System.getProperty("component.manager.classpath")).orElseGet(() -> Stream.of(System.getProperty("java.class.path"), ComponentManager.findManifestClassPath()).filter(Objects::nonNull).map(s -> s.replace(File.separatorChar, '/')).collect(Collectors.joining(File.pathSeparator)));
    }

    private static String findManifestClassPath() {
        return Optional.ofNullable(System.getProperty("java.class.path")).flatMap(cp -> Stream.of(cp.split(File.pathSeparator)).map(File::new).filter(f -> f.getName().equals("classpath.jar")).findFirst()).map(f -> {
            try (JarFile file = new JarFile((File)f);){
                String string = Optional.ofNullable(file.getManifest()).map(Manifest::getMainAttributes).map(a -> a.getValue(Attributes.Name.CLASS_PATH)).map(value -> value.replace(' ', ';')).orElse(null);
                return string;
            }
            catch (IOException e) {
                log.warn(e.getMessage());
                log.debug(e.getMessage(), (Throwable)e);
                return null;
            }
        }).map(String::trim).orElse(null);
    }

    private static Stream<String> additionalContainerClasses() {
        try {
            ComponentManager.class.getClassLoader().loadClass("org.apache.beam.sdk.Pipeline");
            return Stream.of("org.apache.beam.runners.", "org.apache.beam.sdk.", "org.talend.sdk.component.runtime.beam.", "org.codehaus.jackson.", "com.fasterxml.jackson.annotation.", "com.fasterxml.jackson.core.", "com.fasterxml.jackson.databind.", "com.thoughtwors.paranamer.", "org.apache.commons.compress.", "org.tukaani.xz.", "org.objenesis.", "org.joda.time.", "org.xerial.snappy.", "avro.shaded.", "org.apache.avro.");
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return Stream.empty();
        }
    }

    protected static File findM2() {
        return Optional.ofNullable(System.getProperty("talend.component.manager.m2.repository")).map(File::new).orElseGet(() -> {
            File localM2;
            String m2Repo = System.getProperty("maven.repository");
            if (!"global".equals(m2Repo) && (localM2 = new File(System.getProperty("osgi.configuration.area"), ".m2")).exists()) {
                return localM2;
            }
            return ComponentManager.findDefaultM2();
        });
    }

    private static File findDefaultM2() {
        File settings = new File(System.getProperty("talend.component.manager.m2.settings", System.getProperty("user.home") + "/.m2/settings.xml"));
        if (settings.exists()) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document document = builder.parse(settings);
                XPathFactory xpf = XPathFactory.newInstance();
                XPath xp = xpf.newXPath();
                String localM2RepositoryFromSettings = xp.evaluate("//settings/localRepository/text()", document.getDocumentElement());
                if (localM2RepositoryFromSettings != null && !localM2RepositoryFromSettings.isEmpty()) {
                    return new File(localM2RepositoryFromSettings);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new File(System.getProperty("user.home"), ".m2/repository");
    }

    private static String getIdentifiers() {
        return "(classloader=" + ComponentManager.class.getClassLoader() + ", jvm=" + ManagementFactory.getRuntimeMXBean().getName() + ")";
    }

    private static <T> Stream<T> toStream(Iterator<T> iterator) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 1024), false);
    }

    private static <T> Iterator<T> loadServiceProviders(Class<T> service, ClassLoader classLoader) {
        return ServiceLoader.load(service, classLoader).iterator();
    }

    private static File toFile(String classFileName, URL url) {
        String path = url.getFile();
        path = path.substring(0, path.length() - classFileName.length());
        return new File(FileArchive.decode((String)path));
    }

    public void addCallerAsPlugin() {
        try {
            ClassLoader tmpLoader = Optional.ofNullable(Thread.currentThread().getContextClassLoader()).orElseGet(ClassLoader::getSystemClassLoader);
            StackTraceElement[] stackTrace = new Throwable().getStackTrace();
            Class<?> jarMarker = tmpLoader.loadClass(Stream.of(stackTrace).filter(c -> !c.getClassName().startsWith("org.talend.sdk.component.runtime.manager.") && !c.getClassName().startsWith("org.talend.sdk.component.runtime.beam.dsl.") && !c.getClassName().startsWith("org.talend.sdk.component.runtime.standalone.") && !c.getClassName().startsWith("org.talend.sdk.component.runtime.avro.") && !c.getClassName().startsWith("org.talend.daikon.") && !c.getClassName().startsWith("org.talend.designer.") && !c.getClassName().startsWith("org.eclipse.") && !c.getClassName().startsWith("java.") && !c.getClassName().startsWith("javax.") && !c.getClassName().startsWith("sun.") && !c.getClassName().startsWith("com.sun.") && !c.getClassName().startsWith("com.oracle.")).findFirst().map(StackTraceElement::getClassName).orElse(ComponentManager.class.getName()));
            if (jarMarker == ComponentManager.class) {
                return;
            }
            this.addJarContaining(tmpLoader, jarMarker.getName().replace(".", "/") + ".class");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    protected Set<String> addJarContaining(ClassLoader loader, String resource) {
        URL url = loader.getResource(resource);
        if (url != null) {
            File plugin = null;
            switch (url.getProtocol()) {
                case "bundleresource": {
                    break;
                }
                case "file": {
                    plugin = ComponentManager.toFile(resource, url);
                    break;
                }
                case "jar": {
                    String spec;
                    int separator;
                    if (url.getPath() != null && url.getPath().startsWith("mvn:") || (separator = (spec = url.getFile()).indexOf(33)) <= 0) break;
                    try {
                        plugin = new File(FileArchive.decode((String)new URL(spec.substring(0, separator)).getFile()));
                    }
                    catch (MalformedURLException malformedURLException) {}
                    break;
                }
            }
            if (plugin == null) {
                log.warn("Can't find " + url);
                return null;
            }
            return Stream.of(plugin).flatMap(this::toPluginLocations).filter(path -> !this.container.find(path.getName()).isPresent()).map(file -> {
                String id = this.addPlugin(file.getAbsolutePath());
                if (((ContainerComponentRegistry)((Container)this.container.find(id).get()).get(ContainerComponentRegistry.class)).getComponents().isEmpty()) {
                    this.removePlugin(id);
                    return null;
                }
                return id;
            }).filter(Objects::nonNull).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    private Stream<File> toPluginLocations(File src) {
        if ("test-classes".equals(src.getName()) && src.getParentFile() != null) {
            return Stream.of(src, new File(src.getParentFile(), "classes"));
        }
        if ("classes".equals(src.getName()) && src.getParentFile() != null && "test".equals(src.getParentFile().getName()) && src.getParentFile().getParentFile() != null) {
            return Stream.of(src, new File(src.getParentFile().getParentFile(), "production/classes")).filter(File::exists);
        }
        if ("test".equals(src.getName()) && src.getParentFile() != null && "java".equals(src.getParentFile().getName())) {
            return Stream.of(src, new File(src.getParentFile(), "main")).filter(File::exists);
        }
        return Stream.of(src);
    }

    public <T> Stream<T> find(Function<Container, Stream<T>> mapper) {
        return this.container.findAll().stream().flatMap(mapper);
    }

    public Optional<Object> createComponent(String plugin, String name, ComponentType componentType, int version, Map<String, String> configuration) {
        return this.find(pluginContainer -> Stream.of(pluginContainer.get(ContainerComponentRegistry.class))).filter(Objects::nonNull).map(r -> r.getComponents().get(this.container.buildAutoIdFromName(plugin))).filter(Objects::nonNull).map(component -> Optional.ofNullable(componentType.findMeta((ComponentFamilyMeta)component).get(name)).map(comp -> comp.getInstantiator().apply(configuration == null ? null : comp.getMigrationHandler().migrate(version, configuration)))).findFirst().flatMap(Function.identity()).map(i -> Delegated.class.isInstance(i) ? ((Delegated)Delegated.class.cast(i)).getDelegate() : i);
    }

    public Optional<Mapper> findMapper(String plugin, String name, int version, Map<String, String> configuration) {
        return this.find(pluginContainer -> Stream.of(((ContainerComponentRegistry)pluginContainer.get(ContainerComponentRegistry.class)).getComponents().get(this.container.buildAutoIdFromName(plugin)))).filter(Objects::nonNull).map(component -> Optional.ofNullable(component.getPartitionMappers().get(name)).map(mapper -> (Mapper)mapper.getInstantiator().apply(configuration == null ? null : mapper.getMigrationHandler().migrate(version, configuration))).map(Mapper.class::cast)).findFirst().flatMap(Function.identity());
    }

    public Optional<org.talend.sdk.component.runtime.output.Processor> findProcessor(String plugin, String name, int version, Map<String, String> configuration) {
        return this.find(pluginContainer -> Stream.of(((ContainerComponentRegistry)pluginContainer.get(ContainerComponentRegistry.class)).getComponents().get(this.container.buildAutoIdFromName(plugin)))).filter(Objects::nonNull).map(component -> Optional.ofNullable(component.getProcessors().get(name)).map(proc -> (org.talend.sdk.component.runtime.output.Processor)proc.getInstantiator().apply(configuration == null ? null : proc.getMigrationHandler().migrate(version, configuration))).map(org.talend.sdk.component.runtime.output.Processor.class::cast)).findFirst().flatMap(Function.identity());
    }

    public boolean hasPlugin(String plugin) {
        return this.container.find(plugin).isPresent();
    }

    public Optional<Container> findPlugin(String plugin) {
        return this.container.find(plugin);
    }

    public String addPlugin(String pluginRootFile) {
        String id = this.container.builder(pluginRootFile).withCustomizer(this.createContainerCustomizer(pluginRootFile)).create().getId();
        this.info("Adding plugin: " + pluginRootFile + ", as " + id);
        return id;
    }

    public String addWithLocationPlugin(String location, String pluginRootFile) {
        String id = this.container.builder(pluginRootFile).withCustomizer(this.createContainerCustomizer(location)).create().getId();
        this.info("Adding plugin: " + pluginRootFile + ", as " + id);
        return id;
    }

    protected String addPlugin(String forcedId, String pluginRootFile) {
        String id = this.container.builder(forcedId, pluginRootFile).withCustomizer(this.createContainerCustomizer(forcedId)).create().getId();
        this.info("Adding plugin: " + pluginRootFile + ", as " + id);
        return id;
    }

    public void removePlugin(String id) {
        this.container.find(id).ifPresent(Container::close);
        this.info("Removed plugin: " + id);
    }

    protected boolean isContainerClass(Filter filter, String name) {
        if (this.excludeClassesFilter.accept(name)) {
            URL resource = ComponentManager.class.getClassLoader().getResource(name.replace('.', '/') + ".class");
            if (resource != null) {
                String file;
                int separator;
                if (resource.getFile().startsWith("mvn:org.apache.beam/beam-sdks-java-core/")) {
                    return true;
                }
                if ("jar".equals(resource.getProtocol()) && (separator = (file = resource.getFile()).indexOf(33)) > 0) {
                    try {
                        return new File(FileArchive.decode((String)new URL(file.substring(0, separator)).getFile())).getName().startsWith("beam-sdks-java-core-");
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
            }
            return false;
        }
        return name != null && filter.accept(name);
    }

    @Override
    public void close() {
        this.container.close();
    }

    private Consumer<Container> createContainerCustomizer(String originalId) {
        return c -> {
            c.set(OriginalId.class, (Object)new OriginalId(originalId));
            this.transformers.forEach(arg_0 -> ((Container)c).registerTransformer(arg_0));
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T executeInContainer(String plugin, Supplier<T> supplier) {
        Thread thread = Thread.currentThread();
        ClassLoader old = thread.getContextClassLoader();
        thread.setContextClassLoader(this.container.find(plugin).map(Container::getLoader).map(ClassLoader.class::cast).orElse(old));
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            thread.setContextClassLoader(old);
        }
    }

    public List<String> availablePlugins() {
        return this.container.findAll().stream().map(Container::getId).collect(Collectors.toList());
    }

    protected void containerServices(Container container, Map<Class<?>, Object> services) {
        PreComputedJsonpProvider jsonpProvider = new PreComputedJsonpProvider(container.getId(), this.jsonpProvider, this.jsonpParserFactory, this.jsonpWriterFactory, this.jsonpBuilderFactory, this.jsonpGeneratorFactory, this.jsonpReaderFactory);
        services.put(JsonProvider.class, jsonpProvider);
        services.put(JsonBuilderFactory.class, this.javaProxyEnricherFactory.asSerializable((ClassLoader)container.getLoader(), container.getId(), JsonBuilderFactory.class.getName(), this.jsonpBuilderFactory));
        services.put(JsonParserFactory.class, this.javaProxyEnricherFactory.asSerializable((ClassLoader)container.getLoader(), container.getId(), JsonParserFactory.class.getName(), this.jsonpParserFactory));
        services.put(JsonReaderFactory.class, this.javaProxyEnricherFactory.asSerializable((ClassLoader)container.getLoader(), container.getId(), JsonReaderFactory.class.getName(), this.jsonpReaderFactory));
        services.put(JsonWriterFactory.class, this.javaProxyEnricherFactory.asSerializable((ClassLoader)container.getLoader(), container.getId(), JsonWriterFactory.class.getName(), this.jsonpWriterFactory));
        services.put(JsonGeneratorFactory.class, this.javaProxyEnricherFactory.asSerializable((ClassLoader)container.getLoader(), container.getId(), JsonGeneratorFactory.class.getName(), this.jsonpGeneratorFactory));
        Jsonb jsonb = this.jsonbProvider.create().withProvider((JsonProvider)jsonpProvider).withConfig(new JsonbConfig().setProperty("johnzon.cdi.activated", (Object)false)).build();
        Jsonb serializableJsonb = (Jsonb)Jsonb.class.cast(this.javaProxyEnricherFactory.asSerializable((ClassLoader)container.getLoader(), container.getId(), Jsonb.class.getName(), jsonb));
        services.put(Jsonb.class, serializableJsonb);
        services.put(HttpClientFactory.class, new HttpClientFactoryImpl(container.getId(), this.reflections, serializableJsonb, services));
        services.put(LocalCache.class, new LocalCacheService(container.getId()));
        services.put(LocalConfiguration.class, new LocalConfigurationService(this.createRawLocalConfigurations(), container.getId()));
        services.put(ProxyGenerator.class, this.proxyGenerator);
        services.put(Resolver.class, new ResolverImpl(container.getId(), container.getLocalDependencyRelativeResolver()));
        services.put(Injector.class, new InjectorImpl(container.getId(), services));
        services.put(ObjectFactory.class, new ObjectFactoryImpl(container.getId()));
    }

    protected Collection<LocalConfiguration> createRawLocalConfigurations() {
        ArrayList<LocalConfiguration> configurations = new ArrayList<LocalConfiguration>(2);
        configurations.addAll(ComponentManager.toStream(ComponentManager.loadServiceProviders(LocalConfiguration.class, LocalConfiguration.class.getClassLoader())).collect(Collectors.toList()));
        configurations.add(new LocalConfiguration(){

            public String get(String key) {
                return System.getProperty(key);
            }

            public Set<String> keys() {
                return System.getProperties().stringPropertyNames();
            }
        });
        configurations.add(new LocalConfiguration(){

            public String get(String key) {
                return System.getenv(key);
            }

            public Set<String> keys() {
                return System.getenv().keySet();
            }
        });
        return configurations;
    }

    private <T extends Annotation> T findComponentsConfig(Map<String, AnnotatedElement> componentDefaults, Class<?> type, ConfigurableClassLoader loader, final Class<T> annotation, final T defaultValue) {
        AnnotatedElement annotatedElement = componentDefaults.computeIfAbsent(this.getAnnotatedElementCacheKey(type), p -> {
            if (p != null) {
                String currentPackage = p;
                while (true) {
                    try {
                        Class pckInfo = loader.loadClass(currentPackage + ".package-info");
                        if (pckInfo.isAnnotationPresent(annotation)) {
                            return pckInfo;
                        }
                    }
                    catch (ClassNotFoundException pckInfo) {
                        // empty catch block
                    }
                    int endPreviousPackage = currentPackage.lastIndexOf(46);
                    if (endPreviousPackage < 0) break;
                    currentPackage = currentPackage.substring(0, endPreviousPackage);
                }
            }
            return new AnnotatedElement(){

                @Override
                public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                    return (T)(annotationClass == annotation ? (Annotation)annotationClass.cast(defaultValue) : null);
                }

                @Override
                public Annotation[] getAnnotations() {
                    return new Annotation[]{defaultValue};
                }

                @Override
                public Annotation[] getDeclaredAnnotations() {
                    return this.getAnnotations();
                }
            };
        });
        return annotatedElement.getAnnotation(annotation);
    }

    private String getAnnotatedElementCacheKey(Class<?> type) {
        return Optional.ofNullable(type.getPackage().getName()).orElse("");
    }

    private Class<?> handleProxy(Container container, Class<?> type) {
        if (!this.proxyGenerator.hasInterceptors(type) && this.proxyGenerator.isSerializable(type)) {
            return type;
        }
        return (Class)container.execute(() -> this.proxyGenerator.generateProxy((ClassLoader)container.getLoader(), type, container.getId(), type.getName()));
    }

    private Function<Map<String, String>, Object[]> createParametersFactory(String plugin, Executable method, Map<Class<?>, Object> services, List<ParameterMeta> metas) {
        return this.executeInContainer(plugin, () -> this.reflections.parameterFactory(method, services, metas));
    }

    public ContainerManager getContainer() {
        return this.container;
    }

    public JsonProvider getJsonpProvider() {
        return this.jsonpProvider;
    }

    public JsonGeneratorFactory getJsonpGeneratorFactory() {
        return this.jsonpGeneratorFactory;
    }

    public JsonReaderFactory getJsonpReaderFactory() {
        return this.jsonpReaderFactory;
    }

    public JsonBuilderFactory getJsonpBuilderFactory() {
        return this.jsonpBuilderFactory;
    }

    public JsonParserFactory getJsonpParserFactory() {
        return this.jsonpParserFactory;
    }

    public JsonWriterFactory getJsonpWriterFactory() {
        return this.jsonpWriterFactory;
    }

    public JsonbProvider getJsonbProvider() {
        return this.jsonbProvider;
    }

    public MigrationHandlerFactory getMigrationHandlerFactory() {
        return this.migrationHandlerFactory;
    }

    private class ComponentMetaBuilder
    implements ModelListener {
        private final String plugin;
        private final AllServices services;
        private final Components components;
        private final AnnotatedElement familyAnnotationElement;
        private final ComponentContextImpl context;
        private final MigrationHandlerFactory migrationHandlerFactory;
        private ComponentFamilyMeta component;

        public void onPartitionMapper(Class<?> type, PartitionMapper partitionMapper) {
            Constructor<?> constructor = Constructors.findConstructor(type);
            List<ParameterMeta> parameterMetas = ComponentManager.this.parameterModelService.buildParameterMetas(constructor, this.getPackage(type));
            Function parameterFactory = ComponentManager.this.createParametersFactory(this.plugin, constructor, this.services.getServices(), parameterMetas);
            String name = Optional.of(partitionMapper.name()).filter(n -> !n.isEmpty()).orElseGet(type::getName);
            ComponentFamilyMeta component = this.getOrCreateComponent(partitionMapper.family());
            Function<Map<String, String>, Mapper> instantiator = this.context.getOwningExtension() != null && this.context.getOwningExtension().supports(Mapper.class) ? config -> (Mapper)ComponentManager.this.executeInContainer(this.plugin, () -> (Mapper)this.context.getOwningExtension().convert((ComponentExtension.ComponentInstance)new ComponentInstanceImpl(this.doInvoke(constructor, (Object[])parameterFactory.apply(config)), this.plugin, component.getName(), name), Mapper.class)) : config -> new PartitionMapperImpl(component.getName(), name, null, this.plugin, partitionMapper.infinite(), this.doInvoke(constructor, (Object[])parameterFactory.apply(config)));
            component.getPartitionMappers().put(name, new ComponentFamilyMeta.PartitionMapperMeta(component, name, this.findIcon(type), this.findVersion(type), type, parameterMetas, instantiator, this.migrationHandlerFactory.findMigrationHandler(parameterMetas, type, this.services), !this.context.isNoValidation()));
        }

        public void onEmitter(Class<?> type, Emitter emitter) {
            Constructor<?> constructor = Constructors.findConstructor(type);
            List<ParameterMeta> parameterMetas = ComponentManager.this.parameterModelService.buildParameterMetas(constructor, this.getPackage(type));
            Function parameterFactory = ComponentManager.this.createParametersFactory(this.plugin, constructor, this.services.getServices(), parameterMetas);
            String name = Optional.of(emitter.name()).filter(n -> !n.isEmpty()).orElseGet(type::getName);
            ComponentFamilyMeta component = this.getOrCreateComponent(emitter.family());
            Function<Map<String, String>, Mapper> instantiator = this.context.getOwningExtension() != null && this.context.getOwningExtension().supports(Mapper.class) ? config -> (Mapper)ComponentManager.this.executeInContainer(this.plugin, () -> (Mapper)this.context.getOwningExtension().convert((ComponentExtension.ComponentInstance)new ComponentInstanceImpl(this.doInvoke(constructor, (Object[])parameterFactory.apply(config)), this.plugin, component.getName(), name), Mapper.class)) : config -> new LocalPartitionMapper(component.getName(), name, this.plugin, this.doInvoke(constructor, (Object[])parameterFactory.apply(config)));
            component.getPartitionMappers().put(name, new ComponentFamilyMeta.PartitionMapperMeta(component, name, this.findIcon(type), this.findVersion(type), type, parameterMetas, instantiator, this.migrationHandlerFactory.findMigrationHandler(parameterMetas, type, this.services), !this.context.isNoValidation()));
        }

        public void onProcessor(Class<?> type, Processor processor) {
            Constructor<?> constructor = Constructors.findConstructor(type);
            List<ParameterMeta> parameterMetas = ComponentManager.this.parameterModelService.buildParameterMetas(constructor, this.getPackage(type));
            this.addProcessorsBuiltInParameters(type, parameterMetas);
            Function parameterFactory = ComponentManager.this.createParametersFactory(this.plugin, constructor, this.services.getServices(), parameterMetas);
            String name = Optional.of(processor.name()).filter(n -> !n.isEmpty()).orElseGet(type::getName);
            ComponentFamilyMeta component = this.getOrCreateComponent(processor.family());
            Function<Map<String, String>, org.talend.sdk.component.runtime.output.Processor> instantiator = this.context.getOwningExtension() != null && this.context.getOwningExtension().supports(org.talend.sdk.component.runtime.output.Processor.class) ? config -> (org.talend.sdk.component.runtime.output.Processor)ComponentManager.this.executeInContainer(this.plugin, () -> (org.talend.sdk.component.runtime.output.Processor)this.context.getOwningExtension().convert((ComponentExtension.ComponentInstance)new ComponentInstanceImpl(this.doInvoke(constructor, (Object[])parameterFactory.apply(config)), this.plugin, component.getName(), name), org.talend.sdk.component.runtime.output.Processor.class)) : config -> new ProcessorImpl(this.component.getName(), name, this.plugin, Optional.ofNullable(config).map(it -> it.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("$") || ((String)e.getKey()).contains(".$")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).orElseGet(Collections::emptyMap), this.doInvoke(constructor, (Object[])parameterFactory.apply(config)));
            component.getProcessors().put(name, new ComponentFamilyMeta.ProcessorMeta(component, name, this.findIcon(type), this.findVersion(type), type, parameterMetas, instantiator, this.migrationHandlerFactory.findMigrationHandler(parameterMetas, type, this.services), !this.context.isNoValidation()));
        }

        private void addProcessorsBuiltInParameters(Class<?> type, List<ParameterMeta> parameterMetas) {
            ParameterMeta root = parameterMetas.stream().filter(p -> p.getName().equals(p.getPath())).findFirst().orElseGet(() -> {
                ParameterMeta umbrella = new ParameterMeta(new ParameterMeta.Source(){

                    @Override
                    public String name() {
                        return "$configuration";
                    }

                    @Override
                    public Class<?> declaringClass() {
                        return Object.class;
                    }
                }, (Type)((Object)Object.class), ParameterMeta.Type.OBJECT, "$configuration", "$configuration", new String[0], (List<ParameterMeta>)new ArrayList<ParameterMeta>(), (Collection<String>)new ArrayList<String>(), (Map<String, String>)new HashMap<String, String>(), true);
                parameterMetas.add(umbrella);
                return umbrella;
            });
            if (Stream.of(type.getMethods()).anyMatch(p -> p.isAnnotationPresent(AfterGroup.class))) {
                MaxBatchSizeParamBuilder paramBuilder = new MaxBatchSizeParamBuilder(root);
                ParameterMeta maxBatchSize = paramBuilder.newBulkParameter();
                root.getNestedParameters().add(maxBatchSize);
                if (!root.getMetadata().containsKey(paramBuilder.getLayoutType())) {
                    root.getMetadata().put(paramBuilder.getLayoutType(), paramBuilder.getLayoutType().contains("gridlayout") ? maxBatchSize.getName() : "true");
                } else if (paramBuilder.getLayoutType().contains("gridlayout")) {
                    String oldLayout = root.getMetadata().get(paramBuilder.getLayoutType());
                    root.getMetadata().put(paramBuilder.getLayoutType(), maxBatchSize.getName() + "|" + oldLayout);
                }
            }
        }

        private String getPackage(Class<?> type) {
            return Optional.ofNullable(type.getPackage()).map(Package::getName).orElse("");
        }

        private int findVersion(Class<?> type) {
            return Optional.ofNullable(type.getAnnotation(Version.class)).map(Version::value).orElse(1);
        }

        private String findIcon(AnnotatedElement type) {
            return Optional.ofNullable(type.getAnnotation(Icon.class)).map(i -> i.value() == Icon.IconType.CUSTOM ? Optional.of(i.custom()).filter(s -> !s.isEmpty()).orElse("default") : i.value().getKey()).orElse("default");
        }

        private ComponentFamilyMeta getOrCreateComponent(String component) {
            String comp = Optional.ofNullable(component).filter(s -> !s.isEmpty()).orElseGet(() -> ((Components)this.components).family());
            if (comp.isEmpty()) {
                throw new IllegalArgumentException("Missing component");
            }
            return this.component == null || !component.equals(this.component.getName()) ? (this.component = new ComponentFamilyMeta(this.plugin, Arrays.asList(this.components.categories()), this.findIcon(this.familyAnnotationElement), comp, Class.class.isInstance(this.familyAnnotationElement) ? this.getPackage((Class)Class.class.cast(this.familyAnnotationElement)) : "")) : this.component;
        }

        private Serializable doInvoke(Constructor<?> constructor, Object[] args) {
            return (Serializable)ComponentManager.this.executeInContainer(this.plugin, () -> {
                try {
                    return (Serializable)Serializable.class.cast(constructor.newInstance(args));
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
                catch (ClassCastException e) {
                    throw new IllegalArgumentException(constructor + " should return a Serializable", e);
                }
                catch (InvocationTargetException e) {
                    throw InvocationExceptionWrapper.toRuntimeException((InvocationTargetException)e);
                }
                catch (InstantiationException e) {
                    throw new IllegalArgumentException(e);
                }
            });
        }

        public ComponentMetaBuilder(String plugin, AllServices services, Components components, AnnotatedElement familyAnnotationElement, ComponentContextImpl context, MigrationHandlerFactory migrationHandlerFactory) {
            this.plugin = plugin;
            this.services = services;
            this.components = components;
            this.familyAnnotationElement = familyAnnotationElement;
            this.context = context;
            this.migrationHandlerFactory = migrationHandlerFactory;
        }
    }

    private class Updater
    implements ContainerListener {
        private final ModelVisitor visitor = new ModelVisitor();

        private Updater() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCreate(final Container container) {
            AnnotationFinder finder;
            ConfigurableClassLoader loader = container.getLoader();
            OriginalId originalId = (OriginalId)OriginalId.class.cast(container.get(OriginalId.class));
            Archive archive = null;
            try {
                archive = this.toArchive(container.getRootModule(), originalId, loader);
                Filter filter = KnownClassesFilter.INSTANCE;
                try (InputStream containerFilterConfig = container.getLoader().getResourceAsStream("TALEND-INF/scanning.properties");){
                    if (containerFilterConfig != null) {
                        Properties config = new Properties();
                        config.load(containerFilterConfig);
                        Filter accept = Optional.ofNullable(config.getProperty("classloader.includes")).map(String::trim).filter(v -> !v.isEmpty()).map(s -> s.split(",")).map(Filters::patterns).orElseGet(() -> name -> true);
                        Filter reject = Optional.ofNullable(config.getProperty("classloader.excludes")).map(String::trim).filter(v -> !v.isEmpty()).map(s -> s.split(",")).map(Filters::patterns).orElseGet(() -> name -> false);
                        filter = new ExcludeIncludeFilter(accept, reject);
                    }
                }
                catch (IOException e) {
                    log.debug(e.getMessage(), (Throwable)e);
                }
                finder = new AnnotationFinder((Archive)new FilteredArchive(archive, filter));
            }
            finally {
                if (AutoCloseable.class.isInstance(archive)) {
                    try {
                        ((AutoCloseable)AutoCloseable.class.cast(archive)).close();
                    }
                    catch (Exception e) {
                        log.warn(e.getMessage());
                    }
                }
            }
            ContainerComponentRegistry registry = new ContainerComponentRegistry();
            container.set(ContainerComponentRegistry.class, (Object)registry);
            final HashMap services = new HashMap();
            AllServices allServices = new AllServices(services);
            container.set(AllServices.class, (Object)allServices);
            ComponentManager.this.containerServices(container, services);
            container.set(LightContainer.class, (Object)new LightContainer(){

                public ClassLoader classloader() {
                    return container.getLoader();
                }

                public <T> T findService(Class<T> key) {
                    return key.cast(services.get(key));
                }
            });
            HashMap componentDefaults = new HashMap();
            finder.findAnnotatedClasses(Internationalized.class).forEach(proxy -> {
                Object instance = ComponentManager.this.javaProxyEnricherFactory.asSerializable((ClassLoader)container.getLoader(), container.getId(), proxy.getName(), ComponentManager.this.internationalizationServiceFactory.create(proxy, (ClassLoader)container.getLoader()));
                services.put((Class<?>)proxy, instance);
                registry.getServices().add(new ServiceMeta(instance, Collections.emptyList()));
            });
            finder.findAnnotatedMethods(Request.class).stream().map(Method::getDeclaringClass).distinct().filter(HttpClient.class::isAssignableFrom).forEach(proxy -> {
                Object instance = ((HttpClientFactory)HttpClientFactory.class.cast(services.get(HttpClientFactory.class))).create(proxy, null);
                services.put((Class<?>)proxy, instance);
                registry.getServices().add(new ServiceMeta(instance, Collections.emptyList()));
            });
            Map userServices = finder.findAnnotatedClasses(Service.class).stream().filter(s -> !services.keySet().contains(s)).collect(Collectors.toMap(Function.identity(), service -> {
                try {
                    Thread thread = Thread.currentThread();
                    ClassLoader old = thread.getContextClassLoader();
                    thread.setContextClassLoader((ClassLoader)container.getLoader());
                    try {
                        Object instance = ComponentManager.this.handleProxy(container, service).getConstructor(new Class[0]).newInstance(new Object[0]);
                        if (ComponentManager.this.proxyGenerator.hasInterceptors((Class<?>)service)) {
                            ComponentManager.this.proxyGenerator.initialize(instance, new InterceptorHandlerFacade(service.getConstructor(new Class[0]).newInstance(new Object[0]), services));
                        }
                        Object t = instance;
                        return t;
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        throw new IllegalArgumentException(e);
                    }
                    catch (InvocationTargetException e) {
                        throw InvocationExceptionWrapper.toRuntimeException((InvocationTargetException)e);
                    }
                    finally {
                        thread.setContextClassLoader(old);
                    }
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalArgumentException("No default constructor for " + service);
                }
            }));
            Injector injector = (Injector)Injector.class.cast(services.get(Injector.class));
            services.putAll(userServices);
            userServices.forEach((service, instance) -> {
                injector.inject(instance);
                this.doInvoke(container.getId(), instance, PostConstruct.class);
                services.put((Class<?>)service, instance);
                registry.getServices().add(new ServiceMeta(instance, Stream.of(service.getMethods()).filter(m -> Stream.of(m.getAnnotations()).anyMatch(a -> a.annotationType().isAnnotationPresent(ActionType.class))).map(serviceMethod -> this.createServiceMeta(container, services, componentDefaults, (Class<?>)service, instance, (Method)serviceMethod)).collect(Collectors.toList())));
                ComponentManager.this.info("Added @Service " + service + " for container-id=" + container.getId());
            });
            ComponentContexts componentContexts = new ComponentContexts();
            container.set(ComponentContexts.class, (Object)componentContexts);
            Stream.of(PartitionMapper.class, Processor.class, Emitter.class).flatMap(a -> finder.findAnnotatedClasses(a).stream()).filter(t -> Modifier.isPublic(t.getModifiers())).forEach(type -> {
                Components components = (Components)ComponentManager.this.findComponentsConfig(componentDefaults, type, container.getLoader(), Components.class, (Annotation)DEFAULT_COMPONENT);
                ComponentContextImpl context = new ComponentContextImpl((Class<?>)type);
                componentContexts.getContexts().put((Class<?>)type, context);
                ComponentManager.this.extensions.forEach(e -> {
                    context.setCurrentExtension((ComponentExtension)e);
                    try {
                        e.onComponent((ComponentExtension.ComponentContext)context);
                    }
                    finally {
                        context.setCurrentExtension(null);
                    }
                    if (context.getOwningExtension() == e) {
                        Optional.ofNullable(e.getExtensionServices(container.getId())).ifPresent(services::putAll);
                    }
                });
                ComponentMetaBuilder builder = new ComponentMetaBuilder(container.getId(), allServices, components, (AnnotatedElement)componentDefaults.get(ComponentManager.this.getAnnotatedElementCacheKey(type)), context, ComponentManager.this.migrationHandlerFactory);
                Thread thread = Thread.currentThread();
                ClassLoader old = thread.getContextClassLoader();
                thread.setContextClassLoader((ClassLoader)container.getLoader());
                try {
                    this.visitor.visit(type, (ModelListener)builder, !context.isNoValidation());
                }
                finally {
                    thread.setContextClassLoader(old);
                }
                Optional.ofNullable(builder.component).ifPresent(c -> {
                    ComponentFamilyMeta componentFamilyMeta = registry.getComponents().computeIfAbsent(c.getName(), n -> c);
                    if (componentFamilyMeta != c) {
                        if (componentFamilyMeta.getProcessors().keySet().stream().anyMatch(k -> c.getProcessors().keySet().contains(k))) {
                            throw new IllegalArgumentException("Conflicting processors in " + c);
                        }
                        if (componentFamilyMeta.getPartitionMappers().keySet().stream().anyMatch(k -> c.getPartitionMappers().keySet().contains(k))) {
                            throw new IllegalArgumentException("Conflicting mappers in " + c);
                        }
                        componentFamilyMeta.getProcessors().putAll(c.getProcessors());
                        componentFamilyMeta.getPartitionMappers().putAll(c.getPartitionMappers());
                    }
                });
                ComponentManager.this.info("Parsed component " + type + " for container-id=" + container.getId());
            });
        }

        private ServiceMeta.ActionMeta createServiceMeta(Container container, Map<Class<?>, Object> services, Map<String, AnnotatedElement> componentDefaults, Class<?> service, Object instance, Method serviceMethod) {
            String component;
            Components components = (Components)ComponentManager.this.findComponentsConfig(componentDefaults, serviceMethod.getDeclaringClass(), container.getLoader(), Components.class, (Annotation)DEFAULT_COMPONENT);
            Annotation marker = Stream.of(serviceMethod.getAnnotations()).filter(a -> a.annotationType().isAnnotationPresent(ActionType.class)).findFirst().orElseThrow(() -> new IllegalStateException("Something went wrong with " + serviceMethod));
            ActionType actionType = marker.annotationType().getAnnotation(ActionType.class);
            if (actionType.expectedReturnedType() != Object.class && !actionType.expectedReturnedType().isAssignableFrom(serviceMethod.getReturnType())) {
                throw new IllegalArgumentException("Can't use " + marker + " on " + serviceMethod + ", expected returned type: " + actionType.expectedReturnedType() + ", actual one: " + serviceMethod.getReturnType());
            }
            try {
                component = Optional.ofNullable(String.class.cast(marker.annotationType().getMethod("family", new Class[0]).invoke((Object)marker, new Object[0]))).filter(c -> !c.isEmpty()).orElseGet(() -> ((Components)components).family());
                if (component.isEmpty()) {
                    throw new IllegalArgumentException("No component for " + serviceMethod + ", maybe add a @Components on your package " + service.getPackage());
                }
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new IllegalStateException(e);
            }
            catch (InvocationTargetException e) {
                throw InvocationExceptionWrapper.toRuntimeException((InvocationTargetException)e);
            }
            String name = Stream.of("name", "value").map(mName -> {
                try {
                    return (String)String.class.cast(marker.annotationType().getMethod((String)mName, new Class[0]).invoke((Object)marker, new Object[0]));
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
                catch (InvocationTargetException e) {
                    throw InvocationExceptionWrapper.toRuntimeException((InvocationTargetException)e);
                }
                catch (NoSuchMethodException e) {
                    return null;
                }
            }).filter(Objects::nonNull).findFirst().orElse("default");
            Function parameterFactory = ComponentManager.this.createParametersFactory(container.getId(), serviceMethod, services, null);
            Object actionInstance = Modifier.isStatic(serviceMethod.getModifiers()) ? null : instance;
            Function<Map<String, String>, Object> invoker = arg -> ComponentManager.this.executeInContainer(container.getId(), () -> {
                try {
                    Object[] args = (Object[])parameterFactory.apply(arg);
                    return serviceMethod.invoke(actionInstance, args);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
                catch (InvocationTargetException e) {
                    throw InvocationExceptionWrapper.toRuntimeException((InvocationTargetException)e);
                }
            });
            return new ServiceMeta.ActionMeta(component, actionType.value(), name, serviceMethod.getGenericParameterTypes(), ComponentManager.this.parameterModelService.buildServiceParameterMetas(serviceMethod, Optional.ofNullable(serviceMethod.getDeclaringClass().getPackage()).map(Package::getName).orElse("")), invoker);
        }

        private Archive toArchive(String module, OriginalId originalId, ConfigurableClassLoader loader) {
            File file = new File(module);
            if (file.exists()) {
                try {
                    return ClasspathArchive.archive((ClassLoader)loader, (URL)file.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            ComponentManager.this.info(module + " is not a file, will try to look it up from a nested maven repository");
            InputStream nestedJar = loader.getParent().getResourceAsStream("MAVEN-INF/repository/" + module);
            if (nestedJar != null) {
                try {
                    JarInputStream jarStream = new JarInputStream(nestedJar);
                    log.debug("Found a nested resource for " + module);
                    return new NestedJarArchive(jarStream, loader);
                }
                catch (IOException e) {
                    try {
                        nestedJar.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            throw new IllegalArgumentException("Module error: check that the module exist and is a jar or a directory. " + Optional.ofNullable(originalId.getValue()).orElse(module));
        }

        public void onClose(Container container) {
            Optional.ofNullable(container.get(ContainerComponentRegistry.class)).ifPresent(r -> {
                ContainerComponentRegistry registry = (ContainerComponentRegistry)container.remove(ContainerComponentRegistry.class);
                registry.getComponents().clear();
                registry.getServices().stream().filter(i -> !Proxy.isProxyClass(i.getInstance().getClass())).forEach(s -> this.doInvoke(container.getId(), s.getInstance(), PreDestroy.class));
                registry.getServices().clear();
            });
            Optional.ofNullable(container.get(AllServices.class)).map(s -> s.getServices().get(Jsonb.class)).map(Jsonb.class::cast).ifPresent(jsonb -> {
                try {
                    jsonb.close();
                }
                catch (Exception e) {
                    log.warn(e.getMessage(), (Throwable)e);
                }
            });
        }

        private void doInvoke(String container, Object instance, Class<? extends Annotation> marker) {
            ComponentManager.this.executeInContainer(container, () -> {
                Class<?> instanceClass = instance.getClass();
                new ClassFinder(new Class[]{instanceClass.getName().contains("$$") ? instanceClass.getSuperclass() : instanceClass}).findAnnotatedMethods(marker).stream().filter(m -> Modifier.isPublic(m.getModifiers())).forEach(m -> {
                    try {
                        m.invoke(instance, new Object[0]);
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalStateException(e);
                    }
                    catch (InvocationTargetException e) {
                        throw InvocationExceptionWrapper.toRuntimeException((InvocationTargetException)e);
                    }
                });
                return null;
            });
        }
    }

    public static class OriginalId {
        private final String value;

        public OriginalId(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OriginalId)) {
                return false;
            }
            OriginalId other = (OriginalId)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OriginalId;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "ComponentManager.OriginalId(value=" + this.getValue() + ")";
        }
    }

    public static class AllServices {
        private final Map<Class<?>, Object> services;

        public Map<Class<?>, Object> getServices() {
            return this.services;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AllServices)) {
                return false;
            }
            AllServices other = (AllServices)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<Class<?>, Object> this$services = this.getServices();
            Map<Class<?>, Object> other$services = other.getServices();
            return !(this$services == null ? other$services != null : !((Object)this$services).equals(other$services));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AllServices;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<Class<?>, Object> $services = this.getServices();
            result = result * 59 + ($services == null ? 43 : ((Object)$services).hashCode());
            return result;
        }

        public String toString() {
            return "ComponentManager.AllServices(services=" + this.getServices() + ")";
        }

        public AllServices(Map<Class<?>, Object> services) {
            this.services = services;
        }
    }

    private static class SerializationReplacer
    implements Serializable {
        Object readResolve() throws ObjectStreamException {
            return ComponentManager.instance();
        }
    }

    public static enum ComponentType {
        MAPPER{

            @Override
            Map<String, ? extends ComponentFamilyMeta.BaseMeta> findMeta(ComponentFamilyMeta family) {
                return family.getPartitionMappers();
            }
        }
        ,
        PROCESSOR{

            @Override
            Map<String, ? extends ComponentFamilyMeta.BaseMeta> findMeta(ComponentFamilyMeta family) {
                return family.getProcessors();
            }
        };


        abstract Map<String, ? extends ComponentFamilyMeta.BaseMeta> findMeta(ComponentFamilyMeta var1);
    }
}

