/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.junit.delegate;

import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import lombok.Generated;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.JUnit4;
import org.junit.runners.model.InitializationError;
import org.talend.sdk.component.junit.delegate.DelegateRunWith;

public class DelegatingRunner
extends Runner {
    private final Runner delegate;
    private final Class<?> testClass;

    public DelegatingRunner(Class<?> testClass) throws InitializationError {
        this.testClass = testClass;
        try {
            Optional<Class> delegateClass = Optional.ofNullable(testClass.getAnnotation(DelegateRunWith.class)).map(DelegateRunWith::value);
            this.delegate = delegateClass.isPresent() ? (Runner)delegateClass.get().getConstructor(Class.class).newInstance(testClass) : new JUnit4(testClass);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            if (InitializationError.class.isInstance(e.getCause())) {
                throw (InitializationError)InitializationError.class.cast(e.getCause());
            }
            throw new IllegalStateException(e.getTargetException());
        }
    }

    public Description getDescription() {
        return this.delegate.getDescription();
    }

    public void run(RunNotifier notifier) {
        this.delegate.run(notifier);
    }

    @Generated
    protected Class<?> getTestClass() {
        return this.testClass;
    }
}

