/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.junit.lang;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.BaseStream;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.talend.sdk.component.runtime.base.lang.exception.InvocationExceptionWrapper;

public class StreamDecorator
implements InvocationHandler {
    private final BaseStream delegate;
    private final Consumer<Runnable> leafDecorator;

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            Object result;
            boolean stream = BaseStream.class.isAssignableFrom(method.getReturnType());
            Object object = result = stream ? method.invoke((Object)this.delegate, args) : this.wrap(() -> {
                try {
                    return method.invoke((Object)this.delegate, args);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalArgumentException(e);
                }
                catch (InvocationTargetException e) {
                    throw InvocationExceptionWrapper.toRuntimeException((InvocationTargetException)e);
                }
            });
            if (stream) {
                if (Stream.class.isInstance(result)) {
                    return StreamDecorator.decorate((Stream)Stream.class.cast(result), Stream.class, this.leafDecorator);
                }
                if (IntStream.class.isInstance(result)) {
                    return StreamDecorator.decorate((IntStream)IntStream.class.cast(result), IntStream.class, this.leafDecorator);
                }
                if (LongStream.class.isInstance(result)) {
                    return StreamDecorator.decorate((LongStream)LongStream.class.cast(result), LongStream.class, this.leafDecorator);
                }
                if (DoubleStream.class.isInstance(result)) {
                    return StreamDecorator.decorate((DoubleStream)DoubleStream.class.cast(result), DoubleStream.class, this.leafDecorator);
                }
            }
            return result;
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }

    private <V> V wrap(Supplier<V> supplier) {
        AtomicReference ref = new AtomicReference();
        this.leafDecorator.accept(() -> ref.set(supplier.get()));
        return ref.get();
    }

    public static <T> Stream<T> decorate(Stream<T> delegate, Consumer<Runnable> wrapper) {
        return StreamDecorator.decorate(delegate, Stream.class, wrapper);
    }

    private static <T, S extends BaseStream<T, ?>> S decorate(S delegate, Class<S> type, Consumer<Runnable> wrapper) {
        return (S)((BaseStream)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{type}, (InvocationHandler)new StreamDecorator(delegate, wrapper)));
    }

    public StreamDecorator(BaseStream delegate, Consumer<Runnable> leafDecorator) {
        this.delegate = delegate;
        this.leafDecorator = leafDecorator;
    }

    public BaseStream getDelegate() {
        return this.delegate;
    }

    public Consumer<Runnable> getLeafDecorator() {
        return this.leafDecorator;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StreamDecorator)) {
            return false;
        }
        StreamDecorator other = (StreamDecorator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BaseStream this$delegate = this.getDelegate();
        BaseStream other$delegate = other.getDelegate();
        if (this$delegate == null ? other$delegate != null : !this$delegate.equals(other$delegate)) {
            return false;
        }
        Consumer<Runnable> this$leafDecorator = this.getLeafDecorator();
        Consumer<Runnable> other$leafDecorator = other.getLeafDecorator();
        return !(this$leafDecorator == null ? other$leafDecorator != null : !this$leafDecorator.equals(other$leafDecorator));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StreamDecorator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BaseStream $delegate = this.getDelegate();
        result = result * 59 + ($delegate == null ? 43 : $delegate.hashCode());
        Consumer<Runnable> $leafDecorator = this.getLeafDecorator();
        result = result * 59 + ($leafDecorator == null ? 43 : $leafDecorator.hashCode());
        return result;
    }

    public String toString() {
        return "StreamDecorator(delegate=" + this.getDelegate() + ", leafDecorator=" + this.getLeafDecorator() + ")";
    }
}

