/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.base;

import java.util.stream.Stream;
import org.talend.sdk.component.api.DecryptedServer;
import org.talend.sdk.component.maven.MavenDecrypter;
import org.talend.sdk.component.maven.Server;

public class BaseMavenDecrypter {
    public Server createInstance(DecryptedServer config) {
        if (config.alwaysTryLookup()) {
            try {
                return new MavenDecrypter().find(config.value());
            }
            catch (IllegalArgumentException iae) {
                if (this.ifActive(config.conditions())) {
                    throw iae;
                }
            }
        } else if (this.ifActive(config.conditions())) {
            return new MavenDecrypter().find(config.value());
        }
        Server server = new Server();
        server.setUsername(config.defaultUsername());
        server.setPassword(config.defaultPassword());
        return server;
    }

    private boolean ifActive(DecryptedServer.Conditions conditions) {
        Stream<Boolean> evaluations = Stream.of(conditions.value()).map(c -> {
            String value = System.getProperty(c.forSystemProperty());
            if (value == null) {
                return c.supportsNull();
            }
            return c.expectedValue().equals(value);
        });
        switch (conditions.combination()) {
            case AND: {
                return evaluations.allMatch(c -> c);
            }
            case OR: {
                return evaluations.anyMatch(c -> c);
            }
        }
        throw new IllegalArgumentException("Unsupported: " + (Object)((Object)conditions.combination()));
    }
}

