/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.junit5.environment;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.platform.commons.util.AnnotationUtils;
import org.talend.sdk.component.junit.environment.DecoratingEnvironmentProvider;
import org.talend.sdk.component.junit.environment.EnvironmentConfiguration;
import org.talend.sdk.component.junit.environment.EnvironmentConfigurations;
import org.talend.sdk.component.junit.environment.EnvironmentProvider;
import org.talend.sdk.component.junit5.ComponentExtension;

public class EnvironmentalContext
implements TestTemplateInvocationContext {
    private final EnvironmentProvider provider;
    private final String displayName;
    private final ComponentExtension componentExtension;

    public String getDisplayName(int invocationIndex) {
        return this.displayName;
    }

    public List<Extension> getAdditionalExtensions() {
        return Collections.singletonList(new EnvironmentalLifecycle(this.provider, this.componentExtension, null));
    }

    public EnvironmentalContext(EnvironmentProvider provider, String displayName, ComponentExtension componentExtension) {
        this.provider = provider;
        this.displayName = displayName;
        this.componentExtension = componentExtension;
    }

    public static class EnvironmentalLifecycle
    implements BeforeEachCallback,
    AfterEachCallback,
    ExecutionCondition,
    ParameterResolver,
    TestInstancePostProcessor {
        private final EnvironmentProvider provider;
        private final ComponentExtension componentExtension;
        private AutoCloseable closeable;

        public void beforeEach(ExtensionContext context) {
            this.closeable = this.provider.start(context.getRequiredTestClass(), (Annotation[])Stream.concat(Stream.of(context.getRequiredTestClass().getAnnotations()), Stream.of(Optional.of(AnnotationUtils.findRepeatableAnnotations((AnnotatedElement)context.getRequiredTestClass(), EnvironmentConfiguration.class)).filter(it -> !it.isEmpty()).map(l -> new Annotation[]{new EnvironmentConfigurations((List)l){
                final /* synthetic */ List val$l;
                {
                    this.val$l = list;
                }

                @Override
                public Class<? extends Annotation> annotationType() {
                    return EnvironmentConfigurations.class;
                }

                @Override
                public EnvironmentConfiguration[] value() {
                    return this.val$l.toArray(new EnvironmentConfiguration[0]);
                }
            }}).orElseGet(() -> new Annotation[0]))).toArray(Annotation[]::new));
            Optional.ofNullable(this.componentExtension).ifPresent(c -> {
                c.doStart(context);
                c.doInject(context);
            });
        }

        public void afterEach(ExtensionContext context) {
            Optional.ofNullable(this.componentExtension).ifPresent(c -> {
                c.resetState();
                c.doStop(context);
            });
            Optional.ofNullable(this.closeable).ifPresent(c -> {
                try {
                    c.close();
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            });
        }

        public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
            return this.isActive() ? ConditionEvaluationResult.enabled((String)"provider is active") : ConditionEvaluationResult.disabled((String)"provider is disabled");
        }

        private boolean isActive() {
            return DecoratingEnvironmentProvider.class.isInstance(this.provider) && ((DecoratingEnvironmentProvider)DecoratingEnvironmentProvider.class.cast(this.provider)).isActive();
        }

        public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
            return this.componentExtension != null && this.componentExtension.supportsParameter(parameterContext, extensionContext);
        }

        public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
            return this.componentExtension == null ? null : this.componentExtension.resolveParameter(parameterContext, extensionContext);
        }

        public void postProcessTestInstance(Object o, ExtensionContext extensionContext) {
            if (this.componentExtension != null) {
                this.componentExtension.postProcessTestInstance(o, extensionContext);
            }
        }

        public EnvironmentalLifecycle(EnvironmentProvider provider, ComponentExtension componentExtension, AutoCloseable closeable) {
            this.provider = provider;
            this.componentExtension = componentExtension;
            this.closeable = closeable;
        }
    }
}

