/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.junit5;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Optional;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;
import org.talend.sdk.component.junit.BaseComponentsHandler;
import org.talend.sdk.component.junit.base.junit5.JUnit5InjectionSupport;
import org.talend.sdk.component.junit.environment.Environment;
import org.talend.sdk.component.junit5.Injected;
import org.talend.sdk.component.junit5.WithComponents;

public class ComponentExtension
extends BaseComponentsHandler
implements BeforeAllCallback,
AfterAllCallback,
JUnit5InjectionSupport,
BeforeEachCallback,
AfterEachCallback {
    public static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{ComponentExtension.class.getName()});
    private static final String USE_EACH_KEY = ComponentExtension.class.getName() + ".useEach";
    private static final String SHARED_INSTANCE = ComponentExtension.class.getName() + ".instance";

    public void beforeAll(ExtensionContext extensionContext) {
        boolean shouldUseEach;
        WithComponents element = (WithComponents)AnnotationUtils.findAnnotation((Optional)extensionContext.getElement(), WithComponents.class).orElseThrow(() -> new IllegalArgumentException("No annotation @WithComponents on " + extensionContext.getRequiredTestClass()));
        this.packageName = element.value();
        if (element.isolatedPackages().length > 0) {
            this.withIsolatedPackage(null, element.isolatedPackages());
        }
        if (!(shouldUseEach = this.shouldIgnore(extensionContext.getElement()))) {
            this.doStart(extensionContext);
        } else if (!extensionContext.getElement().map(AnnotatedElement::getAnnotations).map(annotations -> {
            int componentIndex = -1;
            for (int i = 0; i < ((Annotation[])annotations).length; ++i) {
                Class<? extends Annotation> type = annotations[i].annotationType();
                if (type == WithComponents.class) {
                    componentIndex = i;
                    continue;
                }
                if (type != Environment.class || componentIndex < 0) continue;
                return false;
            }
            return true;
        }).orElse(false).booleanValue()) {
            throw new IllegalArgumentException("If you combine @WithComponents and @Environment, you must ensure environment annotations are becoming before the component one otherwise you will run in an unexpected context and will not reproduce real execution.");
        }
        extensionContext.getStore(NAMESPACE).put((Object)USE_EACH_KEY, (Object)shouldUseEach);
        extensionContext.getStore(NAMESPACE).put((Object)SHARED_INSTANCE, (Object)this);
    }

    public void afterAll(ExtensionContext extensionContext) {
        if (!this.shouldUseEach(extensionContext).booleanValue()) {
            this.doStop(extensionContext);
        }
    }

    public Class<? extends Annotation> injectionMarker() {
        return Injected.class;
    }

    public void beforeEach(ExtensionContext extensionContext) {
        if (!this.shouldUseEach(extensionContext).booleanValue()) {
            this.doInject(extensionContext);
        }
    }

    public void afterEach(ExtensionContext extensionContext) {
        if (!this.shouldUseEach(extensionContext).booleanValue()) {
            this.resetState();
        }
    }

    public void doStart(ExtensionContext extensionContext) {
        extensionContext.getStore(NAMESPACE).put((Object)BaseComponentsHandler.EmbeddedComponentManager.class.getName(), (Object)this.start());
    }

    public void doStop(ExtensionContext extensionContext) {
        Optional.ofNullable(BaseComponentsHandler.EmbeddedComponentManager.class.cast(extensionContext.getStore(NAMESPACE).get((Object)BaseComponentsHandler.EmbeddedComponentManager.class.getName()))).ifPresent(BaseComponentsHandler.EmbeddedComponentManager::close);
    }

    public void doInject(ExtensionContext extensionContext) {
        extensionContext.getTestInstance().ifPresent(this::injectServices);
    }

    private Boolean shouldUseEach(ExtensionContext extensionContext) {
        return (Boolean)extensionContext.getStore(NAMESPACE).get((Object)USE_EACH_KEY, Boolean.TYPE);
    }

    private boolean shouldIgnore(Optional<AnnotatedElement> element) {
        return !AnnotationUtils.findRepeatableAnnotations(element, Environment.class).isEmpty();
    }
}

