/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.junit.environment.builtin.beam;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.function.Consumer;
import org.jboss.shrinkwrap.resolver.api.maven.ScopeType;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependencies;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependency;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependencyExclusion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.junit.environment.ClassLoaderEnvironment;

public abstract class BeamEnvironment
extends ClassLoaderEnvironment {
    private static final Logger log = LoggerFactory.getLogger(BeamEnvironment.class);
    private String beamVersion;
    private String kitVersion;

    @Override
    protected AutoCloseable doStart(Class<?> clazz, Annotation[] annotations) {
        this.beamVersion = System.getProperty("talend.junit.beam.version", "2.28.0");
        this.kitVersion = System.getProperty("talend.junit.kit.version", "1.31.2");
        this.resetBeamCache(false);
        AutoCloseable delegate = super.doStart(clazz, annotations);
        return () -> {
            this.resetBeamCache(true);
            delegate.close();
        };
    }

    private void resetBeamCache(boolean highLevelLog) {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> pof = loader.loadClass("org.apache.beam.sdk.options.PipelineOptionsFactory");
            Method initializeRegistry = pof.getDeclaredMethod("resetCache", new Class[0]);
            initializeRegistry.setAccessible(true);
            initializeRegistry.invoke(null, new Object[0]);
        }
        catch (Exception | NoClassDefFoundError ex) {
            Consumer<String> logger = highLevelLog ? arg_0 -> ((Logger)log).warn(arg_0) : arg_0 -> ((Logger)log).debug(arg_0);
            logger.accept(ex.getMessage());
        }
    }

    @Override
    protected MavenDependency[] rootDependencies() {
        return new MavenDependency[]{this.getRunnerDependency(), this.getComponentRuntimeBeamDependency()};
    }

    protected MavenDependency getRunnerDependency() {
        return MavenDependencies.createDependency((String)(this.rootDependencyBase() + ":jar:" + this.beamVersion), (ScopeType)ScopeType.RUNTIME, (boolean)false, (MavenDependencyExclusion[])new MavenDependencyExclusion[0]);
    }

    protected MavenDependency getComponentRuntimeBeamDependency() {
        return MavenDependencies.createDependency((String)("org.talend.sdk.component:component-runtime-beam:jar:" + this.kitVersion), (ScopeType)ScopeType.RUNTIME, (boolean)false, (MavenDependencyExclusion[])new MavenDependencyExclusion[0]);
    }

    @Override
    public String getName() {
        return super.getName().replace("Runner", "");
    }

    protected abstract String rootDependencyBase();
}

