/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.junit;

import java.io.ByteArrayOutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.xbean.propertyeditor.PropertyEditorRegistry;
import org.talend.sdk.component.api.service.configuration.LocalConfiguration;
import org.talend.sdk.component.runtime.manager.ParameterMeta;
import org.talend.sdk.component.runtime.manager.configuration.ConfigurationMapper;
import org.talend.sdk.component.runtime.manager.reflect.ParameterModelService;
import org.talend.sdk.component.runtime.manager.reflect.parameterenricher.BaseParameterEnricher;
import org.talend.sdk.component.runtime.manager.service.LocalConfigurationService;
import org.talend.sdk.component.runtime.manager.xbean.registry.EnrichedPropertyEditorRegistry;

public class SimpleFactory {
    public static ByExample configurationByExample() {
        return new ByExample();
    }

    public static <T> Map<String, String> configurationByExample(T instance) {
        return SimpleFactory.configurationByExample().forInstance(instance).configured().toMap();
    }

    public static <T> Map<String, String> configurationByExample(T instance, String prefix) {
        return SimpleFactory.configurationByExample().forInstance(instance).withPrefix(prefix).configured().toMap();
    }

    private SimpleFactory() {
    }

    public static class ConfigurationByExample {
        private static final ConfigurationMapper CONFIGURATION_MAPPER = new ConfigurationMapper();
        private final ByExample byExample;

        public Map<String, String> toMap() {
            if (this.byExample.instance == null) {
                return Collections.emptyMap();
            }
            String usedPrefix = Optional.ofNullable(this.byExample.prefix).orElse("configuration.");
            ParameterMeta params = new SimpleParameterModelService().build(usedPrefix, usedPrefix, this.byExample.instance.getClass(), new Annotation[0], new ArrayList<String>(Collections.singletonList(this.byExample.instance.getClass().getPackage().getName())));
            return CONFIGURATION_MAPPER.map(params.getNestedParameters(), this.byExample.instance);
        }

        public String toQueryString() {
            return this.toMap().entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).map(entry -> (String)entry.getKey() + "=" + ConfigurationByExample.encode((String)entry.getValue())).collect(Collectors.joining("&"));
        }

        private static String encode(String source) {
            byte[] bytes = source.getBytes(StandardCharsets.UTF_8);
            ByteArrayOutputStream bos = new ByteArrayOutputStream(bytes.length);
            boolean changed = false;
            for (byte rawByte : bytes) {
                byte b = rawByte;
                if (b < 0) {
                    b = (byte)(b + 256);
                }
                if (b >= 97 && b <= 122 || b >= 65 && b <= 90 || b >= 48 && b <= 57 || 45 == b || 46 == b || 95 == b || 126 == b) {
                    bos.write(b);
                    continue;
                }
                bos.write(37);
                char hex1 = Character.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16));
                char hex2 = Character.toUpperCase(Character.forDigit(b & 0xF, 16));
                bos.write(hex1);
                bos.write(hex2);
                changed = true;
            }
            return changed ? new String(bos.toByteArray(), StandardCharsets.UTF_8) : source;
        }

        private ConfigurationByExample(ByExample byExample) {
            this.byExample = byExample;
        }
    }

    public static class ByExample {
        private String prefix;
        private Object instance;

        public ByExample withPrefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public <T> ByExample forInstance(T instance) {
            this.instance = instance;
            return this;
        }

        public ConfigurationByExample configured() {
            return new ConfigurationByExample(this);
        }

        private ByExample() {
        }
    }

    private static class SimpleParameterModelService
    extends ParameterModelService {
        public SimpleParameterModelService() {
            super((PropertyEditorRegistry)new EnrichedPropertyEditorRegistry());
        }

        private ParameterMeta build(String name, String prefix, Type genericType, Annotation[] annotations, Collection<String> i18nPackages) {
            return super.buildParameter(name, prefix, null, genericType, annotations, i18nPackages, false, new BaseParameterEnricher.Context((LocalConfiguration)new LocalConfigurationService(Collections.emptyList(), "test")));
        }
    }
}

