/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.junit5.environment;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.talend.sdk.component.junit.environment.DecoratingEnvironmentProvider;
import org.talend.sdk.component.junit.environment.EnvironmentProvider;

class EnvironmentalContext
implements TestTemplateInvocationContext {
    private final EnvironmentProvider provider;
    private final String displayName;

    public String getDisplayName(int invocationIndex) {
        return this.displayName;
    }

    public List<Extension> getAdditionalExtensions() {
        return Collections.singletonList(new EnvironmentalLifecycle(this.provider, null));
    }

    public EnvironmentalContext(EnvironmentProvider provider, String displayName) {
        this.provider = provider;
        this.displayName = displayName;
    }

    private static class EnvironmentalLifecycle
    implements BeforeEachCallback,
    AfterEachCallback,
    ExecutionCondition {
        private final EnvironmentProvider provider;
        private AutoCloseable closeable;

        public void beforeEach(ExtensionContext context) {
            this.closeable = this.provider.start(context.getRequiredTestClass(), context.getRequiredTestClass().getAnnotations());
        }

        public void afterEach(ExtensionContext context) {
            Optional.ofNullable(this.closeable).ifPresent(c -> {
                try {
                    c.close();
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            });
        }

        public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
            return this.isActive() ? ConditionEvaluationResult.enabled((String)"provider is active") : ConditionEvaluationResult.disabled((String)"provider is disabled");
        }

        private boolean isActive() {
            return DecoratingEnvironmentProvider.class.isInstance(this.provider) && ((DecoratingEnvironmentProvider)DecoratingEnvironmentProvider.class.cast(this.provider)).isActive();
        }

        public EnvironmentalLifecycle(EnvironmentProvider provider, AutoCloseable closeable) {
            this.provider = provider;
            this.closeable = closeable;
        }
    }
}

