/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.junit.environment;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.talend.sdk.component.junit.environment.DecoratingEnvironmentProvider;
import org.talend.sdk.component.junit.environment.Environment;
import org.talend.sdk.component.junit.environment.EnvironmentProvider;
import org.talend.sdk.component.junit.environment.Environments;

public class EnvironmentsConfigurationParser {
    private final Collection<EnvironmentProvider> environments;
    private final boolean parallel;

    public EnvironmentsConfigurationParser(Class<?> testClass) {
        Optional<Environments> config = Optional.ofNullable(testClass.getAnnotation(Environments.class));
        this.environments = Stream.concat(config.map(Environments::value).map(Stream::of).orElseGet(Stream::empty), Optional.ofNullable(testClass.getAnnotation(Environment.class)).map(Stream::of).orElseGet(Stream::empty)).map(e -> {
            try {
                return e.value().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException ex) {
                throw new IllegalStateException(ex);
            }
            catch (InvocationTargetException ex) {
                throw new IllegalStateException(ex.getTargetException());
            }
        }).map(DecoratingEnvironmentProvider::new).collect(Collectors.toList());
        this.parallel = config.map(Environments::parallel).orElse(false);
    }

    public Stream<EnvironmentProvider> stream() {
        Stream<EnvironmentProvider> stream = this.environments.stream();
        if (this.parallel) {
            return (Stream)stream.parallel();
        }
        return stream;
    }
}

