/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.record;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.talend.sdk.component.api.record.Record;
import org.talend.sdk.component.api.record.Schema;
import org.talend.sdk.component.api.service.record.RecordBuilderFactory;
import org.talend.sdk.component.runtime.record.RecordImpl;
import org.talend.sdk.component.runtime.record.SchemaImpl;
import org.talend.sdk.component.runtime.record.Schemas;
import org.talend.sdk.component.runtime.serialization.SerializableService;

public class RecordBuilderFactoryImpl
implements RecordBuilderFactory,
Serializable {
    protected final String plugin;

    public Schema.Builder newSchemaBuilder(Schema.Type type) {
        switch (type) {
            case RECORD: 
            case ARRAY: {
                return new SchemaImpl.BuilderImpl().withType(type);
            }
        }
        return Schemas.valueOf(type.name());
    }

    public Schema.Builder newSchemaBuilder(Schema schema) {
        Schema.Builder builder = this.newSchemaBuilder(schema.getType());
        switch (schema.getType()) {
            case RECORD: {
                schema.getAllEntries().forEach(arg_0 -> ((Schema.Builder)builder).withEntry(arg_0));
                break;
            }
            case ARRAY: {
                builder.withElementSchema(schema.getElementSchema());
                break;
            }
        }
        return builder;
    }

    public Record.Builder newRecordBuilder(Schema schema, Record record) {
        Record.Builder builder = this.newRecordBuilder(schema);
        Map entriesIndex = schema.getAllEntries().collect(Collectors.toMap(Schema.Entry::getName, Function.identity()));
        record.getSchema().getAllEntries().filter(e -> entriesIndex.containsKey(e.getName())).forEach(entry -> {
            switch (entry.getType()) {
                case STRING: {
                    record.getOptionalString(entry.getName()).ifPresent(v -> builder.withString((Schema.Entry)entriesIndex.get(entry.getName()), v));
                    break;
                }
                case LONG: {
                    record.getOptionalLong(entry.getName()).ifPresent(v -> builder.withLong((Schema.Entry)entriesIndex.get(entry.getName()), v));
                    break;
                }
                case INT: {
                    record.getOptionalInt(entry.getName()).ifPresent(v -> builder.withInt((Schema.Entry)entriesIndex.get(entry.getName()), v));
                    break;
                }
                case DOUBLE: {
                    record.getOptionalDouble(entry.getName()).ifPresent(v -> builder.withDouble((Schema.Entry)entriesIndex.get(entry.getName()), v));
                    break;
                }
                case FLOAT: {
                    record.getOptionalFloat(entry.getName()).ifPresent(v -> builder.withFloat((Schema.Entry)entriesIndex.get(entry.getName()), (float)v));
                    break;
                }
                case BOOLEAN: {
                    record.getOptionalBoolean(entry.getName()).ifPresent(v -> builder.withBoolean((Schema.Entry)entriesIndex.get(entry.getName()), v.booleanValue()));
                    break;
                }
                case BYTES: {
                    record.getOptionalBytes(entry.getName()).ifPresent(v -> builder.withBytes((Schema.Entry)entriesIndex.get(entry.getName()), v));
                    break;
                }
                case DATETIME: {
                    record.getOptionalDateTime(entry.getName()).ifPresent(v -> builder.withDateTime((Schema.Entry)entriesIndex.get(entry.getName()), v));
                    break;
                }
                case DECIMAL: {
                    record.getOptionalDecimal(entry.getName()).ifPresent(v -> builder.withDecimal((Schema.Entry)entriesIndex.get(entry.getName()), v));
                    break;
                }
                case RECORD: {
                    record.getOptionalRecord(entry.getName()).ifPresent(v -> builder.withRecord((Schema.Entry)entriesIndex.get(entry.getName()), v));
                    break;
                }
                case ARRAY: {
                    record.getOptionalArray(Object.class, entry.getName()).ifPresent(v -> builder.withArray((Schema.Entry)entriesIndex.get(entry.getName()), v));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported entry type: " + entry);
                }
            }
        });
        return builder;
    }

    public Record.Builder newRecordBuilder(Schema schema) {
        return new RecordImpl.BuilderImpl(schema);
    }

    public Record.Builder newRecordBuilder() {
        return new RecordImpl.BuilderImpl();
    }

    public Schema.Entry.Builder newEntryBuilder() {
        return new SchemaImpl.EntryImpl.BuilderImpl();
    }

    Object writeReplace() throws ObjectStreamException {
        return new SerializableService(this.plugin, RecordBuilderFactory.class.getName());
    }

    public RecordBuilderFactoryImpl(String plugin) {
        this.plugin = plugin;
    }

    public String getPlugin() {
        return this.plugin;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecordBuilderFactoryImpl)) {
            return false;
        }
        RecordBuilderFactoryImpl other = (RecordBuilderFactoryImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$plugin = this.getPlugin();
        String other$plugin = other.getPlugin();
        return !(this$plugin == null ? other$plugin != null : !this$plugin.equals(other$plugin));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RecordBuilderFactoryImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $plugin = this.getPlugin();
        result = result * 59 + ($plugin == null ? 43 : $plugin.hashCode());
        return result;
    }

    public String toString() {
        return "RecordBuilderFactoryImpl(plugin=" + this.getPlugin() + ")";
    }
}

