/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.serialization;

import java.util.Iterator;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import lombok.Generated;
import org.talend.sdk.component.runtime.serialization.LightContainer;
import org.talend.sdk.component.runtime.serialization.TCCLContainerFinder;

@FunctionalInterface
public interface ContainerFinder {
    public LightContainer find(String var1);

    public static final class Instance {
        private static final AtomicReference<ContainerFinder> FINDER = new AtomicReference();

        public static boolean isInitialized() {
            return FINDER.get() != null;
        }

        public static void set(Supplier<ContainerFinder> provider) {
            FINDER.set(provider.get());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static ContainerFinder get() {
            if (!Instance.isInitialized()) {
                AtomicReference<ContainerFinder> atomicReference = FINDER;
                synchronized (atomicReference) {
                    Iterator<ContainerFinder> loader;
                    if (!Instance.isInitialized() && (loader = ServiceLoader.load(ContainerFinder.class, ContainerFinder.class.getClassLoader()).iterator()).hasNext()) {
                        FINDER.set(loader.next());
                    }
                }
            }
            return Optional.ofNullable(FINDER.get()).orElseGet(TCCLContainerFinder::new);
        }

        @Generated
        private Instance() {
        }
    }
}

