/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.record;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.bind.annotation.JsonbTransient;
import lombok.Generated;
import org.talend.sdk.component.api.record.OrderedMap;
import org.talend.sdk.component.api.record.Schema;
import org.talend.sdk.component.api.record.SchemaCompanionUtil;
import org.talend.sdk.component.api.record.SchemaProperty;

public class SchemaImpl
implements Schema {
    private final Schema.Type type;
    private final Schema elementSchema;
    private final List<Schema.Entry> entries;
    @JsonbTransient
    private final List<Schema.Entry> metadataEntries;
    private final Map<String, String> props;
    @JsonbTransient
    private final Schema.EntriesOrder entriesOrder;
    @JsonbTransient
    private Map<String, Schema.Entry> entryMap = new HashMap<String, Schema.Entry>();
    public static final String ENTRIES_ORDER_PROP = "talend.fields.order";

    SchemaImpl(BuilderImpl builder) {
        this.type = builder.type;
        this.elementSchema = builder.elementSchema;
        this.entries = Collections.unmodifiableList(builder.entries.streams().collect(Collectors.toList()));
        this.metadataEntries = Collections.unmodifiableList(builder.metadataEntries.streams().collect(Collectors.toList()));
        this.props = builder.props;
        this.entriesOrder = Schema.EntriesOrder.of((String)this.getFieldsOrder());
        this.getAllEntries().forEach(e -> this.entryMap.put(e.getName(), (Schema.Entry)e));
    }

    public int hashCode() {
        String e1 = this.entries != null ? this.entries.stream().map(Schema.Entry::getName).collect(Collectors.joining(",")) : "";
        String m1 = this.metadataEntries != null ? this.metadataEntries.stream().map(Schema.Entry::getName).collect(Collectors.joining(",")) : "";
        return Objects.hash(this.type, this.elementSchema, e1, m1);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SchemaImpl)) {
            return false;
        }
        SchemaImpl other = (SchemaImpl)obj;
        if (!other.canEqual(this)) {
            return false;
        }
        return Objects.equals(this.type, other.type) && Objects.equals(this.elementSchema, other.elementSchema) && Objects.equals(this.entries, other.entries) && Objects.equals(this.metadataEntries, other.metadataEntries) && Objects.equals(this.props, other.props);
    }

    protected boolean canEqual(SchemaImpl other) {
        return true;
    }

    public String getProp(String property) {
        return this.props.get(property);
    }

    public List<Schema.Entry> getMetadata() {
        return this.metadataEntries;
    }

    @JsonbTransient
    public Stream<Schema.Entry> getAllEntries() {
        return Stream.concat(this.metadataEntries.stream(), this.entries.stream());
    }

    public Schema.Builder toBuilder() {
        Schema.Builder builder = new BuilderImpl().withType(this.type).withElementSchema(this.elementSchema).withProps(this.props.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        this.getEntriesOrdered().forEach(arg_0 -> ((Schema.Builder)builder).withEntry(arg_0));
        return builder;
    }

    @JsonbTransient
    public List<Schema.Entry> getEntriesOrdered() {
        return this.getAllEntries().sorted((Comparator<Schema.Entry>)this.entriesOrder).collect(Collectors.toList());
    }

    @JsonbTransient
    public Schema.EntriesOrder naturalOrder() {
        return this.entriesOrder;
    }

    private String getFieldsOrder() {
        String fields = this.getProp(ENTRIES_ORDER_PROP);
        if (fields == null || fields.isEmpty()) {
            fields = this.getAllEntries().map(Schema.Entry::getName).collect(Collectors.joining(","));
            this.props.put(ENTRIES_ORDER_PROP, fields);
        }
        return fields;
    }

    @Generated
    public String toString() {
        return "SchemaImpl(type=" + this.getType() + ", elementSchema=" + this.getElementSchema() + ", entries=" + this.getEntries() + ", metadataEntries=" + this.metadataEntries + ", props=" + this.getProps() + ", entriesOrder=" + this.entriesOrder + ", entryMap=" + this.getEntryMap() + ")";
    }

    @Generated
    public Schema.Type getType() {
        return this.type;
    }

    @Generated
    public Schema getElementSchema() {
        return this.elementSchema;
    }

    @Generated
    public List<Schema.Entry> getEntries() {
        return this.entries;
    }

    @Generated
    public Map<String, String> getProps() {
        return this.props;
    }

    @Generated
    public Map<String, Schema.Entry> getEntryMap() {
        return this.entryMap;
    }

    public static class BuilderImpl
    implements Schema.Builder {
        private Schema.Type type;
        private Schema elementSchema;
        private final OrderedMap<Schema.Entry> entries = new OrderedMap(Schema.Entry::getName);
        private final OrderedMap<Schema.Entry> metadataEntries = new OrderedMap(Schema.Entry::getName);
        private Map<String, String> props = new LinkedHashMap<String, String>(0);
        private List<String> entriesOrder = new ArrayList<String>();

        public Schema.Builder withElementSchema(Schema schema) {
            if (this.type != Schema.Type.ARRAY && schema != null) {
                throw new IllegalArgumentException("elementSchema is only valid for ARRAY type of schema");
            }
            this.elementSchema = schema;
            return this;
        }

        public Schema.Builder withType(Schema.Type type) {
            this.type = type;
            return this;
        }

        public Schema.Builder withEntry(Schema.Entry entry) {
            if (this.type != Schema.Type.RECORD) {
                throw new IllegalArgumentException("entry is only valid for RECORD type of schema");
            }
            Schema.Entry entryToAdd = SchemaCompanionUtil.avoidCollision((Schema.Entry)entry, this::getEntry, this::replaceEntry);
            if (entryToAdd == null) {
                throw new IllegalArgumentException("Entry with name " + entry.getName() + " already exist in schema");
            }
            if (entryToAdd.isMetadata()) {
                this.metadataEntries.addValue((Object)entryToAdd);
            } else {
                this.entries.addValue((Object)entryToAdd);
            }
            this.entriesOrder.add(entryToAdd.getName());
            return this;
        }

        public Schema.Builder withEntryAfter(String after, Schema.Entry entry) {
            this.withEntry(entry);
            return this.moveAfter(after, entry.getName());
        }

        public Schema.Builder withEntryBefore(String before, Schema.Entry entry) {
            this.withEntry(entry);
            return this.moveBefore(before, entry.getName());
        }

        private void replaceEntry(String name, Schema.Entry entry) {
            if (this.entries.getValue(name) != null) {
                this.entries.replace(name, (Object)entry);
            } else if (this.metadataEntries.getValue(name) != null) {
                this.metadataEntries.replace(name, (Object)entry);
            }
        }

        private Stream<Schema.Entry> getAllEntries() {
            return Stream.concat(this.entries.streams(), this.metadataEntries.streams());
        }

        public Schema.Builder withProp(String key, String value) {
            this.props.put(key, value);
            return this;
        }

        public Schema.Builder withProps(Map<String, String> props) {
            if (props != null) {
                this.props = props;
            }
            return this;
        }

        public Schema.Builder remove(String name) {
            Schema.Entry entry = this.getEntry(name);
            if (entry == null) {
                throw new IllegalArgumentException(String.format("%s not in schema", name));
            }
            return this.remove(entry);
        }

        public Schema.Builder remove(Schema.Entry entry) {
            if (entry != null) {
                if (entry.isMetadata()) {
                    if (this.metadataEntries.getValue(entry.getName()) != null) {
                        this.metadataEntries.removeValue((Object)entry);
                    }
                } else if (this.entries.getValue(entry.getName()) != null) {
                    this.entries.removeValue((Object)entry);
                }
                this.entriesOrder.remove(entry.getName());
            }
            return this;
        }

        public Schema.Builder moveAfter(String after, String name) {
            if (this.entriesOrder.indexOf(after) == -1) {
                throw new IllegalArgumentException(String.format("%s not in schema", after));
            }
            this.entriesOrder.remove(name);
            int destination = this.entriesOrder.indexOf(after) + 1;
            if (destination < this.entriesOrder.size()) {
                this.entriesOrder.add(destination, name);
            } else {
                this.entriesOrder.add(name);
            }
            return this;
        }

        public Schema.Builder moveBefore(String before, String name) {
            if (this.entriesOrder.indexOf(before) == -1) {
                throw new IllegalArgumentException(String.format("%s not in schema", before));
            }
            this.entriesOrder.remove(name);
            this.entriesOrder.add(this.entriesOrder.indexOf(before), name);
            return this;
        }

        public Schema.Builder swap(String name, String with) {
            Collections.swap(this.entriesOrder, this.entriesOrder.indexOf(name), this.entriesOrder.indexOf(with));
            return this;
        }

        public Schema build() {
            if (this.entriesOrder != null && !this.entriesOrder.isEmpty()) {
                this.props.put(SchemaImpl.ENTRIES_ORDER_PROP, this.entriesOrder.stream().collect(Collectors.joining(",")));
            }
            return new SchemaImpl(this);
        }

        public Schema build(Comparator<Schema.Entry> order) {
            String entriesOrderProp = this.getAllEntries().sorted(order).map(Schema.Entry::getName).collect(Collectors.joining(","));
            this.props.put(SchemaImpl.ENTRIES_ORDER_PROP, entriesOrderProp);
            return new SchemaImpl(this);
        }

        private Schema.Entry getEntry(String name) {
            Schema.Entry entry = (Schema.Entry)this.entries.getValue(name);
            if (entry == null) {
                entry = (Schema.Entry)this.metadataEntries.getValue(name);
            }
            return entry;
        }
    }

    public static class EntryImpl
    implements Schema.Entry {
        private final String name;
        private final String rawName;
        private final Schema.Type type;
        private final boolean nullable;
        private final boolean errorCapable;
        private final boolean metadata;
        private final Object defaultValue;
        private final Schema elementSchema;
        private final String comment;
        private final Map<String, String> props = new LinkedHashMap<String, String>(0);

        private EntryImpl(BuilderImpl builder) {
            this.name = builder.name;
            this.rawName = builder.rawName;
            this.type = builder.type == null && builder.logicalType != null ? builder.logicalType.storageType() : builder.type;
            this.nullable = builder.nullable;
            this.errorCapable = builder.errorCapable;
            this.metadata = builder.metadata;
            this.defaultValue = builder.defaultValue;
            this.elementSchema = builder.elementSchema;
            this.comment = builder.comment;
            this.props.putAll(builder.props);
        }

        @JsonbTransient
        public String getOriginalFieldName() {
            return this.rawName != null ? this.rawName : this.name;
        }

        public String getProp(String property) {
            return this.props.get(property);
        }

        public Schema.Entry.Builder toBuilder() {
            return new BuilderImpl(this);
        }

        public String getName() {
            return this.name;
        }

        public String getRawName() {
            return this.rawName;
        }

        public Schema.Type getType() {
            return this.type;
        }

        public boolean isNullable() {
            return this.nullable;
        }

        public boolean isErrorCapable() {
            return this.errorCapable;
        }

        public boolean isMetadata() {
            return this.metadata;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public Schema getElementSchema() {
            return this.elementSchema;
        }

        public String getComment() {
            return this.comment;
        }

        public Map<String, String> getProps() {
            return this.props;
        }

        public boolean isValid() {
            String property = this.getProp("record.value.on.error");
            if (property == null) {
                return true;
            }
            return !Boolean.parseBoolean(property);
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EntryImpl)) {
                return false;
            }
            EntryImpl other = (EntryImpl)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isNullable() != other.isNullable()) {
                return false;
            }
            if (this.isErrorCapable() != other.isErrorCapable()) {
                return false;
            }
            if (this.isMetadata() != other.isMetadata()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$rawName = this.getRawName();
            String other$rawName = other.getRawName();
            if (this$rawName == null ? other$rawName != null : !this$rawName.equals(other$rawName)) {
                return false;
            }
            Schema.Type this$type = this.getType();
            Schema.Type other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            Object this$defaultValue = this.getDefaultValue();
            Object other$defaultValue = other.getDefaultValue();
            if (this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue)) {
                return false;
            }
            Schema this$elementSchema = this.getElementSchema();
            Schema other$elementSchema = other.getElementSchema();
            if (this$elementSchema == null ? other$elementSchema != null : !this$elementSchema.equals(other$elementSchema)) {
                return false;
            }
            String this$comment = this.getComment();
            String other$comment = other.getComment();
            if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
                return false;
            }
            Map<String, String> this$props = this.getProps();
            Map<String, String> other$props = other.getProps();
            return !(this$props == null ? other$props != null : !((Object)this$props).equals(other$props));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof EntryImpl;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isNullable() ? 79 : 97);
            result = result * 59 + (this.isErrorCapable() ? 79 : 97);
            result = result * 59 + (this.isMetadata() ? 79 : 97);
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $rawName = this.getRawName();
            result = result * 59 + ($rawName == null ? 43 : $rawName.hashCode());
            Schema.Type $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            Object $defaultValue = this.getDefaultValue();
            result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
            Schema $elementSchema = this.getElementSchema();
            result = result * 59 + ($elementSchema == null ? 43 : $elementSchema.hashCode());
            String $comment = this.getComment();
            result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
            Map<String, String> $props = this.getProps();
            result = result * 59 + ($props == null ? 43 : ((Object)$props).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SchemaImpl.EntryImpl(name=" + this.getName() + ", rawName=" + this.getRawName() + ", type=" + this.getType() + ", nullable=" + this.isNullable() + ", errorCapable=" + this.isErrorCapable() + ", metadata=" + this.isMetadata() + ", defaultValue=" + this.getDefaultValue() + ", elementSchema=" + this.getElementSchema() + ", comment=" + this.getComment() + ", props=" + this.getProps() + ")";
        }

        public static class BuilderImpl
        implements Schema.Entry.Builder {
            private String name;
            private String rawName;
            private Schema.Type type;
            private boolean nullable;
            private boolean errorCapable;
            private boolean metadata = false;
            private Object defaultValue;
            private Schema elementSchema;
            private String comment;
            private SchemaProperty.LogicalType logicalType;
            private final Map<String, String> props = new LinkedHashMap<String, String>(0);

            public BuilderImpl() {
            }

            private BuilderImpl(Schema.Entry entry) {
                this.name = entry.getName();
                this.rawName = entry.getRawName();
                this.nullable = entry.isNullable();
                this.errorCapable = entry.isErrorCapable();
                this.type = entry.getType();
                this.comment = entry.getComment();
                this.elementSchema = entry.getElementSchema();
                this.defaultValue = entry.getDefaultValue();
                this.metadata = entry.isMetadata();
                this.props.putAll(entry.getProps());
            }

            public Schema.Entry.Builder withName(String name) {
                this.name = SchemaCompanionUtil.sanitizeName((String)name);
                if (!name.equals(this.name)) {
                    this.rawName = name;
                }
                return this;
            }

            public Schema.Entry.Builder withRawName(String rawName) {
                this.rawName = rawName;
                return this;
            }

            public Schema.Entry.Builder withType(Schema.Type type) {
                this.type = type;
                return this;
            }

            public Schema.Entry.Builder withLogicalType(SchemaProperty.LogicalType logicalType) {
                this.logicalType = logicalType;
                this.props.put("field.logical.type", logicalType.key());
                return this;
            }

            public Schema.Entry.Builder withNullable(boolean nullable) {
                this.nullable = nullable;
                return this;
            }

            public Schema.Entry.Builder withErrorCapable(boolean errorCapable) {
                this.errorCapable = errorCapable;
                return this;
            }

            public Schema.Entry.Builder withMetadata(boolean metadata) {
                this.metadata = metadata;
                return this;
            }

            public <T> Schema.Entry.Builder withDefaultValue(T value) {
                this.defaultValue = value;
                return this;
            }

            public Schema.Entry.Builder withElementSchema(Schema schema) {
                this.elementSchema = schema;
                return this;
            }

            public Schema.Entry.Builder withComment(String comment) {
                this.comment = comment;
                return this;
            }

            public Schema.Entry.Builder withProp(String key, String value) {
                this.props.put(key, value);
                return this;
            }

            public Schema.Entry.Builder withProps(Map props) {
                if (props == null) {
                    return this;
                }
                this.props.putAll(props);
                return this;
            }

            public Schema.Entry build() {
                return new EntryImpl(this);
            }
        }
    }
}

