/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.output;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.Json;
import javax.json.JsonBuilderFactory;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.JsonbConfig;
import javax.json.spi.JsonProvider;
import org.talend.sdk.component.api.processor.AfterGroup;
import org.talend.sdk.component.api.processor.BeforeGroup;
import org.talend.sdk.component.api.processor.ElementListener;
import org.talend.sdk.component.api.processor.Input;
import org.talend.sdk.component.api.processor.Output;
import org.talend.sdk.component.api.service.record.RecordBuilderFactory;
import org.talend.sdk.component.runtime.base.Delegated;
import org.talend.sdk.component.runtime.base.LifecycleImpl;
import org.talend.sdk.component.runtime.output.InputFactory;
import org.talend.sdk.component.runtime.output.OutputFactory;
import org.talend.sdk.component.runtime.output.Processor;
import org.talend.sdk.component.runtime.record.RecordBuilderFactoryImpl;
import org.talend.sdk.component.runtime.record.RecordConverters;
import org.talend.sdk.component.runtime.reflect.Parameters;
import org.talend.sdk.component.runtime.serialization.ContainerFinder;
import org.talend.sdk.component.runtime.serialization.EnhancedObjectInputStream;

public class ProcessorImpl
extends LifecycleImpl
implements Processor,
Delegated {
    private transient List<Method> beforeGroup;
    private transient List<Method> afterGroup;
    private transient Method process;
    private transient List<BiFunction<InputFactory, OutputFactory, Object>> parameterBuilderProcess;
    private transient Map<Method, List<Function<OutputFactory, Object>>> parameterBuilderAfterGroup;
    private transient Jsonb jsonb;
    private transient JsonBuilderFactory jsonBuilderFactory;
    private transient RecordBuilderFactory recordBuilderFactory;
    private transient JsonProvider jsonProvider;
    private transient boolean forwardReturn;
    private transient RecordConverters converter;
    private transient Class<?> expectedRecordType;
    private transient Collection<Object> records;
    private Map<String, String> internalConfiguration;
    private RecordConverters.MappingMetaRegistry mappings;

    public ProcessorImpl(String rootName, String name, String plugin, Map<String, String> internalConfiguration, Serializable delegate) {
        super(delegate, rootName, name, plugin);
        this.internalConfiguration = internalConfiguration;
    }

    protected ProcessorImpl() {
    }

    public Map<String, String> getInternalConfiguration() {
        return Optional.ofNullable(this.internalConfiguration).orElseGet(Collections::emptyMap);
    }

    @Override
    public void beforeGroup() {
        if (this.beforeGroup == null) {
            this.beforeGroup = this.findMethods(BeforeGroup.class).collect(Collectors.toList());
            this.afterGroup = this.findMethods(AfterGroup.class).collect(Collectors.toList());
            this.process = this.findMethods(ElementListener.class).findFirst().orElse(null);
            this.parameterBuilderProcess = this.process == null ? Collections.emptyList() : Stream.of(this.process.getParameters()).map(this::buildProcessParamBuilder).collect(Collectors.toList());
            this.parameterBuilderAfterGroup = this.afterGroup.stream().map(after -> new AbstractMap.SimpleEntry((Method)after, Stream.of(after.getParameters()).map(param -> {
                if (Parameters.isGroupBuffer(param.getParameterizedType())) {
                    this.expectedRecordType = (Class)Class.class.cast(((ParameterizedType)ParameterizedType.class.cast(param.getParameterizedType())).getActualTypeArguments()[0]);
                    return o -> this.records;
                }
                return this.toOutputParamBuilder((Parameter)param);
            }).collect(Collectors.toList()))).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
            this.forwardReturn = this.process != null && this.process.getReturnType() != Void.TYPE;
            this.converter = new RecordConverters();
            this.mappings = new RecordConverters.MappingMetaRegistry();
        }
        this.beforeGroup.forEach(x$0 -> this.doInvoke((Method)x$0, new Object[0]));
        if (this.process == null) {
            this.records = new ArrayList<Object>();
        }
    }

    private BiFunction<InputFactory, OutputFactory, Object> buildProcessParamBuilder(Parameter parameter) {
        if (parameter.isAnnotationPresent(Output.class)) {
            return (inputs, outputs) -> {
                String name = parameter.getAnnotation(Output.class).value();
                return outputs.create(name);
            };
        }
        Class<?> parameterType = parameter.getType();
        String inputName = Optional.ofNullable(parameter.getAnnotation(Input.class)).map(Input::value).orElse("__default__");
        return (inputs, outputs) -> this.doConvertInput(parameterType, inputs.read(inputName));
    }

    private Function<OutputFactory, Object> toOutputParamBuilder(Parameter parameter) {
        return outputs -> {
            String name = parameter.getAnnotation(Output.class).value();
            return outputs.create(name);
        };
    }

    private Object doConvertInput(Class<?> parameterType, Object data) {
        if (data == null || parameterType.isInstance(data) || parameterType.isPrimitive()) {
            return data;
        }
        return this.converter.toType(this.mappings, data, parameterType, this::jsonBuilderFactory, this::jsonProvider, this::jsonb, this::recordBuilderFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Jsonb jsonb() {
        if (this.jsonb != null) {
            return this.jsonb;
        }
        ProcessorImpl processorImpl = this;
        synchronized (processorImpl) {
            if (this.jsonb == null) {
                this.jsonb = ContainerFinder.Instance.get().find(this.plugin()).findService(Jsonb.class);
            }
            if (this.jsonb == null) {
                this.jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withBinaryDataStrategy("BASE_64"));
            }
        }
        return this.jsonb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RecordBuilderFactory recordBuilderFactory() {
        if (this.recordBuilderFactory != null) {
            return this.recordBuilderFactory;
        }
        ProcessorImpl processorImpl = this;
        synchronized (processorImpl) {
            if (this.recordBuilderFactory == null) {
                this.recordBuilderFactory = ContainerFinder.Instance.get().find(this.plugin()).findService(RecordBuilderFactory.class);
            }
            if (this.recordBuilderFactory == null) {
                this.recordBuilderFactory = new RecordBuilderFactoryImpl("$volatile");
            }
        }
        return this.recordBuilderFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonBuilderFactory jsonBuilderFactory() {
        if (this.jsonBuilderFactory != null) {
            return this.jsonBuilderFactory;
        }
        ProcessorImpl processorImpl = this;
        synchronized (processorImpl) {
            if (this.jsonBuilderFactory == null) {
                this.jsonBuilderFactory = ContainerFinder.Instance.get().find(this.plugin()).findService(JsonBuilderFactory.class);
            }
            if (this.jsonBuilderFactory == null) {
                this.jsonBuilderFactory = Json.createBuilderFactory(Collections.emptyMap());
            }
        }
        return this.jsonBuilderFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonProvider jsonProvider() {
        if (this.jsonProvider != null) {
            return this.jsonProvider;
        }
        ProcessorImpl processorImpl = this;
        synchronized (processorImpl) {
            if (this.jsonProvider == null) {
                this.jsonProvider = ContainerFinder.Instance.get().find(this.plugin()).findService(JsonProvider.class);
            }
        }
        return this.jsonProvider;
    }

    @Override
    public void afterGroup(OutputFactory output) {
        this.afterGroup.forEach(after -> this.doInvoke((Method)after, this.parameterBuilderAfterGroup.get(after).stream().map(b -> b.apply(output)).toArray(Object[]::new)));
        if (this.records != null) {
            this.records = null;
        }
    }

    @Override
    public void onNext(InputFactory inputFactory, OutputFactory outputFactory) {
        if (this.process == null) {
            this.records.add(this.doConvertInput(this.expectedRecordType, inputFactory.read("__default__")));
        } else {
            Object[] args = this.parameterBuilderProcess.stream().map(b -> b.apply(inputFactory, outputFactory)).toArray(Object[]::new);
            Object out = this.doInvoke(this.process, args);
            if (this.forwardReturn) {
                outputFactory.create("__default__").emit(out);
            }
        }
    }

    @Override
    public Object getDelegate() {
        return this.delegate;
    }

    Object writeReplace() throws ObjectStreamException {
        return new SerializationReplacer(this.plugin(), this.rootName(), this.name(), this.internalConfiguration, this.serializeDelegate());
    }

    protected static Serializable loadDelegate(byte[] value, String plugin) throws IOException, ClassNotFoundException {
        try (EnhancedObjectInputStream ois = new EnhancedObjectInputStream(new ByteArrayInputStream(value), ContainerFinder.Instance.get().find(plugin).classloader());){
            Serializable serializable = (Serializable)Serializable.class.cast(ois.readObject());
            return serializable;
        }
    }

    private static class SerializationReplacer
    implements Serializable {
        private final String plugin;
        private final String component;
        private final String name;
        private final Map<String, String> internalConfiguration;
        private final byte[] value;

        Object readResolve() throws ObjectStreamException {
            try {
                return new ProcessorImpl(this.component, this.name, this.plugin, this.internalConfiguration, ProcessorImpl.loadDelegate(this.value, this.plugin));
            }
            catch (IOException | ClassNotFoundException e) {
                InvalidObjectException invalidObjectException = new InvalidObjectException(e.getMessage());
                invalidObjectException.initCause(e);
                throw invalidObjectException;
            }
        }

        public SerializationReplacer(String plugin, String component, String name, Map<String, String> internalConfiguration, byte[] value) {
            this.plugin = plugin;
            this.component = component;
            this.name = name;
            this.internalConfiguration = internalConfiguration;
            this.value = value;
        }
    }
}

