/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.record;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.AbstractMap;
import java.util.Base64;
import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingUtils {
    private static final Logger log = LoggerFactory.getLogger(MappingUtils.class);
    private static final ZoneId UTC = ZoneId.of("UTC");
    private static final Map<Class<?>, Class<?>> PRIMITIVE_WRAPPER_MAP = Stream.of(new AbstractMap.SimpleImmutableEntry<Class<Boolean>, Class<Boolean>>(Boolean.TYPE, Boolean.class), new AbstractMap.SimpleImmutableEntry<Class<Byte>, Class<Byte>>(Byte.TYPE, Byte.class), new AbstractMap.SimpleImmutableEntry<Class<Character>, Class<Character>>(Character.TYPE, Character.class), new AbstractMap.SimpleImmutableEntry<Class<Double>, Class<Double>>(Double.TYPE, Double.class), new AbstractMap.SimpleImmutableEntry<Class<Float>, Class<Float>>(Float.TYPE, Float.class), new AbstractMap.SimpleImmutableEntry<Class<Integer>, Class<Integer>>(Integer.TYPE, Integer.class), new AbstractMap.SimpleImmutableEntry<Class<Long>, Class<Long>>(Long.TYPE, Long.class), new AbstractMap.SimpleImmutableEntry<Class<Short>, Class<Short>>(Short.TYPE, Short.class)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));

    public static <T> Object coerce(Class<T> expectedType, Object value, String name) {
        log.trace("[coerce] expectedType={}, value={}, name={}.", new Object[]{expectedType, value, name});
        if (value == null) {
            return null;
        }
        if (Long.class.isInstance(value) && expectedType != Long.class) {
            if (ZonedDateTime.class == expectedType) {
                long epochMilli = ((Number)Number.class.cast(value)).longValue();
                return ZonedDateTime.ofInstant(Instant.ofEpochMilli(epochMilli), UTC);
            }
            if (Date.class == expectedType) {
                return new Date(((Number)Number.class.cast(value)).longValue());
            }
            if (Instant.class == expectedType) {
                return Instant.ofEpochMilli(((Number)Number.class.cast(value)).longValue());
            }
        }
        if (expectedType == BigDecimal.class && String.class.isInstance(value)) {
            return new BigDecimal((String)String.class.cast(value));
        }
        if (!expectedType.isInstance(value)) {
            if (Number.class.isInstance(value) && Number.class.isAssignableFrom(PRIMITIVE_WRAPPER_MAP.getOrDefault(expectedType, expectedType))) {
                return MappingUtils.mapNumber(expectedType, (Number)Number.class.cast(value));
            }
            if (MappingUtils.isAssignableTo(value.getClass(), expectedType)) {
                return MappingUtils.mapPrimitiveWrapper(expectedType, value);
            }
            if (String.class == expectedType) {
                return String.valueOf(value);
            }
            if (Instant.class.isInstance(value)) {
                if (ZonedDateTime.class == expectedType) {
                    return ZonedDateTime.ofInstant((Instant)value, UTC);
                }
                if (Date.class == expectedType) {
                    return Timestamp.from((Instant)value);
                }
                if (Long.class == expectedType) {
                    return ((Instant)value).toEpochMilli();
                }
            }
            if (Timestamp.class.isInstance(value) && (Date.class == expectedType || Instant.class == expectedType)) {
                return value;
            }
            if (value instanceof long[]) {
                Instant instant = Instant.ofEpochSecond(((long[])value)[0], ((long[])value)[1]);
                if (ZonedDateTime.class == expectedType) {
                    return ZonedDateTime.ofInstant(instant, UTC);
                }
                if (Instant.class == expectedType) {
                    return instant;
                }
            }
            if (String.class.isInstance(value)) {
                return MappingUtils.mapString(expectedType, String.valueOf(value));
            }
            throw new IllegalArgumentException(String.format("%s can't be converted to %s as its value is '%s' of type %s.", name, expectedType, value, value.getClass()));
        }
        return value;
    }

    public static <T> Object mapPrimitiveWrapper(Class<T> expected, Object value) {
        if (Character.TYPE == expected || Character.class == expected) {
            return expected.isPrimitive() ? Character.valueOf(((Character)Character.class.cast(value)).charValue()) : value;
        }
        if (Boolean.class == expected || Boolean.TYPE == expected) {
            return expected.isPrimitive() ? Boolean.valueOf((Boolean)Boolean.class.cast(value)) : value;
        }
        if (Integer.class == expected || Integer.TYPE == expected) {
            return expected.isPrimitive() ? Integer.valueOf((Integer)Integer.class.cast(value)) : value;
        }
        if (Long.class == expected || Long.TYPE == expected) {
            return expected.isPrimitive() ? Long.valueOf((Long)Long.class.cast(value)) : value;
        }
        if (Short.class == expected || Short.TYPE == expected) {
            return expected.isPrimitive() ? Short.valueOf((Short)Short.class.cast(value)) : value;
        }
        if (Byte.class == expected || Byte.TYPE == expected) {
            return expected.isPrimitive() ? Byte.valueOf((Byte)Byte.class.cast(value)) : value;
        }
        if (Float.class == expected || Float.TYPE == expected) {
            return expected.isPrimitive() ? Float.valueOf(((Float)Float.class.cast(value)).floatValue()) : value;
        }
        if (Double.class == expected || Double.TYPE == expected) {
            return expected.isPrimitive() ? Double.valueOf((Double)Double.class.cast(value)) : value;
        }
        throw new IllegalArgumentException(String.format("Can't convert %s to %s.", value, expected));
    }

    public static <T> Object mapNumber(Class<T> expected, Number value) {
        if (expected == BigDecimal.class) {
            return BigDecimal.valueOf(value.doubleValue());
        }
        if (expected == Double.class || expected == Double.TYPE) {
            return value.doubleValue();
        }
        if (expected == Float.class || expected == Float.TYPE) {
            return Float.valueOf(value.floatValue());
        }
        if (expected == Integer.class || expected == Integer.TYPE) {
            return value.intValue();
        }
        if (expected == Long.class || expected == Long.TYPE) {
            return value.longValue();
        }
        if (expected == Byte.class || expected == Byte.TYPE) {
            return value.byteValue();
        }
        if (expected == Short.class || expected == Short.TYPE) {
            return value.shortValue();
        }
        throw new IllegalArgumentException(String.format("Can't convert %s to %s.", value, expected));
    }

    public static <T> Object mapString(Class<T> expected, String value) {
        boolean isNumeric = value.chars().allMatch(Character::isDigit);
        if (ZonedDateTime.class == expected) {
            if (isNumeric) {
                return ZonedDateTime.ofInstant(Instant.ofEpochMilli(Long.valueOf(value)), UTC);
            }
            return ZonedDateTime.parse(value);
        }
        if (Date.class == expected) {
            if (isNumeric) {
                return Date.from(Instant.ofEpochMilli(Long.valueOf(value)));
            }
            return Date.from(ZonedDateTime.parse(value).toInstant());
        }
        if (Character.TYPE == expected || Character.class == expected) {
            return Character.valueOf(value.isEmpty() ? (char)'\u0000' : value.charAt(0));
        }
        if (byte[].class == expected) {
            log.warn("[mapString] Expecting a `byte[]` but received a `String`. Using `Base64.getDecoder().decode()` and `String.getBytes()` if first fails: result may be inaccurate.");
            try {
                return Base64.getDecoder().decode(value);
            }
            catch (Exception e) {
                return value.getBytes();
            }
        }
        if (BigDecimal.class == expected) {
            return new BigDecimal(value);
        }
        if (Boolean.class == expected || Boolean.TYPE == expected) {
            return Boolean.valueOf(value);
        }
        if (Integer.class == expected || Integer.TYPE == expected) {
            return Integer.valueOf(value);
        }
        if (Long.class == expected || Long.TYPE == expected) {
            return Long.valueOf(value);
        }
        if (Short.class == expected || Short.TYPE == expected) {
            return Short.valueOf(value);
        }
        if (Byte.class == expected || Byte.TYPE == expected) {
            return Byte.valueOf(value);
        }
        if (Float.class == expected || Float.TYPE == expected) {
            return Float.valueOf(value);
        }
        if (Double.class == expected || Double.TYPE == expected) {
            return Double.valueOf(value);
        }
        throw new IllegalArgumentException(String.format("Can't convert %s to %s.", value, expected));
    }

    public static boolean isPrimitiveWrapperOf(Class<?> targetClass, Class<?> primitive) {
        if (!primitive.isPrimitive()) {
            throw new IllegalArgumentException("First argument has to be primitive type");
        }
        return PRIMITIVE_WRAPPER_MAP.get(primitive) == targetClass;
    }

    public static boolean isAssignableTo(Class<?> from, Class<?> to) {
        if (to.isAssignableFrom(from)) {
            return true;
        }
        if (from.isPrimitive()) {
            return MappingUtils.isPrimitiveWrapperOf(to, from);
        }
        if (to.isPrimitive()) {
            return MappingUtils.isPrimitiveWrapperOf(from, to);
        }
        return false;
    }
}

