/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.input;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.runtime.input.InputImpl;
import org.talend.sdk.component.runtime.input.Streaming;

public class StreamingInputImpl
extends InputImpl {
    private static final Logger log = LoggerFactory.getLogger(StreamingInputImpl.class);
    private Streaming.RetryConfiguration retryConfiguration;
    private transient Thread shutdownHook;
    private final AtomicBoolean running = new AtomicBoolean();
    private transient Semaphore semaphore;
    private Streaming.StopStrategy stopStrategy;
    private transient long readRecords = 0L;

    public StreamingInputImpl(String rootName, String name, String plugin, Serializable instance, Streaming.RetryConfiguration retryConfiguration, Streaming.StopStrategy stopStrategy) {
        super(rootName, name, plugin, instance);
        this.shutdownHook = new Thread(() -> this.running.compareAndSet(true, false), this.getClass().getName() + "_" + this.rootName() + "-" + this.name() + "_" + this.hashCode());
        this.retryConfiguration = retryConfiguration;
        this.stopStrategy = stopStrategy;
        log.debug("[StreamingInputImpl] Created with retryStrategy: {}, stopStrategy: {}.", (Object)this.retryConfiguration, (Object)this.stopStrategy);
    }

    protected StreamingInputImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object readNext() {
        if (!this.running.get()) {
            return null;
        }
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        try {
            if (this.stopStrategy.isActive() && this.stopStrategy.shouldStop(this.readRecords)) {
                Object e = null;
                return e;
            }
            Streaming.RetryStrategy strategy = this.retryConfiguration.getStrategy();
            int retries = this.retryConfiguration.getMaxRetries();
            while (this.running.get() && retries > 0) {
                Object next = super.readNext();
                if (next != null) {
                    strategy.reset();
                    ++this.readRecords;
                    Object object = next;
                    return object;
                }
                --retries;
                try {
                    long current;
                    long millis = strategy.nextPauseDuration();
                    if (millis < 0L) {
                        this.prepareStop();
                        continue;
                    }
                    if (millis <= 0L) continue;
                    if (millis < 1000L) {
                        Thread.sleep(millis);
                        continue;
                    }
                    for (long remaining = millis; this.running.get() && remaining > 0L; remaining -= current) {
                        current = Math.min(remaining, 250L);
                        Thread.sleep(current);
                    }
                }
                catch (InterruptedException e) {
                    this.prepareStop();
                }
            }
            Object var3_5 = null;
            return var3_5;
        }
        finally {
            this.semaphore.release();
        }
    }

    @Override
    protected void init() {
        super.init();
        this.semaphore = new Semaphore(1);
    }

    @Override
    public void start() {
        super.start();
        this.running.compareAndSet(false, true);
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    @Override
    public void stop() {
        this.prepareStop();
        super.stop();
    }

    private void prepareStop() {
        this.running.compareAndSet(true, false);
        if (this.shutdownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    protected Object writeReplace() throws ObjectStreamException {
        return new StreamSerializationReplacer(this.plugin(), this.rootName(), this.name(), this.serializeDelegate(), this.retryConfiguration, this.stopStrategy);
    }

    private static class StreamSerializationReplacer
    extends InputImpl.SerializationReplacer {
        private final Streaming.RetryConfiguration retryConfiguration;
        private final Streaming.StopStrategy stopStrategy;

        StreamSerializationReplacer(String plugin, String component, String name, byte[] value, Streaming.RetryConfiguration retryConfiguration, Streaming.StopStrategy stopStrategy) {
            super(plugin, component, name, value);
            this.retryConfiguration = retryConfiguration;
            this.stopStrategy = stopStrategy;
        }

        @Override
        protected Object readResolve() throws ObjectStreamException {
            try {
                return new StreamingInputImpl(this.component, this.name, this.plugin, this.loadDelegate(), this.retryConfiguration, this.stopStrategy);
            }
            catch (IOException | ClassNotFoundException e) {
                InvalidObjectException invalidObjectException = new InvalidObjectException(e.getMessage());
                invalidObjectException.initCause(e);
                throw invalidObjectException;
            }
        }
    }
}

