/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.input;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Method;
import javax.json.bind.Jsonb;
import org.talend.sdk.component.api.input.Producer;
import org.talend.sdk.component.api.service.record.RecordBuilderFactory;
import org.talend.sdk.component.runtime.base.Delegated;
import org.talend.sdk.component.runtime.base.LifecycleImpl;
import org.talend.sdk.component.runtime.input.Input;
import org.talend.sdk.component.runtime.record.RecordConverters;
import org.talend.sdk.component.runtime.serialization.ContainerFinder;
import org.talend.sdk.component.runtime.serialization.EnhancedObjectInputStream;
import org.talend.sdk.component.runtime.serialization.LightContainer;

public class InputImpl
extends LifecycleImpl
implements Input,
Delegated {
    private transient Method next;
    private transient RecordConverters converters;
    private transient RecordConverters.MappingMetaRegistry registry;
    private transient Jsonb jsonb;
    private transient RecordBuilderFactory recordBuilderFactory;

    public InputImpl(String rootName, String name, String plugin, Serializable instance) {
        super(instance, rootName, name, plugin);
    }

    protected InputImpl() {
    }

    @Override
    public Object next() {
        Object record;
        if (this.next == null) {
            this.init();
        }
        if ((record = this.readNext()) == null) {
            return null;
        }
        Class<?> recordClass = record.getClass();
        if (recordClass.isPrimitive() || String.class == recordClass) {
            return record;
        }
        return this.converters.toRecord(this.registry, record, this::jsonb, this::recordBuilderFactory);
    }

    @Override
    public Object getDelegate() {
        return this.delegate;
    }

    protected Object readNext() {
        return this.doInvoke(this.next, new Object[0]);
    }

    protected void init() {
        this.next = this.findMethods(Producer.class).findFirst().get();
        this.converters = new RecordConverters();
        this.registry = new RecordConverters.MappingMetaRegistry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Jsonb jsonb() {
        if (this.jsonb == null) {
            InputImpl inputImpl = this;
            synchronized (inputImpl) {
                if (this.jsonb == null) {
                    LightContainer container = ContainerFinder.Instance.get().find(this.plugin());
                    this.jsonb = container.findService(Jsonb.class);
                }
            }
        }
        return this.jsonb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RecordBuilderFactory recordBuilderFactory() {
        if (this.recordBuilderFactory == null) {
            InputImpl inputImpl = this;
            synchronized (inputImpl) {
                if (this.recordBuilderFactory == null) {
                    LightContainer container = ContainerFinder.Instance.get().find(this.plugin());
                    this.recordBuilderFactory = container.findService(RecordBuilderFactory.class);
                }
            }
        }
        return this.recordBuilderFactory;
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new SerializationReplacer(this.plugin(), this.rootName(), this.name(), this.serializeDelegate());
    }

    protected static class SerializationReplacer
    implements Serializable {
        protected String plugin;
        protected String component;
        protected String name;
        protected byte[] value;

        protected Object readResolve() throws ObjectStreamException {
            try {
                return new InputImpl(this.component, this.name, this.plugin, this.loadDelegate());
            }
            catch (IOException | ClassNotFoundException e) {
                InvalidObjectException invalidObjectException = new InvalidObjectException(e.getMessage());
                invalidObjectException.initCause(e);
                throw invalidObjectException;
            }
        }

        protected Serializable loadDelegate() throws IOException, ClassNotFoundException {
            try (EnhancedObjectInputStream ois = new EnhancedObjectInputStream(new ByteArrayInputStream(this.value), ContainerFinder.Instance.get().find(this.plugin).classloader());){
                Serializable serializable = (Serializable)Serializable.class.cast(ois.readObject());
                return serializable;
            }
        }

        public SerializationReplacer(String plugin, String component, String name, byte[] value) {
            this.plugin = plugin;
            this.component = component;
            this.name = name;
            this.value = value;
        }
    }
}

