/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.input;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import org.talend.sdk.component.runtime.input.InputImpl;

public class StreamingInputImpl
extends InputImpl {
    private RetryConfiguration retryConfiguration;
    private transient Thread shutdownHook;
    private final AtomicBoolean running = new AtomicBoolean();
    private transient Semaphore semaphore;

    public StreamingInputImpl(String rootName, String name, String plugin, Serializable instance, RetryConfiguration retryConfiguration) {
        super(rootName, name, plugin, instance);
        this.shutdownHook = new Thread(() -> this.running.compareAndSet(true, false), this.getClass().getName() + "_" + this.rootName() + "-" + this.name() + "_" + this.hashCode());
        this.retryConfiguration = retryConfiguration;
    }

    protected StreamingInputImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object readNext() {
        if (!this.running.get()) {
            return null;
        }
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        try {
            RetryStrategy strategy = this.retryConfiguration.getStrategy();
            int retries = this.retryConfiguration.getMaxRetries();
            while (this.running.get() && retries > 0) {
                Object next = super.readNext();
                if (next != null) {
                    strategy.reset();
                    Object object = next;
                    return object;
                }
                --retries;
                try {
                    long current;
                    long millis = strategy.nextPauseDuration();
                    if (millis < 0L) {
                        this.prepareStop();
                        continue;
                    }
                    if (millis <= 0L) continue;
                    if (millis < 1000L) {
                        Thread.sleep(millis);
                        continue;
                    }
                    for (long remaining = millis; this.running.get() && remaining > 0L; remaining -= current) {
                        current = Math.min(remaining, 250L);
                        Thread.sleep(current);
                    }
                }
                catch (InterruptedException e) {
                    this.prepareStop();
                }
            }
            Object var3_4 = null;
            return var3_4;
        }
        finally {
            this.semaphore.release();
        }
    }

    @Override
    protected void init() {
        super.init();
        this.semaphore = new Semaphore(1);
    }

    @Override
    public void start() {
        super.start();
        this.running.compareAndSet(false, true);
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    @Override
    public void stop() {
        this.prepareStop();
        super.stop();
    }

    private void prepareStop() {
        this.running.compareAndSet(true, false);
        if (this.shutdownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    protected Object writeReplace() throws ObjectStreamException {
        return new StreamSerializationReplacer(this.plugin(), this.rootName(), this.name(), this.serializeDelegate(), this.retryConfiguration);
    }

    public static class RetryConfiguration
    implements Serializable {
        private int maxRetries;
        private RetryStrategy strategy;

        public int getMaxRetries() {
            return this.maxRetries;
        }

        public RetryStrategy getStrategy() {
            return this.strategy;
        }

        public void setMaxRetries(int maxRetries) {
            this.maxRetries = maxRetries;
        }

        public void setStrategy(RetryStrategy strategy) {
            this.strategy = strategy;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RetryConfiguration)) {
                return false;
            }
            RetryConfiguration other = (RetryConfiguration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getMaxRetries() != other.getMaxRetries()) {
                return false;
            }
            RetryStrategy this$strategy = this.getStrategy();
            RetryStrategy other$strategy = other.getStrategy();
            return !(this$strategy == null ? other$strategy != null : !this$strategy.equals(other$strategy));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RetryConfiguration;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getMaxRetries();
            RetryStrategy $strategy = this.getStrategy();
            result = result * 59 + ($strategy == null ? 43 : $strategy.hashCode());
            return result;
        }

        public String toString() {
            return "StreamingInputImpl.RetryConfiguration(maxRetries=" + this.getMaxRetries() + ", strategy=" + this.getStrategy() + ")";
        }

        public RetryConfiguration() {
        }

        public RetryConfiguration(int maxRetries, RetryStrategy strategy) {
            this.maxRetries = maxRetries;
            this.strategy = strategy;
        }

        public static class ExponentialBackoff
        implements Serializable,
        RetryStrategy {
            private double exponent;
            private double randomizationFactor;
            private long max;
            private long initialBackOff;
            private int iteration;

            @Override
            public long nextPauseDuration() {
                double currentIntervalMillis = Math.min((double)this.initialBackOff * Math.pow(this.exponent, this.iteration), (double)this.max);
                double randomOffset = (Math.random() * 2.0 - 1.0) * this.randomizationFactor * currentIntervalMillis;
                long nextBackoffMillis = Math.min(this.max, Math.round(currentIntervalMillis + randomOffset));
                ++this.iteration;
                return nextBackoffMillis;
            }

            @Override
            public void reset() {
                this.iteration = 0;
            }

            public double getExponent() {
                return this.exponent;
            }

            public double getRandomizationFactor() {
                return this.randomizationFactor;
            }

            public long getMax() {
                return this.max;
            }

            public long getInitialBackOff() {
                return this.initialBackOff;
            }

            public int getIteration() {
                return this.iteration;
            }

            public void setExponent(double exponent) {
                this.exponent = exponent;
            }

            public void setRandomizationFactor(double randomizationFactor) {
                this.randomizationFactor = randomizationFactor;
            }

            public void setMax(long max) {
                this.max = max;
            }

            public void setInitialBackOff(long initialBackOff) {
                this.initialBackOff = initialBackOff;
            }

            public void setIteration(int iteration) {
                this.iteration = iteration;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ExponentialBackoff)) {
                    return false;
                }
                ExponentialBackoff other = (ExponentialBackoff)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (Double.compare(this.getExponent(), other.getExponent()) != 0) {
                    return false;
                }
                if (Double.compare(this.getRandomizationFactor(), other.getRandomizationFactor()) != 0) {
                    return false;
                }
                if (this.getMax() != other.getMax()) {
                    return false;
                }
                if (this.getInitialBackOff() != other.getInitialBackOff()) {
                    return false;
                }
                return this.getIteration() == other.getIteration();
            }

            protected boolean canEqual(Object other) {
                return other instanceof ExponentialBackoff;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                long $exponent = Double.doubleToLongBits(this.getExponent());
                result = result * 59 + (int)($exponent >>> 32 ^ $exponent);
                long $randomizationFactor = Double.doubleToLongBits(this.getRandomizationFactor());
                result = result * 59 + (int)($randomizationFactor >>> 32 ^ $randomizationFactor);
                long $max = this.getMax();
                result = result * 59 + (int)($max >>> 32 ^ $max);
                long $initialBackOff = this.getInitialBackOff();
                result = result * 59 + (int)($initialBackOff >>> 32 ^ $initialBackOff);
                result = result * 59 + this.getIteration();
                return result;
            }

            public String toString() {
                return "StreamingInputImpl.RetryConfiguration.ExponentialBackoff(exponent=" + this.getExponent() + ", randomizationFactor=" + this.getRandomizationFactor() + ", max=" + this.getMax() + ", initialBackOff=" + this.getInitialBackOff() + ", iteration=" + this.getIteration() + ")";
            }

            public ExponentialBackoff() {
            }

            public ExponentialBackoff(double exponent, double randomizationFactor, long max, long initialBackOff, int iteration) {
                this.exponent = exponent;
                this.randomizationFactor = randomizationFactor;
                this.max = max;
                this.initialBackOff = initialBackOff;
                this.iteration = iteration;
            }
        }

        public static class Constant
        implements Serializable,
        RetryStrategy {
            private long timeout;

            @Override
            public long nextPauseDuration() {
                return this.timeout;
            }

            @Override
            public void reset() {
            }

            public long getTimeout() {
                return this.timeout;
            }

            public void setTimeout(long timeout) {
                this.timeout = timeout;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Constant)) {
                    return false;
                }
                Constant other = (Constant)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                return this.getTimeout() == other.getTimeout();
            }

            protected boolean canEqual(Object other) {
                return other instanceof Constant;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                long $timeout = this.getTimeout();
                result = result * 59 + (int)($timeout >>> 32 ^ $timeout);
                return result;
            }

            public String toString() {
                return "StreamingInputImpl.RetryConfiguration.Constant(timeout=" + this.getTimeout() + ")";
            }

            public Constant() {
            }

            public Constant(long timeout) {
                this.timeout = timeout;
            }
        }
    }

    public static interface RetryStrategy {
        public long nextPauseDuration();

        public void reset();
    }

    private static class StreamSerializationReplacer
    extends InputImpl.SerializationReplacer {
        private final RetryConfiguration retryConfiguration;

        StreamSerializationReplacer(String plugin, String component, String name, byte[] value, RetryConfiguration retryConfiguration) {
            super(plugin, component, name, value);
            this.retryConfiguration = retryConfiguration;
        }

        @Override
        protected Object readResolve() throws ObjectStreamException {
            try {
                return new StreamingInputImpl(this.component, this.name, this.plugin, this.loadDelegate(), this.retryConfiguration);
            }
            catch (IOException | ClassNotFoundException e) {
                InvalidObjectException invalidObjectException = new InvalidObjectException(e.getMessage());
                invalidObjectException.initCause(e);
                throw invalidObjectException;
            }
        }
    }
}

