/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.base;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.talend.sdk.component.runtime.base.Lifecycle;
import org.talend.sdk.component.runtime.base.Named;
import org.talend.sdk.component.runtime.base.Serializer;
import org.talend.sdk.component.runtime.base.lang.exception.InvocationExceptionWrapper;
import org.talend.sdk.component.runtime.serialization.ContainerFinder;

public class LifecycleImpl
extends Named
implements Lifecycle {
    protected Object delegate;
    private transient ClassLoader loader;

    public LifecycleImpl(Object delegate, String rootName, String name, String plugin) {
        super(rootName, name, plugin);
        this.delegate = delegate;
    }

    protected LifecycleImpl() {
    }

    @Override
    public void start() {
        this.invoke(PostConstruct.class);
    }

    @Override
    public void stop() {
        this.invoke(PreDestroy.class);
    }

    private void invoke(Class<? extends Annotation> marker) {
        this.findMethods(marker).forEach(x$0 -> this.doInvoke((Method)x$0, new Object[0]));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LifecycleImpl lifecycle = (LifecycleImpl)LifecycleImpl.class.cast(o);
        return Objects.equals(this.delegate, lifecycle.delegate) && Objects.equals(this.loader, lifecycle.loader);
    }

    public int hashCode() {
        return Objects.hash(this.delegate, this.loader);
    }

    protected Object doInvoke(Method m, Object ... args) {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(this.findLoader());
        try {
            Object object = m.invoke(this.delegate, args);
            return object;
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw InvocationExceptionWrapper.toRuntimeException(e);
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Stream<Method> findMethods(Class<? extends Annotation> marker) {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(this.findLoader());
        try {
            Stream<Method> stream = Stream.of(this.delegate.getClass().getMethods()).filter(m -> m.isAnnotationPresent(marker)).peek(m -> {
                if (!m.isAccessible()) {
                    m.setAccessible(true);
                }
            });
            return stream;
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    protected byte[] serializeDelegate() {
        return Serializer.toBytes(this.delegate);
    }

    private ClassLoader findLoader() {
        if (this.loader == null) {
            try {
                this.loader = ContainerFinder.Instance.get().find(this.plugin()).classloader();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            if (this.loader == null) {
                this.loader = Thread.currentThread().getContextClassLoader();
            }
        }
        return this.loader;
    }
}

