/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.visitor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.talend.sdk.component.api.component.AfterVariables;
import org.talend.sdk.component.api.input.Assessor;
import org.talend.sdk.component.api.input.Emitter;
import org.talend.sdk.component.api.input.PartitionMapper;
import org.talend.sdk.component.api.input.PartitionSize;
import org.talend.sdk.component.api.input.Producer;
import org.talend.sdk.component.api.input.Split;
import org.talend.sdk.component.api.processor.AfterGroup;
import org.talend.sdk.component.api.processor.BeforeGroup;
import org.talend.sdk.component.api.processor.ElementListener;
import org.talend.sdk.component.api.processor.Output;
import org.talend.sdk.component.api.processor.OutputEmitter;
import org.talend.sdk.component.api.processor.Processor;
import org.talend.sdk.component.api.standalone.DriverRunner;
import org.talend.sdk.component.api.standalone.RunAtDriver;
import org.talend.sdk.component.runtime.reflect.Parameters;
import org.talend.sdk.component.runtime.visitor.ModelListener;

public class ModelVisitor {
    public void visit(Class<?> type, ModelListener listener, boolean validate) {
        if (this.getSupportedComponentTypes().noneMatch(type::isAnnotationPresent)) {
            return;
        }
        if (this.getSupportedComponentTypes().filter(type::isAnnotationPresent).count() != 1L) {
            throw new IllegalArgumentException("You can't mix @Emitter, @PartitionMapper and @Processor on " + type);
        }
        if (type.isAnnotationPresent(PartitionMapper.class)) {
            if (validate) {
                this.validatePartitionMapper(type);
            }
            listener.onPartitionMapper(type, type.getAnnotation(PartitionMapper.class));
        } else if (type.isAnnotationPresent(Emitter.class)) {
            if (validate) {
                this.validateEmitter(type);
            }
            listener.onEmitter(type, type.getAnnotation(Emitter.class));
        } else if (type.isAnnotationPresent(Processor.class)) {
            if (validate) {
                this.validateProcessor(type);
            }
            listener.onProcessor(type, type.getAnnotation(Processor.class));
        } else if (type.isAnnotationPresent(DriverRunner.class)) {
            if (validate) {
                this.validateDriverRunner(type);
            }
            listener.onDriverRunner(type, type.getAnnotation(DriverRunner.class));
        }
    }

    private void validatePartitionMapper(Class<?> type) {
        boolean infinite = type.getAnnotation(PartitionMapper.class).infinite();
        long count = Stream.of(type.getMethods()).filter(m -> this.getPartitionMapperMethods(infinite).anyMatch(m::isAnnotationPresent)).flatMap(m -> this.getPartitionMapperMethods(infinite).filter(m::isAnnotationPresent)).distinct().count();
        if (count != (long)(infinite ? 2 : 3)) {
            throw new IllegalArgumentException(type + " partition mapper must have exactly one @Assessor (if not infinite), one @Split and one @Emitter methods");
        }
        if (!infinite) {
            Stream.of(type.getMethods()).filter(m -> m.isAnnotationPresent(Assessor.class)).forEach(m -> {
                if (m.getParameterCount() > 0) {
                    throw new IllegalArgumentException(m + " must not have any parameter");
                }
            });
        }
        Stream.of(type.getMethods()).filter(m -> m.isAnnotationPresent(Split.class)).forEach(m -> {
            Type arg;
            if (Stream.of(m.getParameters()).anyMatch(p -> !p.isAnnotationPresent(PartitionSize.class) || p.getType() != Long.TYPE && p.getType() != Integer.TYPE)) {
                throw new IllegalArgumentException(m + " must not have any parameter without @PartitionSize");
            }
            Type splitReturnType = m.getGenericReturnType();
            if (!ParameterizedType.class.isInstance(splitReturnType)) {
                throw new IllegalArgumentException(m + " must return a Collection<" + type.getName() + ">");
            }
            ParameterizedType splitPt = (ParameterizedType)ParameterizedType.class.cast(splitReturnType);
            if (!Class.class.isInstance(splitPt.getRawType()) || !Collection.class.isAssignableFrom((Class)Class.class.cast(splitPt.getRawType()))) {
                throw new IllegalArgumentException(m + " must return a List of partition mapper, found: " + splitPt);
            }
            Type type2 = arg = splitPt.getActualTypeArguments().length != 1 ? null : splitPt.getActualTypeArguments()[0];
            if (!Class.class.isInstance(arg) || !type.isAssignableFrom((Class)Class.class.cast(arg))) {
                throw new IllegalArgumentException(m + " must return a Collection<" + type.getName() + "> but found: " + arg);
            }
        });
        Stream.of(type.getMethods()).filter(m -> m.isAnnotationPresent(Emitter.class)).forEach(m -> {
            if (m.getParameterCount() > 0) {
                throw new IllegalArgumentException(m + " must not have any parameter");
            }
        });
        this.validateAfterVariableContainer(type);
    }

    private void validateEmitter(Class<?> input) {
        List producers = Stream.of(input.getMethods()).filter(m -> m.isAnnotationPresent(Producer.class)).collect(Collectors.toList());
        if (producers.size() != 1) {
            throw new IllegalArgumentException(input + " must have a single @Producer method");
        }
        if (((Method)producers.get(0)).getParameterCount() > 0) {
            throw new IllegalArgumentException(producers.get(0) + " must not have any parameter");
        }
        this.validateAfterVariableContainer(input);
    }

    private void validateDriverRunner(Class<?> standalone) {
        List driverRunners = Stream.of(standalone.getMethods()).filter(m -> m.isAnnotationPresent(RunAtDriver.class)).collect(Collectors.toList());
        if (driverRunners.size() != 1) {
            throw new IllegalArgumentException(standalone + " must have a single @RunAtDriver method");
        }
        if (((Method)driverRunners.get(0)).getParameterCount() > 0) {
            throw new IllegalArgumentException(driverRunners.get(0) + " must not have any parameter");
        }
        this.validateAfterVariableContainer(standalone);
    }

    private void validateProcessor(Class<?> input) {
        List<Method> afterGroups = Stream.of(input.getMethods()).filter(m -> m.isAnnotationPresent(AfterGroup.class)).collect(Collectors.toList());
        afterGroups.forEach(m -> {
            List invalidParams = Stream.of(m.getParameters()).peek(p -> {
                if (p.isAnnotationPresent(Output.class) && !this.validOutputParam((Parameter)p)) {
                    throw new IllegalArgumentException("@Output parameter must be of type OutputEmitter");
                }
            }).filter(p -> !p.isAnnotationPresent(Output.class)).filter(p -> !Parameters.isGroupBuffer(p.getParameterizedType())).collect(Collectors.toList());
            if (!invalidParams.isEmpty()) {
                throw new IllegalArgumentException("Parameter of AfterGroup method need to be annotated with Output");
            }
        });
        List producers = Stream.of(input.getMethods()).filter(m -> m.isAnnotationPresent(ElementListener.class)).collect(Collectors.toList());
        if (producers.size() > 1) {
            throw new IllegalArgumentException(input + " must have a single @ElementListener method");
        }
        if (producers.isEmpty() && afterGroups.stream().noneMatch(m -> Stream.of(m.getGenericParameterTypes()).anyMatch(Parameters::isGroupBuffer))) {
            throw new IllegalArgumentException(input + " must have a single @ElementListener method or pass records as a Collection<Record|JsonObject> to its @AfterGroup method");
        }
        if (!producers.isEmpty() && Stream.of(((Method)producers.get(0)).getParameters()).peek(p -> {
            if (p.isAnnotationPresent(Output.class) && !this.validOutputParam((Parameter)p)) {
                throw new IllegalArgumentException("@Output parameter must be of type OutputEmitter");
            }
        }).filter(p -> !p.isAnnotationPresent(Output.class)).count() < 1L) {
            throw new IllegalArgumentException(input + " doesn't have the input parameter on its producer method");
        }
        Stream.of(input.getMethods()).filter(m -> m.isAnnotationPresent(BeforeGroup.class)).forEach(m -> {
            if (m.getParameterCount() > 0) {
                throw new IllegalArgumentException(m + " must not have any parameter");
            }
        });
        this.validateAfterVariableContainer(input);
    }

    private boolean validOutputParam(Parameter p) {
        if (!ParameterizedType.class.isInstance(p.getParameterizedType())) {
            return false;
        }
        ParameterizedType pt = (ParameterizedType)ParameterizedType.class.cast(p.getParameterizedType());
        return OutputEmitter.class == pt.getRawType();
    }

    private Stream<Class<? extends Annotation>> getPartitionMapperMethods(boolean infinite) {
        return infinite ? Stream.of(Split.class, Emitter.class) : Stream.of(Assessor.class, Split.class, Emitter.class);
    }

    private Stream<Class<? extends Annotation>> getSupportedComponentTypes() {
        return Stream.of(Emitter.class, PartitionMapper.class, Processor.class, DriverRunner.class);
    }

    private void validateAfterVariableContainer(Class<?> type) {
        List markedMethods = Stream.of(type.getMethods()).filter(m -> m.isAnnotationPresent(AfterVariables.AfterVariableContainer.class)).collect(Collectors.toList());
        if (markedMethods.size() > 1) {
            String methods2 = markedMethods.stream().map(Method::toGenericString).collect(Collectors.joining(","));
            throw new IllegalArgumentException("The methods can't have more than 1 after variable container. Current marked methods: " + methods2);
        }
        Optional.of(markedMethods.stream().filter(m -> m.getParameterCount() != 0).map(Method::toGenericString).collect(Collectors.joining(","))).filter(str -> !str.isEmpty()).ifPresent(str -> {
            throw new IllegalArgumentException("The method is annotated with " + AfterVariables.AfterVariableContainer.class.getCanonicalName() + "'" + str + "' should have parameters.");
        });
        Optional.of(markedMethods.stream().filter(m -> !ModelVisitor.isValidAfterVariableContainer(m.getGenericReturnType())).map(Method::toGenericString).collect(Collectors.joining(","))).filter(it -> !it.isEmpty()).ifPresent(methods -> {
            throw new IllegalArgumentException("The method '" + methods + "' has wrong return type. It should be Map<String, Object>.");
        });
    }

    private static boolean isValidAfterVariableContainer(Type type) {
        if (!(type instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType paramType = (ParameterizedType)type;
        if (!(paramType.getRawType() instanceof Class) || paramType.getActualTypeArguments().length != 2) {
            return false;
        }
        Class containerType = (Class)paramType.getRawType();
        return Map.class.isAssignableFrom(containerType) && paramType.getActualTypeArguments()[0].equals(String.class) && paramType.getActualTypeArguments()[1].equals(Object.class);
    }
}

