/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.serialization;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EnhancedObjectInputStream
extends ObjectInputStream {
    private final ClassLoader loader;
    private final Predicate<String> classesWhitelist;

    protected EnhancedObjectInputStream(InputStream in, ClassLoader loader, Predicate<String> filter) throws IOException {
        super(in);
        this.loader = loader;
        this.classesWhitelist = filter;
    }

    public EnhancedObjectInputStream(InputStream in, ClassLoader loader) throws IOException {
        this(in, loader, Defaults.SECURITY_FILTER_WHITELIST);
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws ClassNotFoundException {
        String name = desc.getName();
        if (name.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (name.equals("byte")) {
            return Byte.TYPE;
        }
        if (name.equals("char")) {
            return Character.TYPE;
        }
        if (name.equals("short")) {
            return Short.TYPE;
        }
        if (name.equals("int")) {
            return Integer.TYPE;
        }
        if (name.equals("long")) {
            return Long.TYPE;
        }
        if (name.equals("float")) {
            return Float.TYPE;
        }
        if (name.equals("double")) {
            return Double.TYPE;
        }
        this.doSecurityCheck(name);
        try {
            return Class.forName(name, false, this.loader);
        }
        catch (ClassNotFoundException e) {
            return Class.forName(name, false, this.getClass().getClassLoader());
        }
    }

    @Override
    protected Class<?> resolveProxyClass(String[] interfaces) throws ClassNotFoundException {
        Class[] interfaceTypes = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            this.doSecurityCheck(interfaces[i]);
            interfaceTypes[i] = Class.forName(interfaces[i], false, this.loader);
        }
        try {
            return Proxy.getProxyClass(this.loader, interfaceTypes);
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException(null, e);
        }
    }

    private void doSecurityCheck(String name) {
        if (!this.classesWhitelist.test(this.processForWhiteListing(name))) {
            throw new SecurityException("'" + name + "' not supported, add it in -Dtalend.component.runtme.serialization.java.inputstream.whitelist if needed");
        }
    }

    private String processForWhiteListing(String name) {
        if (name.startsWith("[L") && name.endsWith(";")) {
            return name.substring(2, name.length() - 1);
        }
        return name;
    }

    static class Defaults {
        static final Predicate<String> SECURITY_FILTER_WHITELIST = Optional.ofNullable(System.getProperty("talend.component.runtime.serialization.java.inputstream.whitelist")).map(s -> Stream.of(s.split(",")).map(String::trim).filter(it -> !it.isEmpty()).collect(Collectors.toList())).map(l -> name -> l.stream().anyMatch(name::startsWith)).orElseGet(() -> name -> true);

        private Defaults() {
        }
    }
}

