/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.reflect;

import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Defaults {
    private static final Logger log = LoggerFactory.getLogger(Defaults.class);
    private static final Handler HANDLER;

    public static boolean isDefaultAndShouldHandle(Method method) {
        return method.isDefault();
    }

    public static Object handleDefault(Class<?> declaringClass, Method method, Object proxy, Object[] args) throws Throwable {
        return HANDLER.handle(declaringClass, method, proxy, args);
    }

    private static Method findPrivateLookup() {
        try {
            return MethodHandles.class.getMethod("privateLookupIn", Class.class, MethodHandles.Lookup.class);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static Constructor<MethodHandles.Lookup> findLookupConstructor() {
        try {
            Constructor<MethodHandles.Lookup> constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            return constructor;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private Defaults() {
    }

    static {
        String version = System.getProperty("java.version", "1.8");
        Constructor<MethodHandles.Lookup> constructor = Defaults.findLookupConstructor();
        if (version.startsWith("1.8.") || version.startsWith("8.")) {
            HANDLER = (clazz, method, proxy, args) -> ((MethodHandles.Lookup)constructor.newInstance(clazz, 2)).unreflectSpecial(method, clazz).bindTo(proxy).invokeWithArguments(args);
        } else {
            Method privateLookup = Defaults.findPrivateLookup();
            int mode = 18;
            HANDLER = (clazz, method, proxy, args) -> ((MethodHandles.Lookup)MethodHandles.Lookup.class.cast(privateLookup.invoke(null, clazz, constructor.newInstance(clazz, 18)))).unreflectSpecial(method, clazz).bindTo(proxy).invokeWithArguments(args);
        }
    }

    private static interface Handler {
        public Object handle(Class<?> var1, Method var2, Object var3, Object[] var4) throws Throwable;
    }
}

