/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.serialization;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;

public class EnhancedObjectInputStream
extends ObjectInputStream {
    private final ClassLoader loader;

    public EnhancedObjectInputStream(InputStream in, ClassLoader loader) throws IOException {
        super(in);
        this.loader = loader;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        String name = desc.getName();
        try {
            return Class.forName(name, false, this.loader);
        }
        catch (ClassNotFoundException e) {
            if (name.equals("boolean")) {
                return Boolean.TYPE;
            }
            if (name.equals("byte")) {
                return Byte.TYPE;
            }
            if (name.equals("char")) {
                return Character.TYPE;
            }
            if (name.equals("short")) {
                return Short.TYPE;
            }
            if (name.equals("int")) {
                return Integer.TYPE;
            }
            if (name.equals("long")) {
                return Long.TYPE;
            }
            if (name.equals("float")) {
                return Float.TYPE;
            }
            if (name.equals("double")) {
                return Double.TYPE;
            }
            return Class.forName(name, false, this.getClass().getClassLoader());
        }
    }

    @Override
    protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        Class[] interfaceTypes = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            interfaceTypes[i] = Class.forName(interfaces[i], false, this.loader);
        }
        try {
            return Proxy.getProxyClass(this.loader, interfaceTypes);
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException(null, e);
        }
    }
}

