/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.input;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Method;
import org.talend.sdk.component.api.input.Producer;
import org.talend.sdk.component.runtime.base.Delegated;
import org.talend.sdk.component.runtime.base.LifecycleImpl;
import org.talend.sdk.component.runtime.input.Input;
import org.talend.sdk.component.runtime.serialization.ContainerFinder;
import org.talend.sdk.component.runtime.serialization.EnhancedObjectInputStream;

public class InputImpl
extends LifecycleImpl
implements Input,
Delegated {
    private transient Method next;

    public InputImpl(String rootName, String name, String plugin, Serializable instance) {
        super(instance, rootName, name, plugin);
    }

    protected InputImpl() {
    }

    @Override
    public Object next() {
        if (this.next == null) {
            this.next = this.findMethods(Producer.class).findFirst().get();
        }
        return this.doInvoke(this.next, new Object[0]);
    }

    @Override
    public Object getDelegate() {
        return this.delegate;
    }

    Object writeReplace() throws ObjectStreamException {
        return new SerializationReplacer(this.plugin(), this.rootName(), this.name(), this.serializeDelegate());
    }

    private static class SerializationReplacer
    implements Serializable {
        private final String plugin;
        private final String component;
        private final String name;
        private final byte[] value;

        Object readResolve() throws ObjectStreamException {
            try {
                return new InputImpl(this.component, this.name, this.plugin, this.loadDelegate());
            }
            catch (IOException | ClassNotFoundException e) {
                throw new InvalidObjectException(e.getMessage());
            }
        }

        private Serializable loadDelegate() throws IOException, ClassNotFoundException {
            try (EnhancedObjectInputStream ois = new EnhancedObjectInputStream(new ByteArrayInputStream(this.value), ContainerFinder.Instance.get().find(this.plugin).classloader());){
                Serializable serializable = (Serializable)Serializable.class.cast(ois.readObject());
                return serializable;
            }
        }

        public SerializationReplacer(String plugin, String component, String name, byte[] value) {
            this.plugin = plugin;
            this.component = component;
            this.name = name;
            this.value = value;
        }
    }
}

