/*
 * Decompiled with CFR 0.152.
 */
package org.talend.__shade__.io.netty.handler.codec.rtsp;

import org.talend.__shade__.io.netty.buffer.ByteBuf;
import org.talend.__shade__.io.netty.buffer.ByteBufUtil;
import org.talend.__shade__.io.netty.handler.codec.UnsupportedMessageTypeException;
import org.talend.__shade__.io.netty.handler.codec.http.HttpMessage;
import org.talend.__shade__.io.netty.handler.codec.http.HttpObjectEncoder;
import org.talend.__shade__.io.netty.handler.codec.http.HttpRequest;
import org.talend.__shade__.io.netty.handler.codec.http.HttpResponse;
import org.talend.__shade__.io.netty.util.CharsetUtil;

public class RtspEncoder
extends HttpObjectEncoder<HttpMessage> {
    private static final int CRLF_SHORT = 3338;

    @Override
    public boolean acceptOutboundMessage(Object msg) throws Exception {
        return super.acceptOutboundMessage(msg) && (msg instanceof HttpRequest || msg instanceof HttpResponse);
    }

    @Override
    protected void encodeInitialLine(ByteBuf buf, HttpMessage message) throws Exception {
        if (message instanceof HttpRequest) {
            HttpRequest request = (HttpRequest)message;
            ByteBufUtil.copy(request.method().asciiName(), buf);
            buf.writeByte(32);
            buf.writeCharSequence(request.uri(), CharsetUtil.UTF_8);
            buf.writeByte(32);
            buf.writeCharSequence(request.protocolVersion().toString(), CharsetUtil.US_ASCII);
            ByteBufUtil.writeShortBE(buf, 3338);
        } else if (message instanceof HttpResponse) {
            HttpResponse response = (HttpResponse)message;
            buf.writeCharSequence(response.protocolVersion().toString(), CharsetUtil.US_ASCII);
            buf.writeByte(32);
            ByteBufUtil.copy(response.status().codeAsText(), buf);
            buf.writeByte(32);
            buf.writeCharSequence(response.status().reasonPhrase(), CharsetUtil.US_ASCII);
            ByteBufUtil.writeShortBE(buf, 3338);
        } else {
            throw new UnsupportedMessageTypeException(message, HttpRequest.class, HttpResponse.class);
        }
    }
}

