/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.junit.http.internal.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.__shade__.io.netty.handler.codec.http.FullHttpRequest;
import org.talend.sdk.component.junit.http.api.HttpApiHandler;
import org.talend.sdk.component.junit.http.api.Response;
import org.talend.sdk.component.junit.http.internal.impl.DefaultResponseLocator;
import org.talend.sdk.component.junit.http.internal.impl.PassthroughHandler;

public class DefaultResponseLocatorCapturingHandler
extends PassthroughHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultResponseLocatorCapturingHandler.class);

    public DefaultResponseLocatorCapturingHandler(HttpApiHandler api) {
        super(api);
    }

    @Override
    protected void beforeResponse(String requestUri, FullHttpRequest request, Response resp, Map<String, List<String>> responseHeaderFields) {
        DefaultResponseLocator.RequestModel requestModel = new DefaultResponseLocator.RequestModel();
        requestModel.setMethod(request.method().name().toString());
        requestModel.setUri(requestUri);
        requestModel.setHeaders(this.filterHeaders(request.headers().entries().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))));
        DefaultResponseLocator.Model model = new DefaultResponseLocator.Model();
        model.setRequest(requestModel);
        DefaultResponseLocator.ResponseModel responseModel = new DefaultResponseLocator.ResponseModel();
        responseModel.setStatus(resp.status());
        responseModel.setHeaders(this.filterHeaders(resp.headers()));
        if (resp.payload() != null) {
            if (responseHeaderFields.getOrDefault("Content-Encoding", Collections.emptyList()).stream().anyMatch(it -> it.contains("gzip"))) {
                responseModel.setPayload(new String(this.degzip(resp.payload()), StandardCharsets.UTF_8));
            } else {
                responseModel.setPayload(new String(resp.payload(), StandardCharsets.UTF_8));
            }
        }
        model.setResponse(responseModel);
        if (DefaultResponseLocator.class.isInstance(this.api.getResponseLocator())) {
            ((DefaultResponseLocator)DefaultResponseLocator.class.cast(this.api.getResponseLocator())).addModel(model);
        }
    }

    private byte[] degzip(byte[] payloadBytes) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] bytes = new byte[8192];
        try (GZIPInputStream stream = new GZIPInputStream(new ByteArrayInputStream(payloadBytes));){
            int read;
            while ((read = ((InputStream)stream).read(bytes)) >= 0) {
                if (read == 0) continue;
                out.write(bytes, 0, read);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return out.toByteArray();
    }

    private Map<String, String> filterHeaders(Map<String, String> headers) {
        return headers.entrySet().stream().filter(h -> !this.api.getHeaderFilter().test((String)h.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

