/*
 * Decompiled with CFR 0.152.
 */
package org.talend.__shade__.org.apache.johnzon.core;

import java.io.Serializable;
import java.util.Map;
import org.talend.__shade__.javax.json.JsonMergePatch;
import org.talend.__shade__.javax.json.JsonObject;
import org.talend.__shade__.javax.json.JsonValue;
import org.talend.__shade__.org.apache.johnzon.core.BufferStrategy;
import org.talend.__shade__.org.apache.johnzon.core.JsonObjectBuilderImpl;
import org.talend.__shade__.org.apache.johnzon.core.JsonProviderImpl;
import org.talend.__shade__.org.apache.johnzon.core.RejectDuplicateKeysMode;

public class JsonMergePatchImpl
implements JsonMergePatch,
Serializable {
    private JsonValue patch;
    private BufferStrategy.BufferProvider<char[]> bufferProvider;
    private JsonProviderImpl provider;

    public JsonMergePatchImpl(JsonValue patch, BufferStrategy.BufferProvider<char[]> bufferProvider, JsonProviderImpl provider) {
        this.patch = patch;
        this.bufferProvider = bufferProvider;
        this.provider = provider;
    }

    @Override
    public JsonValue apply(JsonValue valueToApplyPatchOn) {
        return this.applyPatch(valueToApplyPatchOn, this.patch);
    }

    private JsonValue applyPatch(JsonValue valueToApplyPatchOn, JsonValue patch) {
        if (patch == null) {
            return JsonValue.NULL;
        }
        if (patch instanceof JsonObject && valueToApplyPatchOn instanceof JsonObject) {
            JsonObject patchObject = patch.asJsonObject();
            return this.applyJsonObjectPatch(valueToApplyPatchOn.asJsonObject(), patchObject);
        }
        return patch;
    }

    private JsonValue applyJsonObjectPatch(JsonObject jsonObject, JsonObject patch) {
        JsonObjectBuilderImpl builder = new JsonObjectBuilderImpl(jsonObject, this.bufferProvider, RejectDuplicateKeysMode.DEFAULT, this.provider);
        for (Map.Entry patchAttrib : patch.entrySet()) {
            String attribName = (String)patchAttrib.getKey();
            if (((JsonValue)patchAttrib.getValue()).equals(JsonValue.NULL)) {
                builder.remove(attribName);
                continue;
            }
            JsonValue originalAttrib = (JsonValue)jsonObject.get(attribName);
            if (originalAttrib == null) {
                builder.add(attribName, (JsonValue)patchAttrib.getValue());
                continue;
            }
            builder.add(attribName, this.applyPatch(originalAttrib, (JsonValue)patchAttrib.getValue()));
        }
        return builder.build();
    }

    @Override
    public JsonValue toJsonValue() {
        return this.patch;
    }
}

