/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.junit.http.internal.impl;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.net.ssl.SSLEngine;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.__shade__.io.netty.buffer.ByteBuf;
import org.talend.__shade__.io.netty.buffer.Unpooled;
import org.talend.__shade__.io.netty.channel.ChannelHandler;
import org.talend.__shade__.io.netty.channel.ChannelHandlerContext;
import org.talend.__shade__.io.netty.channel.SimpleChannelInboundHandler;
import org.talend.__shade__.io.netty.handler.codec.http.DefaultFullHttpResponse;
import org.talend.__shade__.io.netty.handler.codec.http.FullHttpRequest;
import org.talend.__shade__.io.netty.handler.codec.http.HttpHeaderNames;
import org.talend.__shade__.io.netty.handler.codec.http.HttpHeaderValues;
import org.talend.__shade__.io.netty.handler.codec.http.HttpMethod;
import org.talend.__shade__.io.netty.handler.codec.http.HttpResponseStatus;
import org.talend.__shade__.io.netty.handler.codec.http.HttpUtil;
import org.talend.__shade__.io.netty.handler.codec.http.HttpVersion;
import org.talend.__shade__.io.netty.handler.ssl.SslHandler;
import org.talend.__shade__.io.netty.util.Attribute;
import org.talend.sdk.component.junit.http.api.HttpApiHandler;
import org.talend.sdk.component.junit.http.api.Response;
import org.talend.sdk.component.junit.http.internal.impl.Handlers;
import org.talend.sdk.component.junit.http.internal.impl.RequestImpl;
import org.talend.sdk.component.junit.http.internal.impl.ResponseImpl;

@ChannelHandler.Sharable
public class ServingProxyHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServingProxyHandler.class);
    private final HttpApiHandler api;

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest request) {
        if (!request.decoderResult().isSuccess()) {
            Handlers.sendError(ctx, HttpResponseStatus.BAD_REQUEST);
            return;
        }
        String payload = request.content().toString(StandardCharsets.UTF_8);
        this.api.getExecutor().execute(() -> {
            Map<String, String> headers = StreamSupport.stream(Spliterators.spliteratorUnknownSize(request.headers().iteratorAsString(), 1024), false).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            Attribute<String> baseAttr = ctx.channel().attr(Handlers.BASE);
            Optional<Response> matching = this.api.getResponseLocator().findMatching(new RequestImpl((baseAttr == null || baseAttr.get() == null ? "" : baseAttr.get()) + request.uri(), request.method().name().toString(), payload, headers), this.api.getHeaderFilter());
            if (!matching.isPresent()) {
                if (HttpMethod.CONNECT.name().equalsIgnoreCase(request.method().name())) {
                    HashMap<String, String> responseHeaders = new HashMap<String, String>();
                    responseHeaders.put(HttpHeaderNames.CONNECTION.toString(), HttpHeaderValues.KEEP_ALIVE.toString());
                    responseHeaders.put(HttpHeaderNames.CONTENT_LENGTH.toString(), "0");
                    matching = Optional.of(new ResponseImpl(responseHeaders, HttpResponseStatus.OK.code(), Unpooled.EMPTY_BUFFER.array()));
                    if (this.api.getSslContext() != null) {
                        SSLEngine sslEngine = this.api.getSslContext().createSSLEngine();
                        sslEngine.setUseClientMode(false);
                        ctx.channel().pipeline().addFirst("ssl", (ChannelHandler)new SslHandler(sslEngine, true));
                        String uri = request.uri();
                        String[] parts = uri.split(":");
                        ctx.channel().attr(Handlers.BASE).set("https://" + parts[0] + (parts.length > 1 && !"443".equals(parts[1]) ? ":" + parts[1] : ""));
                    }
                } else {
                    Handlers.sendError(ctx, new HttpResponseStatus(400, "You are in proxy mode. No response was found for the simulated request. Please ensure to capture it for next executions. " + request.method().name() + " " + request.uri()));
                    return;
                }
            }
            Response resp = matching.get();
            ByteBuf bytes = Optional.ofNullable(resp.payload()).map(Unpooled::copiedBuffer).orElse(Unpooled.EMPTY_BUFFER);
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf(resp.status()), bytes);
            HttpUtil.setContentLength(response, bytes.array().length);
            if (!this.api.isSkipProxyHeaders()) {
                response.headers().set("X-Talend-Proxy-JUnit", (Object)"true");
            }
            Optional.ofNullable(resp.headers()).ifPresent(h -> h.forEach((k, v) -> response.headers().set((String)k, v)));
            ctx.writeAndFlush(response);
        });
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        log.error(cause.getMessage(), cause);
        Handlers.closeOnFlush(ctx.channel());
    }

    @Generated
    public ServingProxyHandler(HttpApiHandler api) {
        this.api = api;
    }
}

