/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.junit.http.api;

import java.security.cert.CertificateException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.Predicate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.__shade__.io.netty.handler.ssl.IdentityCipherSuiteFilter;
import org.talend.__shade__.io.netty.handler.ssl.JdkSslContext;
import org.talend.__shade__.io.netty.handler.ssl.SslContext;
import org.talend.__shade__.io.netty.handler.ssl.SslProvider;
import org.talend.__shade__.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import org.talend.__shade__.io.netty.handler.ssl.util.SelfSignedCertificate;
import org.talend.sdk.component.junit.http.api.ResponseLocator;
import org.talend.sdk.component.junit.http.internal.impl.DefaultHeaderFilter;
import org.talend.sdk.component.junit.http.internal.impl.DefaultResponseLocator;

public class HttpApiHandler<T extends HttpApiHandler<?>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpApiHandler.class);
    private Executor executor = Executors.newCachedThreadPool();
    private boolean globalProxyConfiguration = true;
    private int port;
    private SSLContext sslContext;
    private ResponseLocator responseLocator = new DefaultResponseLocator("talend/testing/http/", null);
    private String logLevel = "DEBUG";
    private Predicate<String> headerFilter = new DefaultHeaderFilter();
    private boolean skipProxyHeaders;

    public T activeSsl() {
        if (this.sslContext == null) {
            try {
                SelfSignedCertificate certificate = new SelfSignedCertificate();
                SslContext nettyContext = SslContext.newServerContext(SslProvider.JDK, null, InsecureTrustManagerFactory.INSTANCE, certificate.certificate(), certificate.privateKey(), null, null, null, IdentityCipherSuiteFilter.INSTANCE, null, 0L, 0L);
                this.sslContext = ((JdkSslContext)JdkSslContext.class.cast(nettyContext)).context();
            }
            catch (CertificateException | SSLException e) {
                throw new IllegalStateException(e);
            }
        }
        return (T)this;
    }

    public T setHeaderFilter(Predicate<String> headerFilter) {
        this.headerFilter = headerFilter;
        return (T)this;
    }

    public T setExecutor(Executor executor) {
        this.executor = executor;
        return (T)this;
    }

    public T setGlobalProxyConfiguration(boolean globalProxyConfiguration) {
        this.globalProxyConfiguration = globalProxyConfiguration;
        return (T)this;
    }

    public T setPort(int port) {
        this.port = port;
        return (T)this;
    }

    public T setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return (T)this;
    }

    public T setResponseLocator(ResponseLocator responseLocator) {
        this.responseLocator = responseLocator;
        return (T)this;
    }

    public T setLogLevel(String logLevel) {
        this.logLevel = logLevel;
        return (T)this;
    }

    public T setSkipProxyHeaders(boolean skipProxyHeaders) {
        this.skipProxyHeaders = skipProxyHeaders;
        return (T)this;
    }

    @Generated
    public Executor getExecutor() {
        return this.executor;
    }

    @Generated
    public boolean isGlobalProxyConfiguration() {
        return this.globalProxyConfiguration;
    }

    @Generated
    public int getPort() {
        return this.port;
    }

    @Generated
    public SSLContext getSslContext() {
        return this.sslContext;
    }

    @Generated
    public ResponseLocator getResponseLocator() {
        return this.responseLocator;
    }

    @Generated
    public String getLogLevel() {
        return this.logLevel;
    }

    @Generated
    public Predicate<String> getHeaderFilter() {
        return this.headerFilter;
    }

    @Generated
    public boolean isSkipProxyHeaders() {
        return this.skipProxyHeaders;
    }
}

