/*
 * Decompiled with CFR 0.152.
 */
package org.talend.__shade__.org.apache.johnzon.jsonb;

import java.io.Closeable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.talend.__shade__.javax.json.JsonBuilderFactory;
import org.talend.__shade__.javax.json.JsonValue;
import org.talend.__shade__.javax.json.bind.Jsonb;
import org.talend.__shade__.javax.json.bind.JsonbBuilder;
import org.talend.__shade__.javax.json.bind.JsonbConfig;
import org.talend.__shade__.javax.json.bind.adapter.JsonbAdapter;
import org.talend.__shade__.javax.json.bind.config.PropertyNamingStrategy;
import org.talend.__shade__.javax.json.bind.config.PropertyVisibilityStrategy;
import org.talend.__shade__.javax.json.bind.serializer.JsonbDeserializer;
import org.talend.__shade__.javax.json.bind.serializer.JsonbSerializer;
import org.talend.__shade__.javax.json.spi.JsonProvider;
import org.talend.__shade__.javax.json.stream.JsonParserFactory;
import org.talend.__shade__.org.apache.johnzon.jsonb.DefaultPropertyVisibilityStrategy;
import org.talend.__shade__.org.apache.johnzon.jsonb.JohnzonJsonb;
import org.talend.__shade__.org.apache.johnzon.jsonb.JsonValueParserAdapter;
import org.talend.__shade__.org.apache.johnzon.jsonb.JsonbAccessMode;
import org.talend.__shade__.org.apache.johnzon.jsonb.PropertyNamingStrategyFactory;
import org.talend.__shade__.org.apache.johnzon.jsonb.adapter.JsonbEnumAdapter;
import org.talend.__shade__.org.apache.johnzon.jsonb.api.experimental.PolymorphicConfig;
import org.talend.__shade__.org.apache.johnzon.jsonb.cdi.CDIs;
import org.talend.__shade__.org.apache.johnzon.jsonb.converter.JohnzonJsonbAdapter;
import org.talend.__shade__.org.apache.johnzon.jsonb.factory.CdiJohnzonAdapterFactory;
import org.talend.__shade__.org.apache.johnzon.jsonb.factory.SimpleJohnzonAdapterFactory;
import org.talend.__shade__.org.apache.johnzon.jsonb.reflect.Types;
import org.talend.__shade__.org.apache.johnzon.jsonb.serializer.JohnzonDeserializationContext;
import org.talend.__shade__.org.apache.johnzon.jsonb.serializer.JohnzonSerializationContext;
import org.talend.__shade__.org.apache.johnzon.jsonb.spi.JohnzonAdapterFactory;
import org.talend.__shade__.org.apache.johnzon.mapper.Converter;
import org.talend.__shade__.org.apache.johnzon.mapper.Mapper;
import org.talend.__shade__.org.apache.johnzon.mapper.MapperBuilder;
import org.talend.__shade__.org.apache.johnzon.mapper.MapperConfig;
import org.talend.__shade__.org.apache.johnzon.mapper.MappingParser;
import org.talend.__shade__.org.apache.johnzon.mapper.SerializeValueFilter;
import org.talend.__shade__.org.apache.johnzon.mapper.access.AccessMode;
import org.talend.__shade__.org.apache.johnzon.mapper.access.FieldAndMethodAccessMode;
import org.talend.__shade__.org.apache.johnzon.mapper.converter.LocaleConverter;
import org.talend.__shade__.org.apache.johnzon.mapper.internal.AdapterKey;

public class JohnzonBuilder
implements JsonbBuilder {
    private static final Object NO_BM = new Object();
    private final MapperBuilder builder = new MapperBuilder();
    private JsonProvider jsonp;
    private JsonbConfig config;
    private Object beanManager;
    private CDIs cdiIntegration;

    @Override
    public JsonbBuilder withConfig(JsonbConfig config) {
        this.config = config;
        return this;
    }

    @Override
    public JsonbBuilder withProvider(JsonProvider jsonpProvider) {
        this.jsonp = jsonpProvider;
        return this;
    }

    @Override
    public Jsonb build() {
        this.builder.setEnumConverterFactory(type -> this.newEnumConverter((Class)Class.class.cast(type)));
        if (this.jsonp != null) {
            this.builder.setGeneratorFactory(this.jsonp.createGeneratorFactory(this.generatorConfig()));
            this.builder.setReaderFactory(this.jsonp.createReaderFactory(this.readerConfig()));
        } else {
            this.jsonp = JsonProvider.provider();
        }
        Supplier<JsonBuilderFactory> builderFactorySupplier = this.createJsonBuilderFactory();
        Supplier<JsonParserFactory> parserFactoryProvider = this.createJsonParserFactory();
        if (this.config == null) {
            this.config = new JsonbConfig();
        }
        boolean skipCdi = this.shouldSkipCdi();
        this.builder.setUseBigDecimalForObjectNumbers(this.config.getProperty("johnzon.use-big-decimal-for-object").map(this::toBool).orElse(true));
        this.builder.setMaxBigDecimalScale(this.config.getProperty("johnzon.max-big-decimal-scale").map(this::toInt).orElse(1000));
        this.builder.setSupportEnumContainerDeserialization(this.toBool(System.getProperty("johnzon.support-enum-container-deserialization", this.config.getProperty("johnzon.support-enum-container-deserialization").map(String::valueOf).orElse("true"))));
        boolean ijson = this.config.getProperty("jsonb.strict-ijson").map(Boolean.class::cast).filter(it -> it).map(it -> {
            if (!this.config.getProperty("jsonb.binary-data-strategy").isPresent()) {
                this.config.withBinaryDataStrategy("BASE_64");
            }
            if (!this.config.getProperty("jsonb.date-format").isPresent()) {
                this.config.withDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'xxx", Locale.ROOT);
            }
            return it;
        }).orElse(false);
        if (this.config.getProperty("jsonb.formatting").map(Boolean.class::cast).orElse(false).booleanValue()) {
            this.builder.setPretty(true);
        }
        this.config.getProperty(PolymorphicConfig.class.getName()).map(PolymorphicConfig.class::cast).ifPresent(pc -> {
            this.builder.setPolymorphicDiscriminator(pc.getDiscriminator());
            this.builder.setPolymorphicDeserializationPredicate(pc.getDeserializationPredicate());
            this.builder.setPolymorphicSerializationPredicate(pc.getSerializationPredicate());
            this.builder.setPolymorphicDiscriminatorMapper(pc.getDiscriminatorMapper());
            this.builder.setPolymorphicTypeLoader(pc.getTypeLoader());
        });
        this.config.getProperty("jsonb.encoding").ifPresent(encoding -> this.builder.setEncoding(String.valueOf(encoding)));
        boolean isNillable = this.config.getProperty("jsonb.null-values").map(it -> String.class.isInstance(it) ? Boolean.valueOf(Boolean.parseBoolean(it.toString())) : (Boolean)Boolean.class.cast(it)).map(serNulls -> {
            this.builder.setSkipNull(serNulls == false);
            return serNulls;
        }).orElse(false);
        Optional<Object> namingStrategyValue = this.config.getProperty("jsonb.property-naming-strategy");
        PropertyNamingStrategy propertyNamingStrategy = new PropertyNamingStrategyFactory(namingStrategyValue.orElse("IDENTITY")).create();
        String orderValue = this.config.getProperty("jsonb.property-order-strategy").map(String::valueOf).orElse("ANY");
        PropertyVisibilityStrategy visibilityStrategy = this.config.getProperty("jsonb.property-visibility-strategy").map(PropertyVisibilityStrategy.class::cast).orElse(new DefaultPropertyVisibilityStrategy());
        this.config.getProperty("johnzon.attributeOrder").ifPresent(comp -> this.builder.setAttributeOrder((Comparator)Comparator.class.cast(comp)));
        this.config.getProperty("johnzon.primitiveConverters").map(this::toBool).ifPresent(this.builder::setPrimitiveConverters);
        this.config.getProperty("johnzon.useBigDecimalForFloats").map(this::toBool).ifPresent(this.builder::setUseBigDecimalForFloats);
        this.config.getProperty("johnzon.deduplicateObjects").map(this::toBool).ifPresent(this.builder::setDeduplicateObjects);
        this.config.getProperty("johnzon.interfaceImplementationMapping").map(Map.class::cast).ifPresent(this.builder::setInterfaceImplementationMapping);
        this.builder.setUseJsRange(this.toBool(System.getProperty("johnzon.use-js-range", this.config.getProperty("johnzon.use-js-range").map(String::valueOf).orElse("false"))));
        this.builder.setUseShortISO8601Format(false);
        this.config.getProperty("jsonb.date-format").map(String.class::cast).ifPresent(dateFormat -> this.builder.setAdaptersDateTimeFormatter(this.config.getProperty("jsonb.locale").map(it -> String.class.isInstance(it) ? new LocaleConverter().to(it.toString()) : (Locale)Locale.class.cast(it)).map(value -> DateTimeFormatter.ofPattern(dateFormat, value)).orElseGet(() -> DateTimeFormatter.ofPattern(dateFormat))));
        JohnzonAdapterFactory factory = this.config.getProperty("johnzon.factory").map(val -> {
            if (JohnzonAdapterFactory.class.isInstance(val)) {
                return (JohnzonAdapterFactory)JohnzonAdapterFactory.class.cast(val);
            }
            if (String.class.isInstance(val)) {
                try {
                    return (JohnzonAdapterFactory)JohnzonAdapterFactory.class.cast(this.tccl().loadClass(val.toString()).newInstance());
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            if (Class.class.isInstance(val)) {
                try {
                    return (JohnzonAdapterFactory)JohnzonAdapterFactory.class.cast(((Class)Class.class.cast(val)).newInstance());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            throw new IllegalArgumentException("Unsupported factory: " + val);
        }).orElseGet(() -> this.findFactory(skipCdi));
        Optional.ofNullable(this.config.getProperty("johnzon.skip-exception-serialization")).map(v -> Boolean.parseBoolean(String.valueOf(v))).ifPresent(this.builder::setSkipAccessModeWrapper);
        AccessMode accessMode = this.config.getProperty("johnzon.accessMode").map(this::toAccessMode).orElseGet(() -> new JsonbAccessMode(propertyNamingStrategy, orderValue, visibilityStrategy, !namingStrategyValue.orElse("").equals("CASE_INSENSITIVE"), this.builder.getAdapters(), factory, this.jsonp, builderFactorySupplier, parserFactoryProvider, this.config.getProperty("johnzon.accessModeDelegate").map(this::toAccessMode).orElseGet(() -> new FieldAndMethodAccessMode(true, true, false, false, true)), this.config.getProperty("johnzon.failOnMissingCreatorValues").map(this::toBool).orElseGet(() -> this.config.getProperty("jsonb.creator-parameters-required").map(this::toBool).orElse(false)), isNillable, this.config.getProperty("johnzon.supportsPrivateAccess").map(this::toBool).orElse(false)));
        this.builder.setAccessMode(accessMode);
        this.config.getProperty("johnzon.snippetMaxLength").map(it -> Number.class.isInstance(it) ? ((Number)Number.class.cast(it)).intValue() : Integer.parseInt(it.toString())).ifPresent(this.builder::setSnippetMaxLength);
        Types types = new Types();
        this.config.getProperty("jsonb.adapters").ifPresent(adapters -> Stream.of((Object[])JsonbAdapter[].class.cast(adapters)).forEach(adapter -> {
            ParameterizedType pt = types.findParameterizedType(adapter.getClass(), JsonbAdapter.class);
            if (pt == null) {
                throw new IllegalArgumentException(adapter + " doesn't implement JsonbAdapter");
            }
            Type[] args = pt.getActualTypeArguments();
            JohnzonJsonbAdapter johnzonJsonbAdapter = new JohnzonJsonbAdapter(adapter, args[0], args[1]);
            this.builder.addAdapter(args[0], args[1], johnzonJsonbAdapter);
            this.builder.getAdapters().put(new AdapterKey(args[0], args[1]), johnzonJsonbAdapter);
        }));
        Optional.ofNullable(this.config.getProperty("johnzon.fail-on-unknown-properties").orElseGet(() -> this.config.getProperty("jsonb.fail-on-unknown-properties").orElse(null))).map(v -> Boolean.class.isInstance(v) ? (Boolean)Boolean.class.cast(v) : Boolean.valueOf(Boolean.parseBoolean(String.valueOf(v)))).ifPresent(this.builder::setFailOnUnknownProperties);
        this.config.getProperty("jsonb.binary-data-strategy").map(String.class::cast).ifPresent(bin -> {
            switch (bin) {
                case "BYTE": {
                    break;
                }
                case "BASE_64": {
                    this.builder.setTreatByteArrayAsBase64(true);
                    break;
                }
                case "BASE_64_URL": {
                    this.builder.addConverter((Type)((Object)byte[].class), new Converter<byte[]>(){

                        @Override
                        public String toString(byte[] instance) {
                            return Base64.getUrlEncoder().encodeToString(instance);
                        }

                        @Override
                        public byte[] fromString(String text) {
                            return Base64.getUrlDecoder().decode(text.getBytes(StandardCharsets.UTF_8));
                        }
                    });
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported binary configuration: " + bin);
                }
            }
        });
        if (!skipCdi) {
            this.getBeanManager();
        }
        this.builder.setReadAttributeBeforeWrite(this.config.getProperty("johnzon.readAttributeBeforeWrite").map(Boolean.class::cast).orElse(false));
        this.builder.setAutoAdjustStringBuffers(this.config.getProperty("johnzon.autoAdjustBuffer").map(Boolean.class::cast).orElse(true));
        this.config.getProperty("johnzon.serialize-value-filter").map(s -> {
            if (String.class.isInstance(s)) {
                try {
                    return SerializeValueFilter.class.cast(Thread.currentThread().getContextClassLoader().loadClass(s.toString()).getConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException e) {
                    throw new IllegalArgumentException(e);
                }
                catch (InvocationTargetException e) {
                    throw new IllegalArgumentException(e.getCause());
                }
            }
            return s;
        }).ifPresent(s -> this.builder.setSerializeValueFilter((SerializeValueFilter)SerializeValueFilter.class.cast(s)));
        this.config.getProperty("jsonb.serializers").map(JsonbSerializer[].class::cast).ifPresent(serializers -> Stream.of(serializers).forEach(s -> {
            ParameterizedType pt = types.findParameterizedType(s.getClass(), JsonbSerializer.class);
            Type[] args = pt.getActualTypeArguments();
            if (args.length != 1 || !Class.class.isInstance(args[0])) {
                throw new IllegalArgumentException("We only support serializer on Class for now");
            }
            this.builder.addObjectConverter((Class)Class.class.cast(args[0]), (instance, jsonbGenerator) -> s.serialize(instance, jsonbGenerator.getJsonGenerator(), new JohnzonSerializationContext(jsonbGenerator)));
        }));
        this.config.getProperty("jsonb.derializers").map(JsonbDeserializer[].class::cast).ifPresent(deserializers -> Stream.of(deserializers).forEach(arg_0 -> this.lambda$null$30(types, (Supplier)builderFactorySupplier, (Supplier)parserFactoryProvider, arg_0)));
        if (Closeable.class.isInstance(accessMode)) {
            this.builder.addCloseable((Closeable)Closeable.class.cast(accessMode));
        }
        return this.doCreateJsonb(skipCdi, ijson, this.builder.build());
    }

    private <T extends Enum<T>> MapperConfig.CustomEnumConverter<T> newEnumConverter(Class<T> enumType) {
        return new JsonbEnumAdapter<T>(enumType);
    }

    private Jsonb doCreateJsonb(boolean skipCdi, boolean ijson, Mapper mapper) {
        if (!skipCdi && this.cdiIntegration != null && this.cdiIntegration.isCanWrite()) {
            JohnzonJsonb jsonb = new JohnzonJsonb(mapper, ijson, i -> {
                if (this.cdiIntegration.isCanWrite()) {
                    this.cdiIntegration.untrack((JohnzonJsonb)i);
                }
            });
            this.cdiIntegration.track(jsonb);
            return jsonb;
        }
        return new JohnzonJsonb(mapper, ijson, null);
    }

    private Boolean toBool(Object v) {
        return !Boolean.class.isInstance(v) ? Boolean.valueOf(Boolean.parseBoolean(v.toString())) : (Boolean)Boolean.class.cast(v);
    }

    private Integer toInt(Object v) {
        return !Integer.class.isInstance(v) ? Integer.valueOf(Integer.parseInt(v.toString())) : (Integer)Integer.class.cast(v);
    }

    private AccessMode toAccessMode(Object s) {
        if (String.class.isInstance(s)) {
            try {
                return (AccessMode)AccessMode.class.cast(Thread.currentThread().getContextClassLoader().loadClass(s.toString()).getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException e) {
                throw new IllegalArgumentException(e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException(e.getCause());
            }
        }
        return (AccessMode)AccessMode.class.cast(s);
    }

    private Supplier<JsonParserFactory> createJsonParserFactory() {
        return new Lazy<JsonParserFactory>(){

            @Override
            protected JsonParserFactory doCreate() {
                return JohnzonBuilder.this.jsonp.createParserFactory(Collections.emptyMap());
            }
        };
    }

    private Supplier<JsonBuilderFactory> createJsonBuilderFactory() {
        return new Lazy<JsonBuilderFactory>(){

            @Override
            protected JsonBuilderFactory doCreate() {
                return JohnzonBuilder.this.jsonp.createBuilderFactory(Collections.emptyMap());
            }
        };
    }

    private Object getBeanManager() {
        if (this.beanManager == null) {
            try {
                Class<?> cdi = this.tccl().loadClass("javax.enterprise.inject.spi.CDI");
                Object cdiInstance = cdi.getMethod("current", new Class[0]).invoke(null, new Object[0]);
                this.beanManager = cdi.getMethod("getBeanManager", new Class[0]).invoke(cdiInstance, new Object[0]);
                this.cdiIntegration = new CDIs(this.beanManager);
            }
            catch (Exception | NoClassDefFoundError e) {
                this.beanManager = NO_BM;
            }
        }
        return this.beanManager;
    }

    private JohnzonAdapterFactory findFactory(boolean skipCdi) {
        if (skipCdi || this.getBeanManager() == NO_BM) {
            return new SimpleJohnzonAdapterFactory();
        }
        try {
            return new CdiJohnzonAdapterFactory(this.beanManager);
        }
        catch (Exception | NoClassDefFoundError e) {
            return new SimpleJohnzonAdapterFactory();
        }
    }

    private Boolean shouldSkipCdi() {
        return this.config.getProperty("johnzon.skip-cdi").map(s -> "true".equalsIgnoreCase(String.valueOf(s))).orElseGet(() -> this.config.getProperty("johnzon.cdi.activated").map(Boolean.class::cast).orElse(Boolean.TRUE) == false);
    }

    private ClassLoader tccl() {
        return Optional.ofNullable(Thread.currentThread().getContextClassLoader()).orElseGet(ClassLoader::getSystemClassLoader);
    }

    private Map<String, ?> generatorConfig() {
        HashMap map = new HashMap();
        if (this.config == null) {
            return map;
        }
        this.config.getProperty("org.talend.__shade__.org.apache.johnzon.default-char-buffer-generator").ifPresent(b -> map.put("org.talend.__shade__.org.apache.johnzon.default-char-buffer-generator", b));
        this.config.getProperty("org.talend.__shade__.org.apache.johnzon.boundedoutputstreamwriter").ifPresent(b -> map.put("org.talend.__shade__.org.apache.johnzon.boundedoutputstreamwriter", b));
        this.config.getProperty("org.talend.__shade__.org.apache.johnzon.buffer-strategy").ifPresent(b -> map.put("org.talend.__shade__.org.apache.johnzon.buffer-strategy", b));
        this.config.getProperty("jsonb.formatting").ifPresent(b -> map.put("org.talend.__shade__.javax.json.stream.JsonGenerator.prettyPrinting", b));
        return map;
    }

    private Map<String, ?> readerConfig() {
        HashMap map = new HashMap();
        if (this.config == null) {
            return map;
        }
        this.config.getProperty("org.talend.__shade__.org.apache.johnzon.default-char-buffer").ifPresent(b -> map.put("org.talend.__shade__.org.apache.johnzon.default-char-buffer", b));
        this.config.getProperty("org.talend.__shade__.org.apache.johnzon.max-string-length").ifPresent(b -> map.put("org.talend.__shade__.org.apache.johnzon.max-string-length", b));
        this.config.getProperty("org.talend.__shade__.org.apache.johnzon.supports-comments").ifPresent(b -> map.put("org.talend.__shade__.org.apache.johnzon.supports-comments", b));
        this.config.getProperty("org.talend.__shade__.org.apache.johnzon.buffer-strategy").ifPresent(b -> map.put("org.talend.__shade__.org.apache.johnzon.buffer-strategy", b));
        return map;
    }

    private /* synthetic */ void lambda$null$30(Types types, Supplier builderFactorySupplier, Supplier parserFactoryProvider, JsonbDeserializer d) {
        ParameterizedType pt = types.findParameterizedType(d.getClass(), JsonbDeserializer.class);
        Type[] args = pt.getActualTypeArguments();
        if (args.length != 1 || !Class.class.isInstance(args[0])) {
            throw new IllegalArgumentException("We only support deserializer on Class for now");
        }
        JsonBuilderFactory builderFactory = (JsonBuilderFactory)builderFactorySupplier.get();
        this.builder.addObjectConverter((Class)Class.class.cast(args[0]), (arg_0, arg_1, arg_2) -> this.lambda$null$29(d, (Supplier)parserFactoryProvider, builderFactory, arg_0, arg_1, arg_2));
    }

    private /* synthetic */ Object lambda$null$29(JsonbDeserializer d, Supplier parserFactoryProvider, JsonBuilderFactory builderFactory, JsonValue jsonObject, Type targetType, MappingParser parser) {
        return d.deserialize(JsonValueParserAdapter.createFor(jsonObject, parserFactoryProvider), new JohnzonDeserializationContext(parser, builderFactory, this.jsonp), targetType);
    }

    private static abstract class Lazy<T>
    implements Supplier<T> {
        private final AtomicReference<T> ref = new AtomicReference();

        private Lazy() {
        }

        @Override
        public T get() {
            T factory = this.ref.get();
            if (factory == null && !this.ref.compareAndSet(null, factory = this.doCreate())) {
                factory = this.ref.get();
            }
            return factory;
        }

        protected abstract T doCreate();
    }
}

