/*
 * Decompiled with CFR 0.152.
 */
package org.talend.__shade__.org.apache.johnzon.mapper.access;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.talend.__shade__.org.apache.johnzon.mapper.Adapter;
import org.talend.__shade__.org.apache.johnzon.mapper.ObjectConverter;
import org.talend.__shade__.org.apache.johnzon.mapper.access.AccessMode;

public class KnownNotOpenedJavaTypesAccessMode
implements AccessMode {
    private final AccessMode delegate;

    public KnownNotOpenedJavaTypesAccessMode(AccessMode delegate) {
        this.delegate = delegate;
    }

    private boolean isInaccessibleAndThrowable(Class<?> clazz, RuntimeException ioe) {
        return "java.lang.reflect.InaccessibleObjectException".equals(ioe.getClass().getName()) && Throwable.class.isAssignableFrom(clazz);
    }

    private Map<String, AccessMode.Writer> findThrowableWriters(Class<?> clazz) {
        HashMap<String, AccessMode.Writer> map = new HashMap<String, AccessMode.Writer>();
        map.put("stackTrace", new InlineWriter(Throwable::setStackTrace, (Type)((Object)StackTraceElement[].class)));
        return map;
    }

    private Map<String, AccessMode.Reader> findThrowableReaders(Class<?> clazz) {
        HashMap<String, AccessMode.Reader> map = new HashMap<String, AccessMode.Reader>();
        map.put("message", new InlineReader(Throwable::getMessage, String.class));
        map.put("stackTrace", new InlineReader(Throwable::getStackTrace, StackTraceElement[].class));
        return map;
    }

    private Map<String, AccessMode.Reader> findStackTraceElementReaders(Class<?> clazz) {
        HashMap<String, AccessMode.Reader> map = new HashMap<String, AccessMode.Reader>();
        map.put("className", new InlineReader(StackTraceElement::getClassName, String.class));
        map.put("methodName", new InlineReader(StackTraceElement::getMethodName, String.class));
        map.put("fileName", new InlineReader(StackTraceElement::getFileName, String.class));
        map.put("lineNumber", new InlineReader(StackTraceElement::getLineNumber, Integer.TYPE));
        return map;
    }

    private AccessMode.Factory findThrowableFactory(Class<?> clazz) {
        if (Throwable.class == clazz) {
            return new ExceptionMessageFactory(){

                @Override
                public Object create(Object[] params) {
                    return new Throwable((String)String.class.cast(params[0]));
                }
            };
        }
        if (Exception.class == clazz) {
            return new ExceptionMessageFactory(){

                @Override
                public Object create(Object[] params) {
                    return new Exception((String)String.class.cast(params[0]));
                }
            };
        }
        if (Error.class == clazz) {
            return new ExceptionMessageFactory(){

                @Override
                public Object create(Object[] params) {
                    return new Error((String)String.class.cast(params[0]));
                }
            };
        }
        try {
            return this.delegate.findFactory(clazz);
        }
        catch (Error | RuntimeException e) {
            return null;
        }
    }

    private boolean isJavaThrowable(Class<?> clazz) {
        return clazz.getName().startsWith("java.") && Throwable.class.isAssignableFrom(clazz);
    }

    private boolean isStackTraceElement(Class<?> clazz) {
        return clazz == StackTraceElement.class;
    }

    @Override
    public AccessMode.Factory findFactory(Class<?> clazz, Function<AnnotatedElement, String> ... parameterNameExtractors) {
        return this.delegate.findFactory(clazz, parameterNameExtractors);
    }

    @Override
    public AccessMode.Factory findFactory(Class<?> clazz) {
        if (this.isJavaThrowable(clazz)) {
            return this.findThrowableFactory(clazz);
        }
        if (this.isStackTraceElement(clazz)) {
            return new BaseFactory(){

                @Override
                public Object create(Object[] params) {
                    return new StackTraceElement((String)String.class.cast(params[0]), (String)String.class.cast(params[1]), (String)String.class.cast(params[2]), params.length < 4 || params[3] == null ? -1 : (Integer)Integer.class.cast(params[3]));
                }

                @Override
                public Type[] getParameterTypes() {
                    return new Type[]{String.class, String.class, String.class, Integer.TYPE};
                }

                @Override
                public String[] getParameterNames() {
                    return new String[]{"className", "methodName", "fileName", "lineNumber"};
                }

                @Override
                public Adapter<?, ?>[] getParameterConverter() {
                    return new Adapter[]{null, null, null, null};
                }

                @Override
                public Adapter<?, ?>[] getParameterItemConverter() {
                    return new Adapter[]{null, null, null, null};
                }

                @Override
                public ObjectConverter.Codec<?>[] getObjectConverter() {
                    return new ObjectConverter.Codec[]{null, null, null, null};
                }
            };
        }
        return this.delegate.findFactory(clazz);
    }

    @Override
    public Map<String, AccessMode.Reader> findReaders(Class<?> clazz) {
        if (this.isJavaThrowable(clazz)) {
            return this.findThrowableReaders(clazz);
        }
        if (this.isStackTraceElement(clazz)) {
            return this.findStackTraceElementReaders(clazz);
        }
        try {
            return this.delegate.findReaders(clazz);
        }
        catch (RuntimeException ioe) {
            if (this.isInaccessibleAndThrowable(clazz, ioe)) {
                return this.findThrowableReaders(clazz);
            }
            throw ioe;
        }
    }

    @Override
    public Map<String, AccessMode.Writer> findWriters(Class<?> clazz) {
        if (this.isJavaThrowable(clazz)) {
            return this.findThrowableWriters(clazz);
        }
        if (this.isStackTraceElement(clazz)) {
            return Collections.emptyMap();
        }
        try {
            return this.delegate.findWriters(clazz);
        }
        catch (RuntimeException ioe) {
            if (this.isInaccessibleAndThrowable(clazz, ioe)) {
                return this.findThrowableWriters(clazz);
            }
            throw ioe;
        }
    }

    @Override
    public ObjectConverter.Reader<?> findReader(Class<?> clazz) {
        if (this.isJavaThrowable(clazz) || this.isStackTraceElement(clazz)) {
            return null;
        }
        return this.delegate.findReader(clazz);
    }

    @Override
    public ObjectConverter.Writer<?> findWriter(Class<?> clazz) {
        if (this.isJavaThrowable(clazz) || this.isStackTraceElement(clazz)) {
            return null;
        }
        return this.delegate.findWriter(clazz);
    }

    @Override
    public Method findAnyGetter(Class<?> clazz) {
        if (this.isJavaThrowable(clazz) || this.isStackTraceElement(clazz)) {
            return null;
        }
        return this.delegate.findAnyGetter(clazz);
    }

    @Override
    public Method findAnySetter(Class<?> clazz) {
        if (this.isJavaThrowable(clazz) || this.isStackTraceElement(clazz)) {
            return null;
        }
        return this.delegate.findAnySetter(clazz);
    }

    @Override
    public Field findAnyField(Class<?> clazz) {
        if (this.isJavaThrowable(clazz) || this.isStackTraceElement(clazz)) {
            return null;
        }
        return this.delegate.findAnyField(clazz);
    }

    @Override
    public Method findMapAdder(Class<?> clazz) {
        if (this.isJavaThrowable(clazz) || this.isStackTraceElement(clazz)) {
            return null;
        }
        return this.delegate.findMapAdder(clazz);
    }

    @Override
    public Adapter<?, ?> findAdapter(Class<?> clazz) {
        return this.delegate.findAdapter(clazz);
    }

    @Override
    public Comparator<String> fieldComparator(Class<?> clazz) {
        return this.delegate.fieldComparator(clazz);
    }

    @Override
    public void afterParsed(Class<?> clazz) {
        this.delegate.afterParsed(clazz);
    }

    private static abstract class ExceptionMessageFactory
    extends BaseFactory {
        private ExceptionMessageFactory() {
        }

        @Override
        public Type[] getParameterTypes() {
            return new Type[]{String.class};
        }

        @Override
        public String[] getParameterNames() {
            return new String[]{"message"};
        }

        @Override
        public Adapter<?, ?>[] getParameterConverter() {
            return new Adapter[]{null};
        }

        @Override
        public Adapter<?, ?>[] getParameterItemConverter() {
            return new Adapter[]{null};
        }

        @Override
        public ObjectConverter.Codec<?>[] getObjectConverter() {
            return new ObjectConverter.Codec[]{null};
        }
    }

    private static abstract class BaseFactory
    implements AccessMode.Factory {
        private BaseFactory() {
        }

        @Override
        public Type[] getParameterTypes() {
            return new Type[0];
        }

        @Override
        public String[] getParameterNames() {
            return new String[0];
        }

        @Override
        public Adapter<?, ?>[] getParameterConverter() {
            return new Adapter[0];
        }

        @Override
        public Adapter<?, ?>[] getParameterItemConverter() {
            return new Adapter[0];
        }

        @Override
        public ObjectConverter.Codec<?>[] getObjectConverter() {
            return new ObjectConverter.Codec[0];
        }
    }

    private static class InlineReader<T, F>
    implements AccessMode.Reader {
        private final Function accessor;
        private final Class<F> type;

        private InlineReader(Function<T, F> accessor, Class<F> type) {
            this.accessor = (Function)Function.class.cast(accessor);
            this.type = type;
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> clazz) {
            return null;
        }

        @Override
        public <T extends Annotation> T getClassOrPackageAnnotation(Class<T> clazz) {
            return null;
        }

        @Override
        public Adapter<?, ?> findConverter() {
            return null;
        }

        @Override
        public boolean isNillable(boolean globalConfig) {
            return false;
        }

        @Override
        public Object read(Object instance) {
            return this.accessor.apply(instance);
        }

        @Override
        public ObjectConverter.Writer<?> findObjectConverterWriter() {
            return null;
        }
    }

    private static class InlineWriter<T, F>
    implements AccessMode.Writer {
        private final BiConsumer setter;
        private final Type type;

        private InlineWriter(BiConsumer<T, F> setter, Type type) {
            this.setter = setter;
            this.type = type;
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> clazz) {
            return null;
        }

        @Override
        public <T extends Annotation> T getClassOrPackageAnnotation(Class<T> clazz) {
            return null;
        }

        @Override
        public Adapter<?, ?> findConverter() {
            return null;
        }

        @Override
        public boolean isNillable(boolean globalConfig) {
            return false;
        }

        @Override
        public void write(Object instance, Object value) {
            this.setter.accept(instance, value);
        }

        @Override
        public ObjectConverter.Reader<?> findObjectConverterReader() {
            return null;
        }
    }
}

