/*
 * Decompiled with CFR 0.152.
 */
package org.talend.__shade__.org.apache.johnzon.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.talend.__shade__.javax.json.JsonArray;
import org.talend.__shade__.javax.json.JsonArrayBuilder;
import org.talend.__shade__.javax.json.JsonException;
import org.talend.__shade__.javax.json.JsonObject;
import org.talend.__shade__.javax.json.JsonObjectBuilder;
import org.talend.__shade__.javax.json.JsonPointer;
import org.talend.__shade__.javax.json.JsonStructure;
import org.talend.__shade__.javax.json.JsonValue;
import org.talend.__shade__.javax.json.spi.JsonProvider;
import org.talend.__shade__.org.apache.johnzon.core.JsonPointerUtil;

public class JsonPointerImpl
implements JsonPointer {
    private final JsonProvider provider;
    private final String jsonPointer;
    private final List<String> referenceTokens = new ArrayList<String>();
    private static final Pattern IS_NUMBER = Pattern.compile("\\d+");

    public JsonPointerImpl(JsonProvider provider, String jsonPointer) {
        String[] encodedReferenceTokens;
        if (jsonPointer == null) {
            throw new NullPointerException("jsonPointer must not be null");
        }
        if (!jsonPointer.equals("") && !jsonPointer.startsWith("/")) {
            throw new JsonException("A non-empty JsonPointer string must begin with a '/'");
        }
        this.provider = provider;
        this.jsonPointer = jsonPointer;
        for (String encodedReferenceToken : encodedReferenceTokens = jsonPointer.split("/", -1)) {
            this.referenceTokens.add(JsonPointerUtil.decode(encodedReferenceToken));
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JsonPointerImpl that = (JsonPointerImpl)obj;
        return this.jsonPointer.equals(that.jsonPointer);
    }

    public int hashCode() {
        return this.jsonPointer.hashCode();
    }

    @Override
    public JsonValue getValue(JsonStructure target) {
        if (target == null) {
            throw new NullPointerException("target must not be null");
        }
        if (this.isEmptyJsonPointer()) {
            return target;
        }
        JsonValue jsonValue = target;
        for (int i = 1; i < this.referenceTokens.size(); ++i) {
            jsonValue = this.getValue(jsonValue, this.referenceTokens.get(i), i, this.referenceTokens.size() - 1);
        }
        return jsonValue;
    }

    @Override
    public boolean containsValue(JsonStructure target) {
        try {
            this.getValue(target);
            return true;
        }
        catch (JsonException je) {
            return false;
        }
    }

    public JsonStructure add(JsonStructure target, JsonValue value) {
        this.validateAdd(target);
        if (this.isEmptyJsonPointer()) {
            return (JsonStructure)value;
        }
        return this.addInternal(target, value);
    }

    public JsonObject add(JsonObject target, JsonValue value) {
        this.validateAdd(target);
        return this.addInternal(target, value);
    }

    public JsonArray add(JsonArray target, JsonValue value) {
        this.validateAdd(target);
        return this.addInternal(target, value);
    }

    public JsonStructure replace(JsonStructure target, JsonValue value) {
        if (target instanceof JsonObject) {
            return this.replace((JsonObject)target, value);
        }
        return this.replace((JsonArray)target, value);
    }

    public JsonObject replace(JsonObject target, JsonValue value) {
        return this.add(this.remove(target), value);
    }

    public JsonArray replace(JsonArray target, JsonValue value) {
        return this.add(this.remove(target), value);
    }

    public JsonStructure remove(JsonStructure target) {
        if (target.getValueType() == JsonValue.ValueType.OBJECT) {
            return this.remove(target.asJsonObject());
        }
        return this.remove(target.asJsonArray());
    }

    public JsonObject remove(JsonObject target) {
        this.validateRemove(target);
        return this.remove(target, 1).asJsonObject();
    }

    public JsonArray remove(JsonArray target) {
        this.validateRemove(target);
        return this.remove(target, 1).asJsonArray();
    }

    String getJsonPointer() {
        return this.jsonPointer;
    }

    public String toString() {
        return "JsonPointerImpl{jsonPointer='" + this.jsonPointer + '\'' + ", referenceTokens=" + this.referenceTokens + '}';
    }

    private void validateAdd(JsonValue target) {
        this.validateJsonPointer(target, this.referenceTokens.size() - 1);
    }

    private void validateRemove(JsonValue target) {
        this.validateJsonPointer(target, this.referenceTokens.size());
        if (this.isEmptyJsonPointer()) {
            throw new JsonException("The reference must not be the target");
        }
    }

    private boolean isEmptyJsonPointer() {
        return this.jsonPointer.equals("");
    }

    private JsonValue getValue(JsonValue jsonValue, String referenceToken, int currentPosition, int referencePosition) {
        if (jsonValue instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)jsonValue;
            if ((jsonValue = (JsonValue)jsonObject.get(referenceToken)) != null) {
                return jsonValue;
            }
            throw new JsonException("'" + jsonObject + "' contains no value for name '" + referenceToken + "'");
        }
        if (jsonValue instanceof JsonArray) {
            this.validateArrayIndex(referenceToken);
            try {
                JsonArray jsonArray = (JsonArray)jsonValue;
                int arrayIndex = this.getArrayIndex(referenceToken, jsonArray, false);
                return (JsonValue)jsonArray.get(arrayIndex);
            }
            catch (NumberFormatException e) {
                throw new JsonException("'" + referenceToken + "' is no valid array index", e);
            }
        }
        if (currentPosition != referencePosition) {
            return jsonValue;
        }
        throw new JsonException("'" + jsonValue + "' contains no element for '" + referenceToken + "'");
    }

    private <T extends JsonStructure> T addInternal(T jsonValue, JsonValue newValue) {
        ArrayList<String> currentPath = new ArrayList<String>();
        currentPath.add("");
        return (T)((JsonStructure)this.addInternal(jsonValue, newValue, currentPath, true));
    }

    private JsonValue addInternal(JsonValue jsonValue, JsonValue newValue, List<String> currentPath, boolean check) {
        if (jsonValue.getValueType() == JsonValue.ValueType.OBJECT) {
            JsonObject jsonObject = jsonValue.asJsonObject();
            if (!check) {
                return this.provider.createObjectBuilder(jsonObject).build();
            }
            JsonObjectBuilder objectBuilder = this.provider.createObjectBuilder();
            if (jsonObject.isEmpty() && this.isPositionToAdd(currentPath)) {
                objectBuilder.add(this.referenceTokens.get(this.referenceTokens.size() - 1), newValue);
            } else {
                for (Map.Entry entry : jsonObject.entrySet()) {
                    currentPath.add((String)entry.getKey());
                    objectBuilder.add((String)entry.getKey(), this.addInternal((JsonValue)entry.getValue(), newValue, currentPath, this.canMatch(currentPath)));
                    currentPath.remove(entry.getKey());
                    if (!this.isPositionToAdd(currentPath)) continue;
                    objectBuilder.add(this.referenceTokens.get(this.referenceTokens.size() - 1), newValue);
                }
            }
            return objectBuilder.build();
        }
        if (jsonValue.getValueType() == JsonValue.ValueType.ARRAY) {
            JsonArray jsonArray = jsonValue.asJsonArray();
            if (!check) {
                return this.provider.createArrayBuilder(jsonArray).build();
            }
            JsonArrayBuilder arrayBuilder = this.provider.createArrayBuilder();
            int arrayIndex = -1;
            if (this.isPositionToAdd(currentPath)) {
                arrayIndex = this.getArrayIndex(this.referenceTokens.get(this.referenceTokens.size() - 1), jsonArray, this.canMatch(currentPath));
            }
            int jsonArraySize = jsonArray.size();
            for (int i = 0; i <= jsonArraySize; ++i) {
                if (i == arrayIndex) {
                    arrayBuilder.add(newValue);
                }
                if (i == jsonArraySize) break;
                String path = String.valueOf(i);
                currentPath.add(path);
                arrayBuilder.add(this.addInternal((JsonValue)jsonArray.get(i), newValue, currentPath, this.canMatch(currentPath)));
                currentPath.remove(path);
            }
            return arrayBuilder.build();
        }
        return jsonValue;
    }

    private boolean isPositionToAdd(List<String> currentPath) {
        return currentPath.size() == this.referenceTokens.size() - 1 && currentPath.get(currentPath.size() - 1).equals(this.referenceTokens.get(this.referenceTokens.size() - 2));
    }

    private boolean canMatch(List<String> currentPath) {
        return currentPath.size() <= this.referenceTokens.size() && Objects.equals(currentPath.get(currentPath.size() - 1), this.referenceTokens.get(currentPath.size() - 1));
    }

    private JsonValue remove(JsonValue jsonValue, int currentPosition) {
        if (this.referenceTokens.size() <= currentPosition) {
            return jsonValue;
        }
        String token = this.referenceTokens.get(currentPosition);
        if (jsonValue.getValueType() == JsonValue.ValueType.OBJECT) {
            JsonObject jsonObject = jsonValue.asJsonObject();
            JsonObjectBuilder objectBuilder = this.provider.createObjectBuilder();
            for (Map.Entry entry : jsonObject.entrySet()) {
                boolean matchesToken = token.equals(entry.getKey());
                if (matchesToken && currentPosition == this.referenceTokens.size() - 1) continue;
                if (matchesToken) {
                    objectBuilder.add((String)entry.getKey(), this.remove((JsonValue)entry.getValue(), currentPosition + 1));
                    continue;
                }
                objectBuilder.add((String)entry.getKey(), (JsonValue)entry.getValue());
            }
            return objectBuilder.build();
        }
        if (jsonValue.getValueType() == JsonValue.ValueType.ARRAY) {
            JsonArray jsonArray = jsonValue.asJsonArray();
            if ("-".equals(token) || IS_NUMBER.matcher(token).matches()) {
                int arrayIndex = this.getArrayIndex(token, jsonArray, false);
                JsonArrayBuilder arrayBuilder = this.provider.createArrayBuilder();
                int jsonArraySize = jsonArray.size();
                for (int i = 0; i < jsonArraySize; ++i) {
                    boolean matchesIndex;
                    boolean bl = matchesIndex = i == arrayIndex;
                    if (matchesIndex && currentPosition != this.referenceTokens.size() - 1) {
                        arrayBuilder.add(this.remove((JsonValue)jsonArray.get(i), currentPosition + 1));
                        continue;
                    }
                    if (matchesIndex) continue;
                    arrayBuilder.add((JsonValue)jsonArray.get(i));
                }
                return arrayBuilder.build();
            }
            return jsonArray;
        }
        return jsonValue;
    }

    private int getArrayIndex(String referenceToken, JsonArray jsonArray, boolean addOperation) {
        if (addOperation && referenceToken.equals("-")) {
            return jsonArray.size();
        }
        if (!addOperation && referenceToken.equals("-")) {
            int arrayIndex = jsonArray.size() - this.minusShift();
            this.validateArraySize(referenceToken, jsonArray, arrayIndex, jsonArray.size());
            return arrayIndex;
        }
        this.validateArrayIndex(referenceToken);
        try {
            int arrayIndex = Integer.parseInt(referenceToken);
            int arraySize = addOperation ? jsonArray.size() + 1 : jsonArray.size();
            this.validateArraySize(referenceToken, jsonArray, arrayIndex, arraySize);
            return arrayIndex;
        }
        catch (NumberFormatException e) {
            throw new JsonException("'" + referenceToken + "' is no valid array index", e);
        }
    }

    protected int minusShift() {
        return 1;
    }

    private void validateJsonPointer(JsonValue target, int size) throws NullPointerException, JsonException {
        if (target == null) {
            throw new NullPointerException("target must not be null");
        }
        JsonValue jsonValue = target;
        for (int i = 1; i < size; ++i) {
            jsonValue = this.getValue(jsonValue, this.referenceTokens.get(i), i, this.referenceTokens.size() - 1);
        }
    }

    private void validateArrayIndex(String referenceToken) throws JsonException {
        if (referenceToken.startsWith("-") && referenceToken.length() > 1) {
            throw new JsonException("An array index must not start with '" + referenceToken.charAt(0) + "'");
        }
        if (referenceToken.startsWith("0") && referenceToken.length() > 1) {
            throw new JsonException("An array index must not start with a leading '0'");
        }
    }

    private void validateArraySize(String referenceToken, JsonArray jsonArray, int arrayIndex, int arraySize) throws JsonException {
        if (arrayIndex >= arraySize) {
            throw new JsonException("'" + jsonArray + "' contains no element for index " + arrayIndex + " and for '" + referenceToken + "'.");
        }
        if (arrayIndex < 0) {
            throw new JsonException(arrayIndex + " is not a valid index for array '" + jsonArray + "' and for '" + referenceToken + "'.");
        }
    }
}

