/*
 * Decompiled with CFR 0.152.
 */
package org.talend.__shade__.org.apache.johnzon.mapper.reflection;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.talend.__shade__.org.apache.johnzon.mapper.reflection.JohnzonParameterizedType;

public final class Generics {
    private Generics() {
    }

    public static Map<Type, Type> toResolvedTypes(Type clazz) {
        if (ParameterizedType.class.isInstance(clazz)) {
            ParameterizedType parameterizedType = (ParameterizedType)ParameterizedType.class.cast(clazz);
            if (!Class.class.isInstance(parameterizedType.getRawType())) {
                return Collections.emptyMap();
            }
            Class raw = (Class)Class.class.cast(parameterizedType.getRawType());
            Type[] arguments = parameterizedType.getActualTypeArguments();
            if (arguments.length > 0) {
                TypeVariable<Class<T>>[] parameters = raw.getTypeParameters();
                HashMap<Type, Type> map = new HashMap<Type, Type>(parameters.length);
                for (int i = 0; i < parameters.length && i < arguments.length; ++i) {
                    map.put(parameters[i], arguments[i]);
                }
                return map;
            }
        }
        return Collections.emptyMap();
    }

    public static Type resolve(Type value, Type rootClass, Map<Type, Type> resolved) {
        if (TypeVariable.class.isInstance(value)) {
            return Generics.resolveTypeVariable(value, rootClass, resolved);
        }
        if (ParameterizedType.class.isInstance(value)) {
            return Generics.resolveParameterizedType(value, rootClass, resolved);
        }
        if (WildcardType.class.isInstance(value)) {
            return Generics.resolveWildcardType(value);
        }
        return value;
    }

    private static Type resolveWildcardType(Type value) {
        WildcardType wildcardType = (WildcardType)WildcardType.class.cast(value);
        if (Stream.of(wildcardType.getUpperBounds()).anyMatch(it -> it == Object.class) && wildcardType.getLowerBounds().length == 0) {
            return Object.class;
        }
        return value;
    }

    private static Type resolveParameterizedType(Type value, Type rootClass, Map<Type, Type> resolved) {
        ArrayList<Type> args = null;
        ParameterizedType parameterizedType = (ParameterizedType)ParameterizedType.class.cast(value);
        int index = 0;
        for (Type arg : parameterizedType.getActualTypeArguments()) {
            Type type = Generics.resolve(arg, rootClass, resolved);
            if (type != arg && args == null) {
                args = new ArrayList<Type>();
                if (index > 0) {
                    args.addAll(Arrays.asList(parameterizedType.getActualTypeArguments()).subList(0, index));
                }
            }
            if (args != null) {
                args.add(type);
            }
            ++index;
        }
        if (args != null) {
            return new JohnzonParameterizedType(parameterizedType.getRawType(), args.toArray(new Type[args.size()]));
        }
        return value;
    }

    private static Type resolveTypeVariable(Type value, Type rootClass, Map<Type, Type> resolved) {
        ParameterizedType parentPt;
        int argIndex;
        Type alreadyResolved = resolved.get(value);
        if (alreadyResolved != null) {
            return alreadyResolved;
        }
        TypeVariable tv = (TypeVariable)TypeVariable.class.cast(value);
        Type parent = rootClass;
        while (Class.class.isInstance(parent)) {
            parent = ((Class)Class.class.cast(parent)).getGenericSuperclass();
        }
        while (ParameterizedType.class.isInstance(parent) && ((ParameterizedType)ParameterizedType.class.cast(parent)).getRawType() != tv.getGenericDeclaration()) {
            parent = ((Class)Class.class.cast(((ParameterizedType)ParameterizedType.class.cast(parent)).getRawType())).getGenericSuperclass();
        }
        if (ParameterizedType.class.isInstance(parent) && (argIndex = Arrays.asList(((Class)Class.class.cast((parentPt = (ParameterizedType)ParameterizedType.class.cast(parent)).getRawType())).getTypeParameters()).indexOf(tv)) >= 0) {
            Type type = parentPt.getActualTypeArguments()[argIndex];
            if (TypeVariable.class.isInstance(type)) {
                return Generics.resolveTypeVariable(type, rootClass, resolved);
            }
            return type;
        }
        if (Class.class.isInstance(rootClass)) {
            return Object.class;
        }
        return value;
    }
}

