/*
 * Decompiled with CFR 0.152.
 */
package org.talend.__shade__.org.apache.johnzon.jsonb.order;

import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PerHierarchyAndLexicographicalOrderFieldComparator
implements Comparator<String> {
    private final Class<?> clazz;
    private final Map<String, Integer> distances = new ConcurrentHashMap<String, Integer>();

    public PerHierarchyAndLexicographicalOrderFieldComparator(Class<?> clazz) {
        this.clazz = clazz;
    }

    @Override
    public int compare(String o1, String o2) {
        if (o1.equals(o2)) {
            return 0;
        }
        int d1 = this.distance(o1);
        int d2 = this.distance(o2);
        int res = d2 - d1;
        if (res == 0) {
            return o1.compareTo(o2);
        }
        return res;
    }

    private int distance(String o1) {
        return this.distances.computeIfAbsent(o1, this::slowDistance);
    }

    private int slowDistance(String o1) {
        int i = 0;
        for (Class<?> current = this.clazz; current != null && current != Object.class; current = current.getSuperclass()) {
            try {
                current.getDeclaredField(o1);
                return i;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                String methodSuffix = Character.toUpperCase(o1.charAt(0)) + (o1.length() > 1 ? o1.substring(1) : "");
                try {
                    current.getDeclaredMethod("get" + methodSuffix, new Class[0]);
                    return i;
                }
                catch (Exception exception) {
                    try {
                        current.getDeclaredMethod("is" + methodSuffix, new Class[0]);
                        return i;
                    }
                    catch (Exception exception2) {
                        ++i;
                        continue;
                    }
                }
            }
        }
        return i;
    }
}

