/*
 * Decompiled with CFR 0.152.
 */
package org.talend.__shade__.org.apache.johnzon.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.talend.__shade__.javax.json.JsonException;

final class RFC4627AwareInputStreamReader
extends InputStreamReader {
    RFC4627AwareInputStreamReader(InputStream in) {
        this(new PushbackInputStream(in, 4));
    }

    private RFC4627AwareInputStreamReader(PushbackInputStream in) {
        super((InputStream)in, RFC4627AwareInputStreamReader.getCharset(in).newDecoder());
    }

    private static byte[] readAllBytes(PushbackInputStream inputStream) throws IOException {
        int first = inputStream.read();
        if (first == -1) {
            return new byte[0];
        }
        int second = inputStream.read();
        if (second == -1) {
            return new byte[]{(byte)first};
        }
        int third = inputStream.read();
        int fourth = inputStream.read();
        if (third == -1) {
            return new byte[]{(byte)first, (byte)second};
        }
        if (fourth == -1) {
            return new byte[]{(byte)first, (byte)second, (byte)third};
        }
        return new byte[]{(byte)first, (byte)second, (byte)third, (byte)fourth};
    }

    private static Charset getCharset(PushbackInputStream inputStream) {
        Charset charset = StandardCharsets.UTF_8;
        int bomLength = 0;
        try {
            byte[] utfBytes = RFC4627AwareInputStreamReader.readAllBytes(inputStream);
            if (utfBytes.length == 0) {
                return StandardCharsets.UTF_8;
            }
            if (utfBytes.length == 1) {
                if (utfBytes[0] == 0) {
                    throw new JsonException("Unknown encoding");
                }
                inputStream.unread(utfBytes);
                return StandardCharsets.UTF_8;
            }
            int first = utfBytes[0] & 0xFF;
            int second = utfBytes[1] & 0xFF;
            if (first == 0) {
                charset = second == 0 ? Charset.forName("UTF-32BE") : Charset.forName("UTF-16BE");
            } else if (utfBytes.length > 2 && second == 0) {
                int third = utfBytes[2] & 0xFF;
                charset = third == 0 ? Charset.forName("UTF-32LE") : Charset.forName("UTF-16LE");
            } else if (first == 254 && second == 255) {
                charset = Charset.forName("UTF-16BE");
                bomLength = 2;
            } else if (first == 255 && second == 254) {
                if (utfBytes.length > 3 && (utfBytes[2] & 0xFF) == 0 && (utfBytes[3] & 0xFF) == 0) {
                    charset = Charset.forName("UTF-32LE");
                    bomLength = 4;
                } else {
                    charset = Charset.forName("UTF-16LE");
                    bomLength = 2;
                }
            } else if (utfBytes.length > 2 && first == 239 && second == 187 && (utfBytes[2] & 0xFF) == 191) {
                bomLength = 3;
            }
            if (bomLength > 0 && bomLength < 4) {
                inputStream.unread(utfBytes, bomLength, utfBytes.length - bomLength);
            } else {
                inputStream.unread(utfBytes);
            }
        }
        catch (IOException e) {
            throw new JsonException("Unable to detect charset due to " + e.getMessage(), e);
        }
        return charset;
    }
}

