/*
 * Decompiled with CFR 0.152.
 */
package org.talend.__shade__.org.apache.johnzon.jsonb.api.experimental;

import java.util.function.Function;
import java.util.function.Predicate;

public class PolymorphicConfig {
    private Function<String, Class<?>> typeLoader = a -> {
        throw new IllegalArgumentException("Unknown alias: '" + a + "'");
    };
    private Function<Class<?>, String> discriminatorMapper = type -> {
        throw new IllegalArgumentException("Unknown class '" + type.getName() + "'");
    };
    private Predicate<Class<?>> serializationPredicate = c -> false;
    private Predicate<Class<?>> deserializationPredicate = c -> false;
    private String discriminator = "@type";

    public PolymorphicConfig withDeserializationPredicate(Predicate<Class<?>> deserializationPredicate) {
        this.deserializationPredicate = deserializationPredicate;
        return this;
    }

    public PolymorphicConfig withSerializationPredicate(Predicate<Class<?>> serializationPredicate) {
        this.serializationPredicate = serializationPredicate;
        return this;
    }

    public PolymorphicConfig withDiscriminatorMapper(Function<Class<?>, String> discriminatorMapper) {
        this.discriminatorMapper = discriminatorMapper;
        return this;
    }

    public PolymorphicConfig withTypeLoader(Function<String, Class<?>> typeLoader) {
        this.typeLoader = typeLoader;
        return this;
    }

    public PolymorphicConfig withDiscriminator(String value) {
        this.discriminator = value;
        return this;
    }

    public Predicate<Class<?>> getDeserializationPredicate() {
        return this.deserializationPredicate;
    }

    public Function<String, Class<?>> getTypeLoader() {
        return this.typeLoader;
    }

    public Function<Class<?>, String> getDiscriminatorMapper() {
        return this.discriminatorMapper;
    }

    public Predicate<Class<?>> getSerializationPredicate() {
        return this.serializationPredicate;
    }

    public String getDiscriminator() {
        return this.discriminator;
    }
}

