/*
 * Decompiled with CFR 0.152.
 */
package org.talend.__shade__.org.apache.johnzon.core;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.talend.__shade__.javax.json.JsonArray;
import org.talend.__shade__.javax.json.JsonNumber;
import org.talend.__shade__.javax.json.JsonObject;
import org.talend.__shade__.javax.json.JsonString;
import org.talend.__shade__.javax.json.JsonValue;
import org.talend.__shade__.org.apache.johnzon.core.BufferStrategy;
import org.talend.__shade__.org.apache.johnzon.core.JsonGeneratorImpl;
import org.talend.__shade__.org.apache.johnzon.core.SerializableValue;

class JsonArrayImpl
extends AbstractList<JsonValue>
implements JsonArray,
Serializable {
    private final BufferStrategy.BufferProvider<char[]> provider;
    private Integer hashCode = null;
    private final List<JsonValue> unmodifieableBackingList;
    private int size = -1;

    JsonArrayImpl(List<JsonValue> backingList, BufferStrategy.BufferProvider<char[]> provider) {
        this.unmodifieableBackingList = backingList;
        this.provider = provider;
    }

    private <T> T value(int idx, Class<T> type) {
        if (idx > this.unmodifieableBackingList.size()) {
            throw new IndexOutOfBoundsException(idx + "/" + this.unmodifieableBackingList.size());
        }
        return type.cast(this.unmodifieableBackingList.get(idx));
    }

    @Override
    public JsonObject getJsonObject(int index) {
        return this.value(index, JsonObject.class);
    }

    @Override
    public JsonArray getJsonArray(int index) {
        return this.value(index, JsonArray.class);
    }

    @Override
    public JsonNumber getJsonNumber(int index) {
        return this.value(index, JsonNumber.class);
    }

    @Override
    public JsonString getJsonString(int index) {
        return this.value(index, JsonString.class);
    }

    @Override
    public <T extends JsonValue> List<T> getValuesAs(Class<T> clazz) {
        return this.unmodifieableBackingList;
    }

    @Override
    public String getString(int index) {
        return this.value(index, JsonString.class).getString();
    }

    @Override
    public String getString(int index, String defaultValue) {
        JsonValue val = null;
        int s = this.size;
        if (s == -1) {
            this.size = s = this.unmodifieableBackingList.size();
        }
        if (index > s - 1 || !((val = this.get(index)) instanceof JsonString)) {
            return defaultValue;
        }
        return ((JsonString)JsonString.class.cast(val)).getString();
    }

    @Override
    public int getInt(int index) {
        return this.value(index, JsonNumber.class).intValue();
    }

    @Override
    public int getInt(int index, int defaultValue) {
        JsonValue val = null;
        int s = this.size;
        if (s == -1) {
            this.size = s = this.unmodifieableBackingList.size();
        }
        if (index > s - 1 || !((val = this.get(index)) instanceof JsonNumber)) {
            return defaultValue;
        }
        return ((JsonNumber)JsonNumber.class.cast(val)).intValue();
    }

    @Override
    public boolean getBoolean(int index) {
        JsonValue val = this.value(index, JsonValue.class);
        if (JsonValue.ValueType.TRUE == val.getValueType()) {
            return true;
        }
        if (JsonValue.ValueType.FALSE == val.getValueType()) {
            return false;
        }
        throw new ClassCastException();
    }

    @Override
    public boolean getBoolean(int index, boolean defaultValue) {
        int s = this.size;
        if (s == -1) {
            this.size = s = this.unmodifieableBackingList.size();
        }
        if (index > s - 1) {
            return defaultValue;
        }
        JsonValue.ValueType valueType = this.get(index).getValueType();
        return JsonValue.ValueType.TRUE == valueType || JsonValue.ValueType.FALSE != valueType && defaultValue;
    }

    @Override
    public boolean isNull(int index) {
        return JsonValue.ValueType.NULL == this.value(index, JsonValue.class).getValueType();
    }

    @Override
    public JsonValue.ValueType getValueType() {
        return JsonValue.ValueType.ARRAY;
    }

    @Override
    public String toString() {
        if (this.unmodifieableBackingList.isEmpty()) {
            return "[]";
        }
        StringWriter writer = new StringWriter(2048);
        try (JsonGeneratorImpl generator = new JsonGeneratorImpl(writer, this.provider, false);){
            generator.writeStartArray();
            this.unmodifieableBackingList.forEach(generator::write);
            generator.writeEnd();
        }
        return writer.toString();
    }

    @Override
    public boolean equals(Object obj) {
        return List.class.isInstance(obj) && super.equals(obj);
    }

    @Override
    public int hashCode() {
        Integer h = this.hashCode;
        if (h == null) {
            this.hashCode = h = Integer.valueOf(this.unmodifieableBackingList.hashCode());
        }
        return h;
    }

    @Override
    public JsonValue get(int index) {
        return this.unmodifieableBackingList.get(index);
    }

    @Override
    public int size() {
        return this.unmodifieableBackingList.size();
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SerializableValue(this.toString());
    }

    @Override
    public Iterator<JsonValue> iterator() {
        return new JsonArrayIterator();
    }

    private class JsonArrayIterator
    implements Iterator<JsonValue> {
        private int cursor = 0;

        private JsonArrayIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor != JsonArrayImpl.this.unmodifieableBackingList.size();
        }

        @Override
        public JsonValue next() {
            try {
                int i = this.cursor;
                JsonValue next = (JsonValue)JsonArrayImpl.this.unmodifieableBackingList.get(i);
                this.cursor = i + 1;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }
    }
}

